/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactdisplaylabel_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactdisplaylabel.h>
#include <qcontactfilter.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactDisplayLabel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactDisplayLabel >()))
        return -1;

    QtMobility::QContactDisplayLabel* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactDisplayLabel", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactDisplayLabel(QtMobility::QContactDisplayLabel)
    // 1: QContactDisplayLabel()
    // 2: QContactDisplayLabel(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactDisplayLabel()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactDisplayLabel(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDisplayLabel & >::isConvertible(arg)) {
        overloadId = 0; // QContactDisplayLabel(QtMobility::QContactDisplayLabel)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDisplayLabel_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactDisplayLabel(QtMobility::QContactDisplayLabel)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactDisplayLabel > cpp_arg0_auto_ptr;
                QtMobility::QContactDisplayLabel* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDisplayLabel* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactDisplayLabel >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactDisplayLabel >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactDisplayLabel(QtMobility::QContactDisplayLabel)
                cptr = new QtMobility::QContactDisplayLabel(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactDisplayLabel()
            {

                if(!PyErr_Occurred()) {
                // QContactDisplayLabel()
                cptr = new QtMobility::QContactDisplayLabel();
                }
                break;
            }
            case 2: // QContactDisplayLabel(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactDisplayLabel(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactDisplayLabel(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactDisplayLabel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactDisplayLabel_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactDisplayLabel_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDisplayLabel", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDisplayLabel", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactDisplayLabelFunc_label(PyObject* self)
{
    QtMobility::QContactDisplayLabel* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDisplayLabel* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // label()const
            QString cppResult = cppSelf->QtMobility::QContactDisplayLabel::label();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDisplayLabelFunc_match(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: match(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // match(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDisplayLabelFunc_match_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // match(QString)
            QtMobility::QContactFilter cppResult = QtMobility::QContactDisplayLabel::match(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QContactFilter >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDisplayLabelFunc_match_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDisplayLabel.match", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactDisplayLabel_methods[] = {
    {"label", (PyCFunction)SbkQtMobility_QContactDisplayLabelFunc_label, METH_NOARGS},
    {"match", (PyCFunction)SbkQtMobility_QContactDisplayLabelFunc_match, METH_O|METH_STATIC},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactDisplayLabel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactDisplayLabel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactDisplayLabel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactDisplayLabel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactDisplayLabel >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactDisplayLabel",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactDisplayLabel(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDISPLAYLABEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactDisplayLabel_Type);

    SbkQtMobility_QContactDisplayLabel_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactDisplayLabel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactDisplayLabel_Type));
    PyModule_AddObject(module, "QContactDisplayLabel",
        ((PyObject*)&SbkQtMobility_QContactDisplayLabel_Type));

    PyDict_SetItemString(SbkQtMobility_QContactDisplayLabel_Type.super.ht_type.tp_dict, "FieldLabel", Shiboken::Converter<QString >::toPython(QtMobility::QContactDisplayLabel::FieldLabel));
    PyDict_SetItemString(SbkQtMobility_QContactDisplayLabel_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactDisplayLabel::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDisplayLabel >("QtMobility::QContactDisplayLabel");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactDisplayLabel >("QtMobility::QContactDisplayLabel*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDisplayLabel >(typeid(QtMobility::QContactDisplayLabel).name());
    PySide::initQtMetaType<QtMobility::QContactDisplayLabel >();
}

