/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactdetailfilter_wrapper.h"

// Extra includes
#include <qcontactfilter.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactDetailFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactDetailFilter >()))
        return -1;

    QtMobility::QContactDetailFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactDetailFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactDetailFilter(QtMobility::QContactDetailFilter)
    // 1: QContactDetailFilter()
    // 2: QContactDetailFilter(QtMobility::QContactFilter)
    if (numArgs == 0) {
        overloadId = 1; // QContactDetailFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 2; // QContactDetailFilter(QtMobility::QContactFilter)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetailFilter & >::isConvertible(arg)) {
        overloadId = 0; // QContactDetailFilter(QtMobility::QContactDetailFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactDetailFilter(QtMobility::QContactDetailFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactDetailFilter > cpp_arg0_auto_ptr;
                QtMobility::QContactDetailFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactDetailFilter >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactDetailFilter >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactDetailFilter(QtMobility::QContactDetailFilter)
                cptr = new QtMobility::QContactDetailFilter(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactDetailFilter()
            {

                if(!PyErr_Occurred()) {
                // QContactDetailFilter()
                cptr = new QtMobility::QContactDetailFilter();
                }
                break;
            }
            case 2: // QContactDetailFilter(QtMobility::QContactFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactDetailFilter(QtMobility::QContactFilter)
                cptr = new QtMobility::QContactDetailFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactDetailFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactDetailFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactDetailFilter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailFilter", "", "QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDetailFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_detailDefinitionName(PyObject* self)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailDefinitionName()const
            QString cppResult = cppSelf->QtMobility::QContactDetailFilter::detailDefinitionName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_detailFieldName(PyObject* self)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailFieldName()const
            QString cppResult = cppSelf->QtMobility::QContactDetailFilter::detailFieldName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_matchFlags(PyObject* self)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // matchFlags()const
            QFlags<QtMobility::QContactFilter::MatchFlag> cppResult = cppSelf->QtMobility::QContactDetailFilter::matchFlags();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QContactFilter::MatchFlag> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_setDetailDefinitionName(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "fieldName" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactDetailFilter.setDetailDefinitionName(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactDetailFilter.setDetailDefinitionName(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactDetailFilter.setDetailDefinitionName(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:setDetailDefinitionName", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setDetailDefinitionName(QString,QString)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // setDetailDefinitionName(QString,QString)
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // setDetailDefinitionName(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFilterFunc_setDetailDefinitionName_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "fieldName");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "fieldName";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactDetailFilter.setDetailDefinitionName(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QString();

            if(!PyErr_Occurred()) {
            // setDetailDefinitionName(QString,QString)
            cppSelf->QtMobility::QContactDetailFilter::setDetailDefinitionName(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFilterFunc_setDetailDefinitionName_TypeError:
        const char* overloads[] = {"QString, QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDetailFilter.setDetailDefinitionName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_setMatchFlags(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setMatchFlags(QFlags<QtMobility::QContactFilter::MatchFlag>)
    if (Shiboken::Converter<QFlags<QtMobility::QContactFilter::MatchFlag> >::isConvertible(arg)) {
        overloadId = 0; // setMatchFlags(QFlags<QtMobility::QContactFilter::MatchFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFilterFunc_setMatchFlags_TypeError;

    // Call function/method
    {
        {
            QFlags<QtMobility::QContactFilter::MatchFlag> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QContactFilter::MatchFlag> >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setMatchFlags(QFlags<QtMobility::QContactFilter::MatchFlag>)
            cppSelf->QtMobility::QContactDetailFilter::setMatchFlags(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFilterFunc_setMatchFlags_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter.MatchFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetailFilter.setMatchFlags", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_setValue(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setValue(QVariant)
    if (Shiboken::Converter<QVariant >::isConvertible(arg)) {
        overloadId = 0; // setValue(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFilterFunc_setValue_TypeError;

    // Call function/method
    {
        {
            QVariant cpp_arg0 = Shiboken::Converter<QVariant >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setValue(QVariant)
            cppSelf->QtMobility::QContactDetailFilter::setValue(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFilterFunc_setValue_TypeError:
        const char* overloads[] = {"QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetailFilter.setValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFilterFunc_value(PyObject* self)
{
    QtMobility::QContactDetailFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // value()const
            QVariant cppResult = cppSelf->QtMobility::QContactDetailFilter::value();
            pyResult = Shiboken::Converter<QVariant >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactDetailFilter_methods[] = {
    {"detailDefinitionName", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_detailDefinitionName, METH_NOARGS},
    {"detailFieldName", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_detailFieldName, METH_NOARGS},
    {"matchFlags", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_matchFlags, METH_NOARGS},
    {"setDetailDefinitionName", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_setDetailDefinitionName, METH_VARARGS|METH_KEYWORDS},
    {"setMatchFlags", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_setMatchFlags, METH_O},
    {"setValue", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_setValue, METH_O},
    {"value", (PyCFunction)SbkQtMobility_QContactDetailFilterFunc_value, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactDetailFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactDetailFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactDetailFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactDetailFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactDetailFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactDetailFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactDetailFilter(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactDetailFilter_Type);

    SbkQtMobility_QContactDetailFilter_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactDetailFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactDetailFilter_Type));
    PyModule_AddObject(module, "QContactDetailFilter",
        ((PyObject*)&SbkQtMobility_QContactDetailFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDetailFilter >("QtMobility::QContactDetailFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactDetailFilter >("QtMobility::QContactDetailFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDetailFilter >(typeid(QtMobility::QContactDetailFilter).name());
    PySide::initQtMetaType<QtMobility::QContactDetailFilter >();
}

