/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactdetail_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactDetail_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactDetail >()))
        return -1;

    QtMobility::QContactDetail* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactDetail", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QContactDetail()
    // 1: QContactDetail(QString)
    // 2: QContactDetail(QtMobility::QContactDetail)
    // 3: QContactDetail(QtMobility::QContactDetail,QString)
    // 4: QContactDetail(QtMobility::QContactDetail,const char*)
    // 5: QContactDetail(const char*)
    if (numArgs == 0) {
        overloadId = 0; // QContactDetail()
    } else if (numArgs == 1 && Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        overloadId = 5; // QContactDetail(const char*)
    } else if (Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 2; // QContactDetail(QtMobility::QContactDetail)
        } else if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            overloadId = 4; // QContactDetail(QtMobility::QContactDetail,const char*)
        } else if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 3; // QContactDetail(QtMobility::QContactDetail,QString)
        }
    } else if (numArgs == 1 && Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        overloadId = 1; // QContactDetail(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetail_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactDetail()
            {

                if(!PyErr_Occurred()) {
                // QContactDetail()
                cptr = new QtMobility::QContactDetail();
                }
                break;
            }
            case 1: // QContactDetail(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QContactDetail(QString)
                cptr = new QtMobility::QContactDetail(cpp_arg0);
                }
                break;
            }
            case 2: // QContactDetail(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QContactDetail(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactDetail(*cpp_arg0);
                }
                break;
            }
            case 3: // QContactDetail(QtMobility::QContactDetail,QString)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // QContactDetail(QtMobility::QContactDetail,QString)
                cptr = new QtMobility::QContactDetail(*cpp_arg0, cpp_arg1);
                }
                break;
            }
            case 4: // QContactDetail(QtMobility::QContactDetail,const char*)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[0]);
                const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // QContactDetail(QtMobility::QContactDetail,const char*)
                cptr = new QtMobility::QContactDetail(*cpp_arg0, cpp_arg1);
                }
                break;
            }
            case 5: // QContactDetail(const char*)
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QContactDetail(const char*)
                cptr = new QtMobility::QContactDetail(cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactDetail >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactDetail_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactDetail_Init_TypeError:
        const char* overloads[] = {"", "QString", "QtMobility.Contacts.QtMobility::QContactDetail", "QtMobility.Contacts.QtMobility::QContactDetail, QString", "QtMobility.Contacts.QtMobility::QContactDetail, str", "str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDetail", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactDetailFunc_accessConstraints(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // accessConstraints()const
            QFlags<QtMobility::QContactDetail::AccessConstraint> cppResult = cppSelf->QtMobility::QContactDetail::accessConstraints();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QContactDetail::AccessConstraint> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_assign(PyObject* self, PyObject* args)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "assign", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: assign(QtMobility::QContactDetail,QString)
    // 1: assign(QtMobility::QContactDetail,const char*)
    if (Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(pyargs[0])) {
        if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            overloadId = 1; // assign(QtMobility::QContactDetail,const char*)
        } else if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // assign(QtMobility::QContactDetail,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_assign_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // assign(QtMobility::QContactDetail,QString)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // assign(QtMobility::QContactDetail,QString)
                QtMobility::QContactDetail & cppResult = cppSelf->QtMobility::QContactDetail::assign(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QContactDetail & >::toPython(cppResult);
                }
                break;
            }
            case 1: // assign(QtMobility::QContactDetail,const char*)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[0]);
                const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // assign(QtMobility::QContactDetail,const char*)
                QtMobility::QContactDetail & cppResult = cppSelf->QtMobility::QContactDetail::assign(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QContactDetail & >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDetailFunc_assign_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetail, QString", "QtMobility.Contacts.QtMobility::QContactDetail, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDetail.assign", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_contexts(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // contexts()const
            QStringList cppResult = cppSelf->QtMobility::QContactDetail::contexts();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_definitionName(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // definitionName()const
            QString cppResult = cppSelf->QtMobility::QContactDetail::definitionName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_detailUri(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailUri()const
            QString cppResult = cppSelf->QtMobility::QContactDetail::detailUri();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_hasValue(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: hasValue(QString)const
    // 1: hasValue(const char*)const
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 1; // hasValue(const char*)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // hasValue(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_hasValue_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // hasValue(QString)const
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // hasValue(QString)const
                bool cppResult = cppSelf->QtMobility::QContactDetail::hasValue(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // hasValue(const char*)const
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // hasValue(const char*)const
                bool cppResult = cppSelf->QtMobility::QContactDetail::hasValue(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDetailFunc_hasValue_TypeError:
        const char* overloads[] = {"QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.hasValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_isEmpty(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QContactDetail::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_key(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // key()const
            int cppResult = cppSelf->QtMobility::QContactDetail::key();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_linkedDetailUris(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // linkedDetailUris()const
            QStringList cppResult = cppSelf->QtMobility::QContactDetail::linkedDetailUris();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFunc_removeValue(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeValue(QString)
    // 1: removeValue(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 1; // removeValue(const char*)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // removeValue(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_removeValue_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // removeValue(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // removeValue(QString)
                bool cppResult = cppSelf->QtMobility::QContactDetail::removeValue(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // removeValue(const char*)
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // removeValue(const char*)
                bool cppResult = cppSelf->QtMobility::QContactDetail::removeValue(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDetailFunc_removeValue_TypeError:
        const char* overloads[] = {"QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.removeValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_resetKey(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // resetKey()
            cppSelf->QtMobility::QContactDetail::resetKey();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactDetailFunc_setContexts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setContexts(QString)
    // 1: setContexts(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 1; // setContexts(QStringList)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setContexts(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_setContexts_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setContexts(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setContexts(QString)
                cppSelf->QtMobility::QContactDetail::setContexts(cpp_arg0);
                }
                break;
            }
            case 1: // setContexts(QStringList)
            {
                QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setContexts(QStringList)
                cppSelf->QtMobility::QContactDetail::setContexts(cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFunc_setContexts_TypeError:
        const char* overloads[] = {"QString", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.setContexts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_setDetailUri(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDetailUri(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setDetailUri(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_setDetailUri_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDetailUri(QString)
            cppSelf->QtMobility::QContactDetail::setDetailUri(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFunc_setDetailUri_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.setDetailUri", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_setLinkedDetailUris(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLinkedDetailUris(QString)
    // 1: setLinkedDetailUris(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 1; // setLinkedDetailUris(QStringList)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setLinkedDetailUris(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_setLinkedDetailUris_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setLinkedDetailUris(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setLinkedDetailUris(QString)
                cppSelf->QtMobility::QContactDetail::setLinkedDetailUris(cpp_arg0);
                }
                break;
            }
            case 1: // setLinkedDetailUris(QStringList)
            {
                QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setLinkedDetailUris(QStringList)
                cppSelf->QtMobility::QContactDetail::setLinkedDetailUris(cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFunc_setLinkedDetailUris_TypeError:
        const char* overloads[] = {"QString", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.setLinkedDetailUris", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_setValue(PyObject* self, PyObject* args)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setValue(QString,QVariant)
    // 1: setValue(const char*,QVariant)
    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[1])) {
        overloadId = 1; // setValue(const char*,QVariant)
    } else if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[1])) {
        overloadId = 0; // setValue(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_setValue_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setValue(QString,QVariant)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QVariant cpp_arg1 = Shiboken::Converter<QVariant >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // setValue(QString,QVariant)
                bool cppResult = cppSelf->QtMobility::QContactDetail::setValue(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // setValue(const char*,QVariant)
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
                QVariant cpp_arg1 = Shiboken::Converter<QVariant >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // setValue(const char*,QVariant)
                bool cppResult = cppSelf->QtMobility::QContactDetail::setValue(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDetailFunc_setValue_TypeError:
        const char* overloads[] = {"QString, QVariant", "str, QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDetail.setValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_value(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: value(QString)const
    // 1: value(const char*)const
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 1; // value(const char*)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // value(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_value_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // value(QString)const
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // value(QString)const
                QString cppResult = cppSelf->QtMobility::QContactDetail::value(cpp_arg0);
                pyResult = Shiboken::Converter<QString >::toPython(cppResult);
                }
                break;
            }
            case 1: // value(const char*)const
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // value(const char*)const
                QString cppResult = cppSelf->QtMobility::QContactDetail::value(cpp_arg0);
                pyResult = Shiboken::Converter<QString >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDetailFunc_value_TypeError:
        const char* overloads[] = {"QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.value", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_variantValue(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: variantValue(QString)const
    // 1: variantValue(const char*)const
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 1; // variantValue(const char*)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // variantValue(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFunc_variantValue_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // variantValue(QString)const
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // variantValue(QString)const
                QVariant cppResult = cppSelf->QtMobility::QContactDetail::variantValue(cpp_arg0);
                pyResult = Shiboken::Converter<QVariant >::toPython(cppResult);
                }
                break;
            }
            case 1: // variantValue(const char*)const
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // variantValue(const char*)const
                QVariant cppResult = cppSelf->QtMobility::QContactDetail::variantValue(cpp_arg0);
                pyResult = Shiboken::Converter<QVariant >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactDetailFunc_variantValue_TypeError:
        const char* overloads[] = {"QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetail.variantValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFunc_variantValues(PyObject* self)
{
    QtMobility::QContactDetail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // variantValues()const
            QMap<QString, QVariant > cppResult = cppSelf->QtMobility::QContactDetail::variantValues();
            pyResult = Shiboken::Converter<QMap<QString, QVariant > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactDetail_methods[] = {
    {"accessConstraints", (PyCFunction)SbkQtMobility_QContactDetailFunc_accessConstraints, METH_NOARGS},
    {"assign", (PyCFunction)SbkQtMobility_QContactDetailFunc_assign, METH_VARARGS},
    {"contexts", (PyCFunction)SbkQtMobility_QContactDetailFunc_contexts, METH_NOARGS},
    {"definitionName", (PyCFunction)SbkQtMobility_QContactDetailFunc_definitionName, METH_NOARGS},
    {"detailUri", (PyCFunction)SbkQtMobility_QContactDetailFunc_detailUri, METH_NOARGS},
    {"hasValue", (PyCFunction)SbkQtMobility_QContactDetailFunc_hasValue, METH_O},
    {"isEmpty", (PyCFunction)SbkQtMobility_QContactDetailFunc_isEmpty, METH_NOARGS},
    {"key", (PyCFunction)SbkQtMobility_QContactDetailFunc_key, METH_NOARGS},
    {"linkedDetailUris", (PyCFunction)SbkQtMobility_QContactDetailFunc_linkedDetailUris, METH_NOARGS},
    {"removeValue", (PyCFunction)SbkQtMobility_QContactDetailFunc_removeValue, METH_O},
    {"resetKey", (PyCFunction)SbkQtMobility_QContactDetailFunc_resetKey, METH_NOARGS},
    {"setContexts", (PyCFunction)SbkQtMobility_QContactDetailFunc_setContexts, METH_O},
    {"setDetailUri", (PyCFunction)SbkQtMobility_QContactDetailFunc_setDetailUri, METH_O},
    {"setLinkedDetailUris", (PyCFunction)SbkQtMobility_QContactDetailFunc_setLinkedDetailUris, METH_O},
    {"setValue", (PyCFunction)SbkQtMobility_QContactDetailFunc_setValue, METH_VARARGS},
    {"value", (PyCFunction)SbkQtMobility_QContactDetailFunc_value, METH_O},
    {"variantValue", (PyCFunction)SbkQtMobility_QContactDetailFunc_variantValue, METH_O},
    {"variantValues", (PyCFunction)SbkQtMobility_QContactDetailFunc_variantValues, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContactDetail_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContactDetail& cpp_self = *Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContactDetail & other) const
                QtMobility::QContactDetail* cpp_other = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactDetail  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContactDetail_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(other)) {
                // operator==(const QtMobility::QContactDetail & other) const
                QtMobility::QContactDetail* cpp_other = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactDetail  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContactDetail_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContactDetail_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QContactDetail_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QContactDetail >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactDetail_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactDetail",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QContactDetail_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContactDetail_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactDetail_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactDetail_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactDetail >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactDetail",
    /*user_data*/           0
};
} //extern

PyObject* SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::checkType(self) && Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toPython(
        Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints>::toCpp(self)
        & Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::checkType(self) && Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toPython(
        Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints>::toCpp(self)
        | Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::checkType(self) && Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toPython(
        Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QContactDetail::AccessConstraints >::toPython(
        ~Shiboken::Converter<QtMobility::QContactDetail::AccessConstraints >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AccessConstraint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraints_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AccessConstraints",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QContactDetail(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactDetail_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactDetail_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactDetail_Type));
    PyModule_AddObject(module, "QContactDetail",
        ((PyObject*)&SbkQtMobility_QContactDetail_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: AccessConstraint
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_ACCESSCONSTRAINT_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type);
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict,
            "AccessConstraint",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type));

    // init flags class: QFlags<QtMobility::QContactDetail::AccessConstraint>
    SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTDETAIL_ACCESSCONSTRAINT__IDX] = &SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraints_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraints_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraints_Type);
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict,
            "AccessConstraints",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraints_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type,
        (long) QtMobility::QContactDetail::NoConstraint, "NoConstraint");
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict,
        "NoConstraint", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type.tp_dict,
        "NoConstraint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type,
        (long) QtMobility::QContactDetail::ReadOnly, "ReadOnly");
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict,
        "ReadOnly", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type.tp_dict,
        "ReadOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type,
        (long) QtMobility::QContactDetail::Irremovable, "Irremovable");
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict,
        "Irremovable", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactDetail_AccessConstraint_Type.tp_dict,
        "Irremovable", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactDetail::AccessConstraint");

    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict, "FieldDetailUri", Shiboken::Converter<QString >::toPython(QtMobility::QContactDetail::FieldDetailUri));
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict, "FieldLinkedDetailUris", Shiboken::Converter<QString >::toPython(QtMobility::QContactDetail::FieldLinkedDetailUris));
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict, "FieldContext", Shiboken::Converter<QString >::toPython(QtMobility::QContactDetail::FieldContext));
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict, "ContextOther", Shiboken::Converter<QString >::toPython(QtMobility::QContactDetail::ContextOther));
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict, "ContextWork", Shiboken::Converter<QString >::toPython(QtMobility::QContactDetail::ContextWork));
    PyDict_SetItemString(SbkQtMobility_QContactDetail_Type.super.ht_type.tp_dict, "ContextHome", Shiboken::Converter<QString >::toPython(QtMobility::QContactDetail::ContextHome));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDetail >("QtMobility::QContactDetail");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactDetail >("QtMobility::QContactDetail*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDetail >(typeid(QtMobility::QContactDetail).name());
    PySide::initQtMetaType<QtMobility::QContactDetail >();
}

