/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactchangeset_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <QSet>
#include <qcontactchangeset.h>
#include <qcontactmanagerengine.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactChangeSet_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactChangeSet >()))
        return -1;

    QtMobility::QContactChangeSet* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactChangeSet", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactChangeSet()
    // 1: QContactChangeSet(QtMobility::QContactChangeSet)
    if (numArgs == 0) {
        overloadId = 0; // QContactChangeSet()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactChangeSet & >::isConvertible(arg)) {
        overloadId = 1; // QContactChangeSet(QtMobility::QContactChangeSet)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSet_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactChangeSet()
            {

                if(!PyErr_Occurred()) {
                // QContactChangeSet()
                cptr = new QtMobility::QContactChangeSet();
                }
                break;
            }
            case 1: // QContactChangeSet(QtMobility::QContactChangeSet)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactChangeSet* cpp_arg0 = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactChangeSet(QtMobility::QContactChangeSet)
                cptr = new QtMobility::QContactChangeSet(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactChangeSet >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactChangeSet_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactChangeSet_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactChangeSet", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactChangeSet", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_addedContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // addedContacts()const
            QSet<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactChangeSet::addedContacts();
            pyResult = Shiboken::Converter<QSet<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_addedRelationshipsContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // addedRelationshipsContacts()const
            QSet<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactChangeSet::addedRelationshipsContacts();
            pyResult = Shiboken::Converter<QSet<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_changedContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // changedContacts()const
            QSet<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactChangeSet::changedContacts();
            pyResult = Shiboken::Converter<QSet<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_clearAddedContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearAddedContacts()
            cppSelf->QtMobility::QContactChangeSet::clearAddedContacts();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_clearAddedRelationshipsContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearAddedRelationshipsContacts()
            cppSelf->QtMobility::QContactChangeSet::clearAddedRelationshipsContacts();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_clearAll(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearAll()
            cppSelf->QtMobility::QContactChangeSet::clearAll();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_clearChangedContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearChangedContacts()
            cppSelf->QtMobility::QContactChangeSet::clearChangedContacts();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_clearRemovedContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearRemovedContacts()
            cppSelf->QtMobility::QContactChangeSet::clearRemovedContacts();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_clearRemovedRelationshipsContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearRemovedRelationshipsContacts()
            cppSelf->QtMobility::QContactChangeSet::clearRemovedRelationshipsContacts();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_dataChanged(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // dataChanged()
            bool cppResult = cppSelf->QtMobility::QContactChangeSet::dataChanged();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_emitSignals(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: emitSignals(QtMobility::QContactManagerEngine*)
    if (Shiboken::Converter<QtMobility::QContactManagerEngine * >::isConvertible(arg)) {
        overloadId = 0; // emitSignals(QtMobility::QContactManagerEngine*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_emitSignals_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactManagerEngine* cpp_arg0 = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // emitSignals(QtMobility::QContactManagerEngine*)
            cppSelf->QtMobility::QContactChangeSet::emitSignals(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_emitSignals_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactManagerEngine", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.emitSignals", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertAddedContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertAddedContact(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // insertAddedContact(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertAddedContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertAddedContact(QtMobility::QContactLocalId)
            cppSelf->QtMobility::QContactChangeSet::insertAddedContact(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertAddedContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertAddedContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertAddedContacts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertAddedContacts(QList<QtMobility::QContactLocalId>)
    if (Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(arg)) {
        overloadId = 0; // insertAddedContacts(QList<QtMobility::QContactLocalId>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertAddedContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertAddedContacts(QList<QtMobility::QContactLocalId>)
            cppSelf->QtMobility::QContactChangeSet::insertAddedContacts(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertAddedContacts_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertAddedContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertAddedRelationshipsContact(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // insertAddedRelationshipsContact(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertAddedRelationshipsContact(QtMobility::QContactLocalId)
            cppSelf->QtMobility::QContactChangeSet::insertAddedRelationshipsContact(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertAddedRelationshipsContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContacts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertAddedRelationshipsContacts(QList<QtMobility::QContactLocalId>)
    if (Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(arg)) {
        overloadId = 0; // insertAddedRelationshipsContacts(QList<QtMobility::QContactLocalId>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertAddedRelationshipsContacts(QList<QtMobility::QContactLocalId>)
            cppSelf->QtMobility::QContactChangeSet::insertAddedRelationshipsContacts(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContacts_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertAddedRelationshipsContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertChangedContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertChangedContact(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // insertChangedContact(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertChangedContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertChangedContact(QtMobility::QContactLocalId)
            cppSelf->QtMobility::QContactChangeSet::insertChangedContact(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertChangedContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertChangedContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertChangedContacts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertChangedContacts(QList<QtMobility::QContactLocalId>)
    if (Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(arg)) {
        overloadId = 0; // insertChangedContacts(QList<QtMobility::QContactLocalId>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertChangedContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertChangedContacts(QList<QtMobility::QContactLocalId>)
            cppSelf->QtMobility::QContactChangeSet::insertChangedContacts(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertChangedContacts_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertChangedContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertRemovedContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertRemovedContact(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // insertRemovedContact(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertRemovedContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertRemovedContact(QtMobility::QContactLocalId)
            cppSelf->QtMobility::QContactChangeSet::insertRemovedContact(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertRemovedContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertRemovedContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertRemovedContacts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertRemovedContacts(QList<QtMobility::QContactLocalId>)
    if (Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(arg)) {
        overloadId = 0; // insertRemovedContacts(QList<QtMobility::QContactLocalId>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertRemovedContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertRemovedContacts(QList<QtMobility::QContactLocalId>)
            cppSelf->QtMobility::QContactChangeSet::insertRemovedContacts(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertRemovedContacts_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertRemovedContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertRemovedRelationshipsContact(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // insertRemovedRelationshipsContact(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertRemovedRelationshipsContact(QtMobility::QContactLocalId)
            cppSelf->QtMobility::QContactChangeSet::insertRemovedRelationshipsContact(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertRemovedRelationshipsContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContacts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: insertRemovedRelationshipsContacts(QList<QtMobility::QContactLocalId>)
    if (Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(arg)) {
        overloadId = 0; // insertRemovedRelationshipsContacts(QList<QtMobility::QContactLocalId>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // insertRemovedRelationshipsContacts(QList<QtMobility::QContactLocalId>)
            cppSelf->QtMobility::QContactChangeSet::insertRemovedRelationshipsContacts(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContacts_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.insertRemovedRelationshipsContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_oldAndNewSelfContactId(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // oldAndNewSelfContactId()const
            QPair<QtMobility::QContactLocalId, QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactChangeSet::oldAndNewSelfContactId();
            pyResult = Shiboken::Converter<QPair<QtMobility::QContactLocalId, QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_removedContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // removedContacts()const
            QSet<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactChangeSet::removedContacts();
            pyResult = Shiboken::Converter<QSet<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_removedRelationshipsContacts(PyObject* self)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // removedRelationshipsContacts()const
            QSet<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactChangeSet::removedRelationshipsContacts();
            pyResult = Shiboken::Converter<QSet<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_setDataChanged(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDataChanged(bool)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setDataChanged(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_setDataChanged_TypeError;

    // Call function/method
    {
        {
            bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDataChanged(bool)
            cppSelf->QtMobility::QContactChangeSet::setDataChanged(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_setDataChanged_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.setDataChanged", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeSetFunc_setOldAndNewSelfContactId(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeSet* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeSet* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setOldAndNewSelfContactId(QPair<QtMobility::QContactLocalId,QtMobility::QContactLocalId>)
    if (Shiboken::Converter< QPair<QtMobility::QContactLocalId, QtMobility::QContactLocalId >  >::isConvertible(arg)) {
        overloadId = 0; // setOldAndNewSelfContactId(QPair<QtMobility::QContactLocalId,QtMobility::QContactLocalId>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeSetFunc_setOldAndNewSelfContactId_TypeError;

    // Call function/method
    {
        {
            QPair<QtMobility::QContactLocalId, QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QPair<QtMobility::QContactLocalId, QtMobility::QContactLocalId > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setOldAndNewSelfContactId(QPair<QtMobility::QContactLocalId,QtMobility::QContactLocalId>)
            cppSelf->QtMobility::QContactChangeSet::setOldAndNewSelfContactId(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeSetFunc_setOldAndNewSelfContactId_TypeError:
        const char* overloads[] = {"QPair", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeSet.setOldAndNewSelfContactId", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactChangeSet_methods[] = {
    {"addedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_addedContacts, METH_NOARGS},
    {"addedRelationshipsContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_addedRelationshipsContacts, METH_NOARGS},
    {"changedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_changedContacts, METH_NOARGS},
    {"clearAddedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_clearAddedContacts, METH_NOARGS},
    {"clearAddedRelationshipsContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_clearAddedRelationshipsContacts, METH_NOARGS},
    {"clearAll", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_clearAll, METH_NOARGS},
    {"clearChangedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_clearChangedContacts, METH_NOARGS},
    {"clearRemovedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_clearRemovedContacts, METH_NOARGS},
    {"clearRemovedRelationshipsContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_clearRemovedRelationshipsContacts, METH_NOARGS},
    {"dataChanged", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_dataChanged, METH_NOARGS},
    {"emitSignals", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_emitSignals, METH_O},
    {"insertAddedContact", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertAddedContact, METH_O},
    {"insertAddedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertAddedContacts, METH_O},
    {"insertAddedRelationshipsContact", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContact, METH_O},
    {"insertAddedRelationshipsContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertAddedRelationshipsContacts, METH_O},
    {"insertChangedContact", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertChangedContact, METH_O},
    {"insertChangedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertChangedContacts, METH_O},
    {"insertRemovedContact", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertRemovedContact, METH_O},
    {"insertRemovedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertRemovedContacts, METH_O},
    {"insertRemovedRelationshipsContact", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContact, METH_O},
    {"insertRemovedRelationshipsContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_insertRemovedRelationshipsContacts, METH_O},
    {"oldAndNewSelfContactId", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_oldAndNewSelfContactId, METH_NOARGS},
    {"removedContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_removedContacts, METH_NOARGS},
    {"removedRelationshipsContacts", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_removedRelationshipsContacts, METH_NOARGS},
    {"setDataChanged", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_setDataChanged, METH_O},
    {"setOldAndNewSelfContactId", (PyCFunction)SbkQtMobility_QContactChangeSetFunc_setOldAndNewSelfContactId, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactChangeSet_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactChangeSet",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactChangeSet_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactChangeSet_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactChangeSet >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactChangeSet",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactChangeSet(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTCHANGESET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactChangeSet_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactChangeSet_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactChangeSet_Type));
    PyModule_AddObject(module, "QContactChangeSet",
        ((PyObject*)&SbkQtMobility_QContactChangeSet_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactChangeSet >("QtMobility::QContactChangeSet");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactChangeSet >("QtMobility::QContactChangeSet*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactChangeSet >(typeid(QtMobility::QContactChangeSet).name());
    PySide::initQtMetaType<QtMobility::QContactChangeSet >();
}

