/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactchangelogfilter_wrapper.h"

// Extra includes
#include <qcontactfilter.h>
#include <qdatetime.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactChangeLogFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactChangeLogFilter >()))
        return -1;

    QtMobility::QContactChangeLogFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "type" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactChangeLogFilter(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return -1;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactChangeLogFilter(): too many arguments");
        return -1;
    }

    if (!PyArg_ParseTuple(args, "|O:QContactChangeLogFilter", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactChangeLogFilter(QtMobility::QContactChangeLogFilter)
    // 1: QContactChangeLogFilter(QtMobility::QContactChangeLogFilter::EventType)
    // 2: QContactChangeLogFilter(QtMobility::QContactFilter)
    if (numArgs == 0) {
        overloadId = 1; // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter::EventType)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 2; // QContactChangeLogFilter(QtMobility::QContactFilter)
    } else if (Shiboken::Converter<QtMobility::QContactChangeLogFilter::EventType >::isConvertible(arg)) {
        overloadId = 1; // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter::EventType)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactChangeLogFilter & >::isConvertible(arg)) {
        overloadId = 0; // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeLogFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactChangeLogFilter > cpp_arg0_auto_ptr;
                QtMobility::QContactChangeLogFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactChangeLogFilter* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactChangeLogFilter >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactChangeLogFilter >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter)
                cptr = new QtMobility::QContactChangeLogFilter(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter::EventType)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "type");
                    if (value) {
                        if (arg)
                            errorArgName = "type";
                        else
                            arg = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactChangeLogFilter(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QtMobility::QContactChangeLogFilter::EventType cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QContactChangeLogFilter::EventType >::toCpp(arg) : QtMobility::QContactChangeLogFilter::EventAdded;

                if(!PyErr_Occurred()) {
                // QContactChangeLogFilter(QtMobility::QContactChangeLogFilter::EventType)
                cptr = new QtMobility::QContactChangeLogFilter(cpp_arg0);
                }
                break;
            }
            case 2: // QContactChangeLogFilter(QtMobility::QContactFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactChangeLogFilter(QtMobility::QContactFilter)
                cptr = new QtMobility::QContactChangeLogFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactChangeLogFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactChangeLogFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactChangeLogFilter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactChangeLogFilter", "QtMobility.Contacts.QtMobility::QContactChangeLogFilter.EventType = QContactChangeLogFilter.EventAdded", "QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactChangeLogFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactChangeLogFilterFunc_eventType(PyObject* self)
{
    QtMobility::QContactChangeLogFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeLogFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // eventType()const
            QtMobility::QContactChangeLogFilter::EventType cppResult = cppSelf->QtMobility::QContactChangeLogFilter::eventType();
            pyResult = Shiboken::Converter<QtMobility::QContactChangeLogFilter::EventType >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactChangeLogFilterFunc_setEventType(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeLogFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeLogFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setEventType(QtMobility::QContactChangeLogFilter::EventType)
    if (Shiboken::Converter<QtMobility::QContactChangeLogFilter::EventType >::isConvertible(arg)) {
        overloadId = 0; // setEventType(QtMobility::QContactChangeLogFilter::EventType)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeLogFilterFunc_setEventType_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactChangeLogFilter::EventType cpp_arg0 = Shiboken::Converter<QtMobility::QContactChangeLogFilter::EventType >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setEventType(QtMobility::QContactChangeLogFilter::EventType)
            cppSelf->QtMobility::QContactChangeLogFilter::setEventType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeLogFilterFunc_setEventType_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactChangeLogFilter.EventType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeLogFilter.setEventType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeLogFilterFunc_setSince(PyObject* self, PyObject* arg)
{
    QtMobility::QContactChangeLogFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeLogFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSince(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setSince(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactChangeLogFilterFunc_setSince_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSince(QDateTime)
            cppSelf->QtMobility::QContactChangeLogFilter::setSince(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactChangeLogFilterFunc_setSince_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactChangeLogFilter.setSince", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactChangeLogFilterFunc_since(PyObject* self)
{
    QtMobility::QContactChangeLogFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactChangeLogFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // since()const
            QDateTime cppResult = cppSelf->QtMobility::QContactChangeLogFilter::since();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactChangeLogFilter_methods[] = {
    {"eventType", (PyCFunction)SbkQtMobility_QContactChangeLogFilterFunc_eventType, METH_NOARGS},
    {"setEventType", (PyCFunction)SbkQtMobility_QContactChangeLogFilterFunc_setEventType, METH_O},
    {"setSince", (PyCFunction)SbkQtMobility_QContactChangeLogFilterFunc_setSince, METH_O},
    {"since", (PyCFunction)SbkQtMobility_QContactChangeLogFilterFunc_since, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactChangeLogFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactChangeLogFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactChangeLogFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactChangeLogFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactChangeLogFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactChangeLogFilter",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EventType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactChangeLogFilter(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTCHANGELOGFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactChangeLogFilter_Type);

    SbkQtMobility_QContactChangeLogFilter_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactChangeLogFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactChangeLogFilter_Type));
    PyModule_AddObject(module, "QContactChangeLogFilter",
        ((PyObject*)&SbkQtMobility_QContactChangeLogFilter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: EventType
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTCHANGELOGFILTER_EVENTTYPE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type);
    PyDict_SetItemString(SbkQtMobility_QContactChangeLogFilter_Type.super.ht_type.tp_dict,
            "EventType",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type,
        (long) QtMobility::QContactChangeLogFilter::EventAdded, "EventAdded");
    PyDict_SetItemString(SbkQtMobility_QContactChangeLogFilter_Type.super.ht_type.tp_dict,
        "EventAdded", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type.tp_dict,
        "EventAdded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type,
        (long) QtMobility::QContactChangeLogFilter::EventChanged, "EventChanged");
    PyDict_SetItemString(SbkQtMobility_QContactChangeLogFilter_Type.super.ht_type.tp_dict,
        "EventChanged", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type.tp_dict,
        "EventChanged", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type,
        (long) QtMobility::QContactChangeLogFilter::EventRemoved, "EventRemoved");
    PyDict_SetItemString(SbkQtMobility_QContactChangeLogFilter_Type.super.ht_type.tp_dict,
        "EventRemoved", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactChangeLogFilter_EventType_Type.tp_dict,
        "EventRemoved", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactChangeLogFilter::EventType");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactChangeLogFilter >("QtMobility::QContactChangeLogFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactChangeLogFilter >("QtMobility::QContactChangeLogFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactChangeLogFilter >(typeid(QtMobility::QContactChangeLogFilter).name());
    PySide::initQtMetaType<QtMobility::QContactChangeLogFilter >();
}

