/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactavatar_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactavatar.h>
#include <qcontactdetail.h>
#include <qurl.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactAvatar_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactAvatar >()))
        return -1;

    QtMobility::QContactAvatar* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactAvatar", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactAvatar(QtMobility::QContactAvatar)
    // 1: QContactAvatar()
    // 2: QContactAvatar(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactAvatar()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactAvatar(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactAvatar & >::isConvertible(arg)) {
        overloadId = 0; // QContactAvatar(QtMobility::QContactAvatar)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAvatar_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactAvatar(QtMobility::QContactAvatar)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactAvatar > cpp_arg0_auto_ptr;
                QtMobility::QContactAvatar* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAvatar* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactAvatar >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactAvatar >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactAvatar(QtMobility::QContactAvatar)
                cptr = new QtMobility::QContactAvatar(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactAvatar()
            {

                if(!PyErr_Occurred()) {
                // QContactAvatar()
                cptr = new QtMobility::QContactAvatar();
                }
                break;
            }
            case 2: // QContactAvatar(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactAvatar(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactAvatar(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactAvatar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactAvatar_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactAvatar_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAvatar", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactAvatar", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactAvatarFunc_imageUrl(PyObject* self)
{
    QtMobility::QContactAvatar* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAvatar* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // imageUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactAvatar::imageUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAvatarFunc_setImageUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAvatar* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAvatar* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setImageUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setImageUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAvatarFunc_setImageUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setImageUrl(QUrl)
            cppSelf->QtMobility::QContactAvatar::setImageUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAvatarFunc_setImageUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAvatar.setImageUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAvatarFunc_setVideoUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAvatar* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAvatar* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setVideoUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setVideoUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAvatarFunc_setVideoUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setVideoUrl(QUrl)
            cppSelf->QtMobility::QContactAvatar::setVideoUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAvatarFunc_setVideoUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAvatar.setVideoUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAvatarFunc_videoUrl(PyObject* self)
{
    QtMobility::QContactAvatar* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAvatar* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // videoUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactAvatar::videoUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactAvatar_methods[] = {
    {"imageUrl", (PyCFunction)SbkQtMobility_QContactAvatarFunc_imageUrl, METH_NOARGS},
    {"setImageUrl", (PyCFunction)SbkQtMobility_QContactAvatarFunc_setImageUrl, METH_O},
    {"setVideoUrl", (PyCFunction)SbkQtMobility_QContactAvatarFunc_setVideoUrl, METH_O},
    {"videoUrl", (PyCFunction)SbkQtMobility_QContactAvatarFunc_videoUrl, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactAvatar_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactAvatar",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactAvatar_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactAvatar_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactAvatar >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactAvatar",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactAvatar(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTAVATAR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactAvatar_Type);

    SbkQtMobility_QContactAvatar_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactAvatar_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactAvatar_Type));
    PyModule_AddObject(module, "QContactAvatar",
        ((PyObject*)&SbkQtMobility_QContactAvatar_Type));

    PyDict_SetItemString(SbkQtMobility_QContactAvatar_Type.super.ht_type.tp_dict, "FieldImageUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactAvatar::FieldImageUrl));
    PyDict_SetItemString(SbkQtMobility_QContactAvatar_Type.super.ht_type.tp_dict, "FieldVideoUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactAvatar::FieldVideoUrl));
    PyDict_SetItemString(SbkQtMobility_QContactAvatar_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactAvatar::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactAvatar >("QtMobility::QContactAvatar");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactAvatar >("QtMobility::QContactAvatar*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactAvatar >(typeid(QtMobility::QContactAvatar).name());
    PySide::initQtMetaType<QtMobility::QContactAvatar >();
}

