/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactanniversary_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactanniversary.h>
#include <qcontactdetail.h>
#include <qdatetime.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactAnniversary_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactAnniversary >()))
        return -1;

    QtMobility::QContactAnniversary* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactAnniversary", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactAnniversary(QtMobility::QContactAnniversary)
    // 1: QContactAnniversary()
    // 2: QContactAnniversary(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactAnniversary()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactAnniversary(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactAnniversary & >::isConvertible(arg)) {
        overloadId = 0; // QContactAnniversary(QtMobility::QContactAnniversary)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAnniversary_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactAnniversary(QtMobility::QContactAnniversary)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactAnniversary > cpp_arg0_auto_ptr;
                QtMobility::QContactAnniversary* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactAnniversary >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactAnniversary >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactAnniversary(QtMobility::QContactAnniversary)
                cptr = new QtMobility::QContactAnniversary(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactAnniversary()
            {

                if(!PyErr_Occurred()) {
                // QContactAnniversary()
                cptr = new QtMobility::QContactAnniversary();
                }
                break;
            }
            case 2: // QContactAnniversary(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactAnniversary(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactAnniversary(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactAnniversary >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactAnniversary_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactAnniversary_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAnniversary", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactAnniversary", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_calendarId(PyObject* self)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // calendarId()const
            QString cppResult = cppSelf->QtMobility::QContactAnniversary::calendarId();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_event(PyObject* self)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // event()const
            QString cppResult = cppSelf->QtMobility::QContactAnniversary::event();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_originalDate(PyObject* self)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // originalDate()const
            QDate cppResult = cppSelf->QtMobility::QContactAnniversary::originalDate();
            pyResult = Shiboken::Converter<QDate >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_setCalendarId(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCalendarId(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setCalendarId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAnniversaryFunc_setCalendarId_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCalendarId(QString)
            cppSelf->QtMobility::QContactAnniversary::setCalendarId(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAnniversaryFunc_setCalendarId_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAnniversary.setCalendarId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_setEvent(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setEvent(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setEvent(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAnniversaryFunc_setEvent_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setEvent(QString)
            cppSelf->QtMobility::QContactAnniversary::setEvent(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAnniversaryFunc_setEvent_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAnniversary.setEvent", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_setOriginalDate(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setOriginalDate(QDate)
    if (Shiboken::Converter<const QDate & >::isConvertible(arg)) {
        overloadId = 0; // setOriginalDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAnniversaryFunc_setOriginalDate_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setOriginalDate(QDate)
            cppSelf->QtMobility::QContactAnniversary::setOriginalDate(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAnniversaryFunc_setOriginalDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAnniversary.setOriginalDate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_setSubType(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSubType(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSubType(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAnniversaryFunc_setSubType_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSubType(QString)
            cppSelf->QtMobility::QContactAnniversary::setSubType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAnniversaryFunc_setSubType_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAnniversary.setSubType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAnniversaryFunc_subType(PyObject* self)
{
    QtMobility::QContactAnniversary* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // subType()const
            QString cppResult = cppSelf->QtMobility::QContactAnniversary::subType();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactAnniversary_methods[] = {
    {"calendarId", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_calendarId, METH_NOARGS},
    {"event", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_event, METH_NOARGS},
    {"originalDate", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_originalDate, METH_NOARGS},
    {"setCalendarId", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_setCalendarId, METH_O},
    {"setEvent", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_setEvent, METH_O},
    {"setOriginalDate", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_setOriginalDate, METH_O},
    {"setSubType", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_setSubType, METH_O},
    {"subType", (PyCFunction)SbkQtMobility_QContactAnniversaryFunc_subType, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactAnniversary_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactAnniversary",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactAnniversary_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactAnniversary_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactAnniversary >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactAnniversary",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactAnniversary(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTANNIVERSARY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactAnniversary_Type);

    SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactAnniversary_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactAnniversary_Type));
    PyModule_AddObject(module, "QContactAnniversary",
        ((PyObject*)&SbkQtMobility_QContactAnniversary_Type));

    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "SubTypeHouse", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::SubTypeHouse));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "SubTypeWedding", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::SubTypeWedding));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "FieldCalendarId", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::FieldCalendarId));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "FieldEvent", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::FieldEvent));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "SubTypeEmployment", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::SubTypeEmployment));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "FieldSubType", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::FieldSubType));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "SubTypeEngagement", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::SubTypeEngagement));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "FieldOriginalDate", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::FieldOriginalDate));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::DefinitionName));
    PyDict_SetItemString(SbkQtMobility_QContactAnniversary_Type.super.ht_type.tp_dict, "SubTypeMemorial", Shiboken::Converter<QString >::toPython(QtMobility::QContactAnniversary::SubTypeMemorial));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactAnniversary >("QtMobility::QContactAnniversary");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactAnniversary >("QtMobility::QContactAnniversary*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactAnniversary >(typeid(QtMobility::QContactAnniversary).name());
    PySide::initQtMetaType<QtMobility::QContactAnniversary >();
}

