/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontact_wrapper.h"

// Extra includes
#include <QList>
#include <qcontact.h>
#include <qcontactdetail.h>
#include <qcontactid.h>
#include <qcontactrelationship.h>
#include <qcontacttype.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContact_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContact >()))
        return -1;

    QtMobility::QContact* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContact", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContact()
    // 1: QContact(QtMobility::QContact)
    if (numArgs == 0) {
        overloadId = 0; // QContact()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(arg)) {
        overloadId = 1; // QContact(QtMobility::QContact)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContact_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContact()
            {

                if(!PyErr_Occurred()) {
                // QContact()
                cptr = new QtMobility::QContact();
                }
                break;
            }
            case 1: // QContact(QtMobility::QContact)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContact(QtMobility::QContact)
                cptr = new QtMobility::QContact(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContact >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContact_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContact_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContact", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactFunc_clearDetails(PyObject* self)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearDetails()
            cppSelf->QtMobility::QContact::clearDetails();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QContactFunc_detail(PyObject* self, PyObject* arg)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: detail(QString)const
    // 1: detail(const char*)const
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 1; // detail(const char*)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // detail(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_detail_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // detail(QString)const
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // detail(QString)const
                QtMobility::QContactDetail cppResult = cppSelf->QtMobility::QContact::detail(cpp_arg0);
                pyResult = Shiboken::Converter<QtMobility::QContactDetail >::toPython(cppResult);
                }
                break;
            }
            case 1: // detail(const char*)const
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // detail(const char*)const
                QtMobility::QContactDetail cppResult = cppSelf->QtMobility::QContact::detail(cpp_arg0);
                pyResult = Shiboken::Converter<QtMobility::QContactDetail >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactFunc_detail_TypeError:
        const char* overloads[] = {"QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContact.detail", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_details(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "definitionId" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContact.details(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContact.details(): too many arguments");
        return 0;
    } else if (numArgs == 2)
        goto SbkQtMobility_QContactFunc_details_TypeError;

    if (!PyArg_ParseTuple(args, "|OOO:details", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: details(QString)const
    // 1: details(QString,QString,QString)const
    // 2: details(const char*)const
    // 3: details(const char*,const char*,QString)const
    if (numArgs == 0) {
        overloadId = 0; // details(QString)const
    } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 2; // details(const char*)const
        } else if (numArgs == 3 && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<QString >::isConvertible(pyargs[2])) {
            overloadId = 3; // details(const char*,const char*,QString)const
        }
    } else if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // details(QString)const
        } else if (numArgs == 3 && Shiboken::Converter<QString >::isConvertible(pyargs[1]) && Shiboken::Converter<QString >::isConvertible(pyargs[2])) {
            overloadId = 1; // details(QString,QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_details_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // details(QString)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "definitionId");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "definitionId";
                        else
                            pyargs[0] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContact.details(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = pyargs[0] ? Shiboken::Converter<QString >::toCpp(pyargs[0]) : QString();

                if(!PyErr_Occurred()) {
                // details(QString)const
                QList<QtMobility::QContactDetail > cppResult = cppSelf->QtMobility::QContact::details(cpp_arg0);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactDetail > >::toPython(cppResult);
                }
                break;
            }
            case 1: // details(QString,QString,QString)const
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
                QString cpp_arg2 = Shiboken::Converter<QString >::toCpp(pyargs[2]);

                if(!PyErr_Occurred()) {
                // details(QString,QString,QString)const
                QList<QtMobility::QContactDetail > cppResult = cppSelf->QtMobility::QContact::details(cpp_arg0, cpp_arg1, cpp_arg2);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactDetail > >::toPython(cppResult);
                }
                break;
            }
            case 2: // details(const char*)const
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // details(const char*)const
                QList<QtMobility::QContactDetail > cppResult = cppSelf->QtMobility::QContact::details(cpp_arg0);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactDetail > >::toPython(cppResult);
                }
                break;
            }
            case 3: // details(const char*,const char*,QString)const
            {
                const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
                const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
                QString cpp_arg2 = Shiboken::Converter<QString >::toCpp(pyargs[2]);

                if(!PyErr_Occurred()) {
                // details(const char*,const char*,QString)const
                QList<QtMobility::QContactDetail > cppResult = cppSelf->QtMobility::QContact::details(cpp_arg0, cpp_arg1, cpp_arg2);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactDetail > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactFunc_details_TypeError:
        const char* overloads[] = {"QString = QString()", "QString, QString, QString", "str", "str, str, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContact.details", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_displayLabel(PyObject* self)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // displayLabel()const
            QString cppResult = cppSelf->QtMobility::QContact::displayLabel();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFunc_id(PyObject* self)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // id()const
            QtMobility::QContactId cppResult = cppSelf->QtMobility::QContact::id();
            pyResult = Shiboken::Converter<QtMobility::QContactId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFunc_isEmpty(PyObject* self)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QContact::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFunc_localId(PyObject* self)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // localId()const
            QtMobility::QContactLocalId cppResult = cppSelf->QtMobility::QContact::localId();
            pyResult = Shiboken::Converter<QtMobility::QContactLocalId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFunc_relatedContacts(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "relationshipType", "role" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 2, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContact.relatedContacts(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContact.relatedContacts(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:relatedContacts", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: relatedContacts(QString,QtMobility::QContactRelationship::Role)const
    if (numArgs == 0) {
        overloadId = 0; // relatedContacts(QString,QtMobility::QContactRelationship::Role)const
    } else if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // relatedContacts(QString,QtMobility::QContactRelationship::Role)const
        } else if (Shiboken::Converter<QtMobility::QContactRelationship::Role >::isConvertible(pyargs[1])) {
            overloadId = 0; // relatedContacts(QString,QtMobility::QContactRelationship::Role)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_relatedContacts_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "relationshipType");
                if (value) {
                    if (pyargs[0])
                        errorArgName = "relationshipType";
                    else
                        pyargs[0] = value;
                }
                value = PyDict_GetItemString(kwds, "role");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "role";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContact.relatedContacts(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = pyargs[0] ? Shiboken::Converter<QString >::toCpp(pyargs[0]) : QString();
            QtMobility::QContactRelationship::Role cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QContactRelationship::Role >::toCpp(pyargs[1]) : QtMobility::QContactRelationship::Either;

            if(!PyErr_Occurred()) {
            // relatedContacts(QString,QtMobility::QContactRelationship::Role)const
            QList<QtMobility::QContactId > cppResult = cppSelf->QtMobility::QContact::relatedContacts(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QList<QtMobility::QContactId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactFunc_relatedContacts_TypeError:
        const char* overloads[] = {"QString = QString(), QtMobility.Contacts.QtMobility::QContactRelationship.Role = QContactRelationship.Either", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContact.relatedContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_relationships(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "relationshipType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContact.relationships(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContact.relationships(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:relationships", &arg))
        return 0;


    // Overloaded function decisor
    // 0: relationships(QString)const
    if (numArgs == 0) {
        overloadId = 0; // relationships(QString)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // relationships(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_relationships_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "relationshipType");
                if (value) {
                    if (arg)
                        errorArgName = "relationshipType";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContact.relationships(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = arg ? Shiboken::Converter<QString >::toCpp(arg) : QString();

            if(!PyErr_Occurred()) {
            // relationships(QString)const
            QList<QtMobility::QContactRelationship > cppResult = cppSelf->QtMobility::QContact::relationships(cpp_arg0);
            pyResult = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactFunc_relationships_TypeError:
        const char* overloads[] = {"QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContact.relationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_removeDetail(PyObject* self, PyObject* arg)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeDetail(QtMobility::QContactDetail*)
    if (Shiboken::Converter<QtMobility::QContactDetail * >::isConvertible(arg)) {
        overloadId = 0; // removeDetail(QtMobility::QContactDetail*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_removeDetail_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeDetail(QtMobility::QContactDetail*)
            bool cppResult = cppSelf->QtMobility::QContact::removeDetail(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactFunc_removeDetail_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContact.removeDetail", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_saveDetail(PyObject* self, PyObject* arg)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: saveDetail(QtMobility::QContactDetail*)
    if (Shiboken::Converter<QtMobility::QContactDetail * >::isConvertible(arg)) {
        overloadId = 0; // saveDetail(QtMobility::QContactDetail*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_saveDetail_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // saveDetail(QtMobility::QContactDetail*)
            bool cppResult = cppSelf->QtMobility::QContact::saveDetail(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactFunc_saveDetail_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContact.saveDetail", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_setId(PyObject* self, PyObject* arg)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setId(QtMobility::QContactId)
    if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(arg)) {
        overloadId = 0; // setId(QtMobility::QContactId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_setId_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactId* cpp_arg0 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setId(QtMobility::QContactId)
            cppSelf->QtMobility::QContact::setId(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFunc_setId_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContact.setId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_setType(PyObject* self, PyObject* arg)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setType(QString)
    // 1: setType(QtMobility::QContactType)
    if (Shiboken::Converter<const QtMobility::QContactType & >::isConvertible(arg)) {
        overloadId = 1; // setType(QtMobility::QContactType)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setType(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFunc_setType_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setType(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setType(QString)
                cppSelf->QtMobility::QContact::setType(cpp_arg0);
                }
                break;
            }
            case 1: // setType(QtMobility::QContactType)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return 0;
                std::auto_ptr<QtMobility::QContactType > cpp_arg0_auto_ptr;
                QtMobility::QContactType* cpp_arg0 = Shiboken::Converter<QtMobility::QContactType* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactType >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactType >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // setType(QtMobility::QContactType)
                cppSelf->QtMobility::QContact::setType(*cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFunc_setType_TypeError:
        const char* overloads[] = {"QString", "QtMobility.Contacts.QtMobility::QContactType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContact.setType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFunc_type(PyObject* self)
{
    QtMobility::QContact* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QString cppResult = cppSelf->QtMobility::QContact::type();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContact_methods[] = {
    {"clearDetails", (PyCFunction)SbkQtMobility_QContactFunc_clearDetails, METH_NOARGS},
    {"detail", (PyCFunction)SbkQtMobility_QContactFunc_detail, METH_O},
    {"details", (PyCFunction)SbkQtMobility_QContactFunc_details, METH_VARARGS|METH_KEYWORDS},
    {"displayLabel", (PyCFunction)SbkQtMobility_QContactFunc_displayLabel, METH_NOARGS},
    {"id", (PyCFunction)SbkQtMobility_QContactFunc_id, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQtMobility_QContactFunc_isEmpty, METH_NOARGS},
    {"localId", (PyCFunction)SbkQtMobility_QContactFunc_localId, METH_NOARGS},
    {"relatedContacts", (PyCFunction)SbkQtMobility_QContactFunc_relatedContacts, METH_VARARGS|METH_KEYWORDS},
    {"relationships", (PyCFunction)SbkQtMobility_QContactFunc_relationships, METH_VARARGS|METH_KEYWORDS},
    {"removeDetail", (PyCFunction)SbkQtMobility_QContactFunc_removeDetail, METH_O},
    {"saveDetail", (PyCFunction)SbkQtMobility_QContactFunc_saveDetail, METH_O},
    {"setId", (PyCFunction)SbkQtMobility_QContactFunc_setId, METH_O},
    {"setType", (PyCFunction)SbkQtMobility_QContactFunc_setType, METH_O},
    {"type", (PyCFunction)SbkQtMobility_QContactFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContact_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContact& cpp_self = *Shiboken::Converter<QtMobility::QContact* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContact & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContact & other) const
                QtMobility::QContact* cpp_other = Shiboken::Converter<QtMobility::QContact* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContact  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContact_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContact & >::isConvertible(other)) {
                // operator==(const QtMobility::QContact & other) const
                QtMobility::QContact* cpp_other = Shiboken::Converter<QtMobility::QContact* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContact  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContact_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContact_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QContact_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QContact >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContact_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContact",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QContact_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContact_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContact_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContact_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContact >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContact",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContact(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContact_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContact_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContact_Type));
    PyModule_AddObject(module, "QContact",
        ((PyObject*)&SbkQtMobility_QContact_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContact >("QtMobility::QContact");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContact >("QtMobility::QContact*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContact >(typeid(QtMobility::QContact).name());
    PySide::initQtMetaType<QtMobility::QContact >();
}

