/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_CONTACTS_PYTHON_H
#define SBK_CONTACTS_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>
#include <pyside_qtgui_python.h>

// Binded library includes
#include <qcontacturl.h>
#include <qcontactintersectionfilter.h>
#include <qcontactdetail.h>
#include <qcontactsaverequest.h>
#include <qcontactmanagerengine.h>
#include <qcontactgender.h>
#include <qcontactpresence.h>
#include <qcontactdetaildefinitionremoverequest.h>
#include <qcontactnickname.h>
#include <qcontactmanager.h>
#include <qcontactrelationshipsaverequest.h>
#include <qcontactglobalpresence.h>
#include <qcontactchangeset.h>
#include <qcontactbirthday.h>
#include <qcontactdetaildefinitionsaverequest.h>
#include <qcontacttag.h>
#include <qcontactfetchrequest.h>
#include <qcontactdetaildefinition.h>
#include <qcontactfamily.h>
#include <qcontactid.h>
#include <qcontactanniversary.h>
#include <qcontactfilter.h>
#include <qcontactlocalidfetchrequest.h>
#include <qcontacttimestamp.h>
#include <qcontactsortorder.h>
#include <qcontact.h>
#include <qcontactavatar.h>
#include <qcontactrelationshipremoverequest.h>
#include <qcontactdetailfilter.h>
#include <qcontactchangelogfilter.h>
#include <qcontactdisplaylabel.h>
#include <qcontactsynctarget.h>
#include <qcontactgeolocation.h>
#include <qcontactdetailrangefilter.h>
#include <qcontactphonenumber.h>
#include <qcontactguid.h>
#include <qcontactaddress.h>
#include <qcontactringtone.h>
#include <qcontacttype.h>
#include <qcontactname.h>
#include <qcontactfetchhint.h>
#include <qcontactonlineaccount.h>
#include <qcontactabstractrequest.h>
#include <qcontactemailaddress.h>
#include <qcontactlocalidfilter.h>
#include <qcontactunionfilter.h>
#include <qcontactrelationship.h>
#include <qcontactdetailfielddefinition.h>
#include <qcontactthumbnail.h>
#include <qcontactdetaildefinitionfetchrequest.h>
#include <qcontactorganization.h>
#include <qcontactinvalidfilter.h>
#include <qcontactrelationshipfilter.h>
#include <qcontactrelationshipfetchrequest.h>
#include <qcontactremoverequest.h>
#include <qcontactmanagerenginefactory.h>
#include <qcontactnote.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QStack>
#include <QVector>
#include <QStringList>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QTMOBILITY_QCONTACTCHANGESET_IDX                         0
#define SBK_QTMOBILITY_QCONTACTMANAGERENGINEFACTORY_IDX              1
#define SBK_QTMOBILITY_QCONTACTFETCHHINT_IDX                         2
#define SBK_QTMOBILITY_QCONTACTFETCHHINT_OPTIMIZATIONHINT_IDX        3
#define SBK_QFLAGS_QTMOBILITY_QCONTACTFETCHHINT_OPTIMIZATIONHINT__IDX 4
#define SBK_QTMOBILITY_QCONTACTSORTORDER_IDX                         5
#define SBK_QTMOBILITY_QCONTACTSORTORDER_BLANKPOLICY_IDX             6
#define SBK_QTMOBILITY_QCONTACT_IDX                                  7
#define SBK_QTMOBILITY_QCONTACTID_IDX                                8
#define SBK_QTMOBILITY_QCONTACTFILTER_IDX                            9
#define SBK_QTMOBILITY_QCONTACTFILTER_MATCHFLAG_IDX                  10
#define SBK_QFLAGS_QTMOBILITY_QCONTACTFILTER_MATCHFLAG__IDX          11
#define SBK_QTMOBILITY_QCONTACTFILTER_FILTERTYPE_IDX                 12
#define SBK_QTMOBILITY_QCONTACTRELATIONSHIPFILTER_IDX                13
#define SBK_QTMOBILITY_QCONTACTINTERSECTIONFILTER_IDX                14
#define SBK_QTMOBILITY_QCONTACTLOCALIDFILTER_IDX                     15
#define SBK_QTMOBILITY_QCONTACTUNIONFILTER_IDX                       16
#define SBK_QTMOBILITY_QCONTACTDETAILRANGEFILTER_IDX                 17
#define SBK_QTMOBILITY_QCONTACTDETAILRANGEFILTER_RANGEFLAG_IDX       18
#define SBK_QFLAGS_QTMOBILITY_QCONTACTDETAILRANGEFILTER_RANGEFLAG__IDX 19
#define SBK_QTMOBILITY_QCONTACTDETAILFILTER_IDX                      20
#define SBK_QTMOBILITY_QCONTACTINVALIDFILTER_IDX                     21
#define SBK_QTMOBILITY_QCONTACTCHANGELOGFILTER_IDX                   22
#define SBK_QTMOBILITY_QCONTACTCHANGELOGFILTER_EVENTTYPE_IDX         23
#define SBK_QTMOBILITY_QCONTACTRELATIONSHIP_IDX                      24
#define SBK_QTMOBILITY_QCONTACTRELATIONSHIP_ROLE_IDX                 25
#define SBK_QTMOBILITY_QCONTACTDETAILDEFINITION_IDX                  26
#define SBK_QTMOBILITY_QCONTACTDETAILFIELDDEFINITION_IDX             27
#define SBK_QTMOBILITY_QCONTACTDETAIL_IDX                            28
#define SBK_QTMOBILITY_QCONTACTDETAIL_ACCESSCONSTRAINT_IDX           29
#define SBK_QFLAGS_QTMOBILITY_QCONTACTDETAIL_ACCESSCONSTRAINT__IDX   30
#define SBK_QTMOBILITY_QCONTACTURL_IDX                               31
#define SBK_QTMOBILITY_QCONTACTTIMESTAMP_IDX                         32
#define SBK_QTMOBILITY_QCONTACTTHUMBNAIL_IDX                         33
#define SBK_QTMOBILITY_QCONTACTTAG_IDX                               34
#define SBK_QTMOBILITY_QCONTACTTYPE_IDX                              35
#define SBK_QTMOBILITY_QCONTACTSYNCTARGET_IDX                        36
#define SBK_QTMOBILITY_QCONTACTRINGTONE_IDX                          37
#define SBK_QTMOBILITY_QCONTACTPHONENUMBER_IDX                       38
#define SBK_QTMOBILITY_QCONTACTDISPLAYLABEL_IDX                      39
#define SBK_QTMOBILITY_QCONTACTORGANIZATION_IDX                      40
#define SBK_QTMOBILITY_QCONTACTONLINEACCOUNT_IDX                     41
#define SBK_QTMOBILITY_QCONTACTNOTE_IDX                              42
#define SBK_QTMOBILITY_QCONTACTNICKNAME_IDX                          43
#define SBK_QTMOBILITY_QCONTACTNAME_IDX                              44
#define SBK_QTMOBILITY_QCONTACTGUID_IDX                              45
#define SBK_QTMOBILITY_QCONTACTGLOBALPRESENCE_IDX                    46
#define SBK_QTMOBILITY_QCONTACTPRESENCE_IDX                          47
#define SBK_QTMOBILITY_QCONTACTPRESENCE_PRESENCESTATE_IDX            48
#define SBK_QTMOBILITY_QCONTACTGEOLOCATION_IDX                       49
#define SBK_QTMOBILITY_QCONTACTGENDER_IDX                            50
#define SBK_QTMOBILITY_QCONTACTFAMILY_IDX                            51
#define SBK_QTMOBILITY_QCONTACTEMAILADDRESS_IDX                      52
#define SBK_QTMOBILITY_QCONTACTBIRTHDAY_IDX                          53
#define SBK_QTMOBILITY_QCONTACTAVATAR_IDX                            54
#define SBK_QTMOBILITY_QCONTACTANNIVERSARY_IDX                       55
#define SBK_QTMOBILITY_QCONTACTADDRESS_IDX                           56
#define SBK_QTMOBILITY_QCONTACTMANAGERENGINE_IDX                     57
#define SBK_QTMOBILITY_QCONTACTMANAGER_IDX                           58
#define SBK_QTMOBILITY_QCONTACTMANAGER_ERROR_IDX                     59
#define SBK_QTMOBILITY_QCONTACTMANAGER_MANAGERFEATURE_IDX            60
#define SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_IDX                   61
#define SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_REQUESTTYPE_IDX       62
#define SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_STATE_IDX             63
#define SBK_QTMOBILITY_QCONTACTSAVEREQUEST_IDX                       64
#define SBK_QTMOBILITY_QCONTACTREMOVEREQUEST_IDX                     65
#define SBK_QTMOBILITY_QCONTACTLOCALIDFETCHREQUEST_IDX               66
#define SBK_QTMOBILITY_QCONTACTFETCHREQUEST_IDX                      67
#define SBK_QTMOBILITY_QCONTACTRELATIONSHIPSAVEREQUEST_IDX           68
#define SBK_QTMOBILITY_QCONTACTRELATIONSHIPREMOVEREQUEST_IDX         69
#define SBK_QTMOBILITY_QCONTACTRELATIONSHIPFETCHREQUEST_IDX          70
#define SBK_QTMOBILITY_QCONTACTDETAILDEFINITIONSAVEREQUEST_IDX       71
#define SBK_QTMOBILITY_QCONTACTDETAILDEFINITIONREMOVEREQUEST_IDX     72
#define SBK_QTMOBILITY_QCONTACTDETAILDEFINITIONFETCHREQUEST_IDX      73
#define SBK_Contacts_IDX_COUNT                                       74

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_ContactsTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QContactChangeSet >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTCHANGESET_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactManagerEngineFactory >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGERENGINEFACTORY_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFetchHint::OptimizationHint >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFETCHHINT_OPTIMIZATIONHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QContactFetchHint::OptimizationHint> >() { return SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTFETCHHINT_OPTIMIZATIONHINT__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFetchHint >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFETCHHINT_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactSortOrder::BlankPolicy >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTSORTORDER_BLANKPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactSortOrder >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTSORTORDER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContact >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACT_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactId >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTID_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFilter::MatchFlag >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_MATCHFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QContactFilter::MatchFlag> >() { return SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTFILTER_MATCHFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFilter::FilterType >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_FILTERTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRelationshipFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIPFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactIntersectionFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTINTERSECTIONFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactLocalIdFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTLOCALIDFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactUnionFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTUNIONFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailRangeFilter::RangeFlag >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILRANGEFILTER_RANGEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QContactDetailRangeFilter::RangeFlag> >() { return SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTDETAILRANGEFILTER_RANGEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailRangeFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILRANGEFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactInvalidFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTINVALIDFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactChangeLogFilter::EventType >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTCHANGELOGFILTER_EVENTTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactChangeLogFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTCHANGELOGFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRelationship::Role >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIP_ROLE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRelationship >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIP_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailDefinition >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILDEFINITION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailFieldDefinition >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILFIELDDEFINITION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetail::AccessConstraint >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_ACCESSCONSTRAINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QContactDetail::AccessConstraint> >() { return SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTDETAIL_ACCESSCONSTRAINT__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetail >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactUrl >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTURL_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactTimestamp >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTTIMESTAMP_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactThumbnail >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTTHUMBNAIL_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactTag >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTTAG_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactType >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTTYPE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactSyncTarget >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTSYNCTARGET_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRingtone >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRINGTONE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactPhoneNumber >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTPHONENUMBER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDisplayLabel >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDISPLAYLABEL_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactOrganization >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTORGANIZATION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactOnlineAccount >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTONLINEACCOUNT_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactNote >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTNOTE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactNickname >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTNICKNAME_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactName >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTNAME_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactGuid >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGUID_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactGlobalPresence >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGLOBALPRESENCE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactPresence::PresenceState >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTPRESENCE_PRESENCESTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactPresence >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTPRESENCE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactGeoLocation >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGEOLOCATION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactGender >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGENDER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFamily >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFAMILY_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactEmailAddress >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTEMAILADDRESS_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactBirthday >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTBIRTHDAY_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactAvatar >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTAVATAR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactAnniversary >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTANNIVERSARY_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactAddress >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTADDRESS_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactManagerEngine >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGERENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactManager::Error >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactManager::ManagerFeature >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGER_MANAGERFEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactManager >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactAbstractRequest::RequestType >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_REQUESTTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactAbstractRequest::State >() { return SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QContactAbstractRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactSaveRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTSAVEREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRemoveRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTREMOVEREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactLocalIdFetchRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTLOCALIDFETCHREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactFetchRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFETCHREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRelationshipSaveRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIPSAVEREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRelationshipRemoveRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIPREMOVEREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactRelationshipFetchRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIPFETCHREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailDefinitionSaveRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILDEFINITIONSAVEREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailDefinitionRemoveRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILDEFINITIONREMOVEREQUEST_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QContactDetailDefinitionFetchRequest >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILDEFINITIONFETCHREQUEST_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QContactManagerEngine >(const QtMobility::QContactManagerEngine* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactManagerEngine >()),const_cast<QtMobility::QContactManagerEngine*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactManager >(const QtMobility::QContactManager* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactManager >()),const_cast<QtMobility::QContactManager*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactAbstractRequest >(const QtMobility::QContactAbstractRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAbstractRequest >()),const_cast<QtMobility::QContactAbstractRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactSaveRequest >(const QtMobility::QContactSaveRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactSaveRequest >()),const_cast<QtMobility::QContactSaveRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactRemoveRequest >(const QtMobility::QContactRemoveRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRemoveRequest >()),const_cast<QtMobility::QContactRemoveRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactLocalIdFetchRequest >(const QtMobility::QContactLocalIdFetchRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactLocalIdFetchRequest >()),const_cast<QtMobility::QContactLocalIdFetchRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactFetchRequest >(const QtMobility::QContactFetchRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactFetchRequest >()),const_cast<QtMobility::QContactFetchRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactRelationshipSaveRequest >(const QtMobility::QContactRelationshipSaveRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRelationshipSaveRequest >()),const_cast<QtMobility::QContactRelationshipSaveRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactRelationshipRemoveRequest >(const QtMobility::QContactRelationshipRemoveRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRelationshipRemoveRequest >()),const_cast<QtMobility::QContactRelationshipRemoveRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactRelationshipFetchRequest >(const QtMobility::QContactRelationshipFetchRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRelationshipFetchRequest >()),const_cast<QtMobility::QContactRelationshipFetchRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactDetailDefinitionSaveRequest >(const QtMobility::QContactDetailDefinitionSaveRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailDefinitionSaveRequest >()),const_cast<QtMobility::QContactDetailDefinitionSaveRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactDetailDefinitionRemoveRequest >(const QtMobility::QContactDetailDefinitionRemoveRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailDefinitionRemoveRequest >()),const_cast<QtMobility::QContactDetailDefinitionRemoveRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QContactDetailDefinitionFetchRequest >(const QtMobility::QContactDetailDefinitionFetchRequest* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailDefinitionFetchRequest >()),const_cast<QtMobility::QContactDetailDefinitionFetchRequest*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QContactChangeSet > : ValueTypeConverter<QtMobility::QContactChangeSet >
{
};

template<>
struct Converter<QtMobility::QContactManagerEngineFactory* > : ObjectTypeConverter<QtMobility::QContactManagerEngineFactory >
{
};

template<>
struct Converter<QtMobility::QContactManagerEngineFactory& > : ObjectTypeReferenceConverter<QtMobility::QContactManagerEngineFactory >
{
};

template<>
struct Converter<QtMobility::QContactFetchHint::OptimizationHint > : EnumConverter<QtMobility::QContactFetchHint::OptimizationHint >
{
};
template<>
struct Converter<QFlags<QtMobility::QContactFetchHint::OptimizationHint> > : QFlagsConverter<QFlags<QtMobility::QContactFetchHint::OptimizationHint> >
{
};

template<>
struct Converter<QtMobility::QContactFetchHint > : ValueTypeConverter<QtMobility::QContactFetchHint >
{
};

template<>
struct Converter<QtMobility::QContactSortOrder::BlankPolicy > : EnumConverter<QtMobility::QContactSortOrder::BlankPolicy >
{
};

template<>
struct Converter<QtMobility::QContactSortOrder > : ValueTypeConverter<QtMobility::QContactSortOrder >
{
};

template<>
struct Converter<QtMobility::QContact > : ValueTypeConverter<QtMobility::QContact >
{
};

template<>
struct Converter<QtMobility::QContactId > : ValueTypeConverter<QtMobility::QContactId >
{
};

template<>
struct Converter<QtMobility::QContactFilter::MatchFlag > : EnumConverter<QtMobility::QContactFilter::MatchFlag >
{
};
template<>
struct Converter<QFlags<QtMobility::QContactFilter::MatchFlag> > : QFlagsConverter<QFlags<QtMobility::QContactFilter::MatchFlag> >
{
};

template<>
struct Converter<QtMobility::QContactFilter::FilterType > : EnumConverter<QtMobility::QContactFilter::FilterType >
{
};

template<>
struct Converter<QtMobility::QContactFilter > : ValueTypeConverter<QtMobility::QContactFilter >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipFilter > : ValueTypeConverter<QtMobility::QContactRelationshipFilter >
{
    static QtMobility::QContactRelationshipFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactIntersectionFilter > : ValueTypeConverter<QtMobility::QContactIntersectionFilter >
{
    static QtMobility::QContactIntersectionFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactLocalIdFilter > : ValueTypeConverter<QtMobility::QContactLocalIdFilter >
{
    static QtMobility::QContactLocalIdFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactUnionFilter > : ValueTypeConverter<QtMobility::QContactUnionFilter >
{
    static QtMobility::QContactUnionFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactDetailRangeFilter::RangeFlag > : EnumConverter<QtMobility::QContactDetailRangeFilter::RangeFlag >
{
};
template<>
struct Converter<QFlags<QtMobility::QContactDetailRangeFilter::RangeFlag> > : QFlagsConverter<QFlags<QtMobility::QContactDetailRangeFilter::RangeFlag> >
{
};

template<>
struct Converter<QtMobility::QContactDetailRangeFilter > : ValueTypeConverter<QtMobility::QContactDetailRangeFilter >
{
    static QtMobility::QContactDetailRangeFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactDetailFilter > : ValueTypeConverter<QtMobility::QContactDetailFilter >
{
    static QtMobility::QContactDetailFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactInvalidFilter > : ValueTypeConverter<QtMobility::QContactInvalidFilter >
{
    static QtMobility::QContactInvalidFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactChangeLogFilter::EventType > : EnumConverter<QtMobility::QContactChangeLogFilter::EventType >
{
};

template<>
struct Converter<QtMobility::QContactChangeLogFilter > : ValueTypeConverter<QtMobility::QContactChangeLogFilter >
{
    static QtMobility::QContactChangeLogFilter toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactRelationship::Role > : EnumConverter<QtMobility::QContactRelationship::Role >
{
};

template<>
struct Converter<QtMobility::QContactRelationship > : ValueTypeConverter<QtMobility::QContactRelationship >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinition > : ValueTypeConverter<QtMobility::QContactDetailDefinition >
{
};

template<>
struct Converter<QtMobility::QContactDetailFieldDefinition > : ValueTypeConverter<QtMobility::QContactDetailFieldDefinition >
{
};

template<>
struct Converter<QtMobility::QContactDetail::AccessConstraint > : EnumConverter<QtMobility::QContactDetail::AccessConstraint >
{
};
template<>
struct Converter<QFlags<QtMobility::QContactDetail::AccessConstraint> > : QFlagsConverter<QFlags<QtMobility::QContactDetail::AccessConstraint> >
{
};

template<>
struct Converter<QtMobility::QContactDetail > : ValueTypeConverter<QtMobility::QContactDetail >
{
};

template<>
struct Converter<QtMobility::QContactUrl > : ValueTypeConverter<QtMobility::QContactUrl >
{
    static QtMobility::QContactUrl toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactTimestamp > : ValueTypeConverter<QtMobility::QContactTimestamp >
{
    static QtMobility::QContactTimestamp toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactThumbnail > : ValueTypeConverter<QtMobility::QContactThumbnail >
{
    static QtMobility::QContactThumbnail toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactTag > : ValueTypeConverter<QtMobility::QContactTag >
{
    static QtMobility::QContactTag toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactType > : ValueTypeConverter<QtMobility::QContactType >
{
    static QtMobility::QContactType toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactSyncTarget > : ValueTypeConverter<QtMobility::QContactSyncTarget >
{
    static QtMobility::QContactSyncTarget toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactRingtone > : ValueTypeConverter<QtMobility::QContactRingtone >
{
    static QtMobility::QContactRingtone toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactPhoneNumber > : ValueTypeConverter<QtMobility::QContactPhoneNumber >
{
    static QtMobility::QContactPhoneNumber toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactDisplayLabel > : ValueTypeConverter<QtMobility::QContactDisplayLabel >
{
    static QtMobility::QContactDisplayLabel toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactOrganization > : ValueTypeConverter<QtMobility::QContactOrganization >
{
    static QtMobility::QContactOrganization toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactOnlineAccount > : ValueTypeConverter<QtMobility::QContactOnlineAccount >
{
    static QtMobility::QContactOnlineAccount toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactNote > : ValueTypeConverter<QtMobility::QContactNote >
{
    static QtMobility::QContactNote toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactNickname > : ValueTypeConverter<QtMobility::QContactNickname >
{
    static QtMobility::QContactNickname toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactName > : ValueTypeConverter<QtMobility::QContactName >
{
    static QtMobility::QContactName toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactGuid > : ValueTypeConverter<QtMobility::QContactGuid >
{
    static QtMobility::QContactGuid toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactGlobalPresence > : ValueTypeConverter<QtMobility::QContactGlobalPresence >
{
    static QtMobility::QContactGlobalPresence toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactPresence::PresenceState > : EnumConverter<QtMobility::QContactPresence::PresenceState >
{
};

template<>
struct Converter<QtMobility::QContactPresence > : ValueTypeConverter<QtMobility::QContactPresence >
{
    static QtMobility::QContactPresence toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactGeoLocation > : ValueTypeConverter<QtMobility::QContactGeoLocation >
{
    static QtMobility::QContactGeoLocation toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactGender > : ValueTypeConverter<QtMobility::QContactGender >
{
    static QtMobility::QContactGender toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactFamily > : ValueTypeConverter<QtMobility::QContactFamily >
{
    static QtMobility::QContactFamily toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactEmailAddress > : ValueTypeConverter<QtMobility::QContactEmailAddress >
{
    static QtMobility::QContactEmailAddress toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactBirthday > : ValueTypeConverter<QtMobility::QContactBirthday >
{
    static QtMobility::QContactBirthday toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactAvatar > : ValueTypeConverter<QtMobility::QContactAvatar >
{
    static QtMobility::QContactAvatar toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactAnniversary > : ValueTypeConverter<QtMobility::QContactAnniversary >
{
    static QtMobility::QContactAnniversary toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactAddress > : ValueTypeConverter<QtMobility::QContactAddress >
{
    static QtMobility::QContactAddress toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QContactManagerEngine* > : ObjectTypeConverter<QtMobility::QContactManagerEngine >
{
};

template<>
struct Converter<QtMobility::QContactManagerEngine& > : ObjectTypeReferenceConverter<QtMobility::QContactManagerEngine >
{
};

template<>
struct Converter<QtMobility::QContactManager::Error > : EnumConverter<QtMobility::QContactManager::Error >
{
};

template<>
struct Converter<QtMobility::QContactManager::ManagerFeature > : EnumConverter<QtMobility::QContactManager::ManagerFeature >
{
};

template<>
struct Converter<QtMobility::QContactManager* > : ObjectTypeConverter<QtMobility::QContactManager >
{
};

template<>
struct Converter<QtMobility::QContactManager& > : ObjectTypeReferenceConverter<QtMobility::QContactManager >
{
};

template<>
struct Converter<QtMobility::QContactAbstractRequest::RequestType > : EnumConverter<QtMobility::QContactAbstractRequest::RequestType >
{
};

template<>
struct Converter<QtMobility::QContactAbstractRequest::State > : EnumConverter<QtMobility::QContactAbstractRequest::State >
{
};

template<>
struct Converter<QtMobility::QContactAbstractRequest* > : ObjectTypeConverter<QtMobility::QContactAbstractRequest >
{
};

template<>
struct Converter<QtMobility::QContactAbstractRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactAbstractRequest >
{
};

template<>
struct Converter<QtMobility::QContactSaveRequest* > : ObjectTypeConverter<QtMobility::QContactSaveRequest >
{
};

template<>
struct Converter<QtMobility::QContactSaveRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactSaveRequest >
{
};

template<>
struct Converter<QtMobility::QContactRemoveRequest* > : ObjectTypeConverter<QtMobility::QContactRemoveRequest >
{
};

template<>
struct Converter<QtMobility::QContactRemoveRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactRemoveRequest >
{
};

template<>
struct Converter<QtMobility::QContactLocalIdFetchRequest* > : ObjectTypeConverter<QtMobility::QContactLocalIdFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactLocalIdFetchRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactLocalIdFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactFetchRequest* > : ObjectTypeConverter<QtMobility::QContactFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactFetchRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipSaveRequest* > : ObjectTypeConverter<QtMobility::QContactRelationshipSaveRequest >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipSaveRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactRelationshipSaveRequest >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipRemoveRequest* > : ObjectTypeConverter<QtMobility::QContactRelationshipRemoveRequest >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipRemoveRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactRelationshipRemoveRequest >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipFetchRequest* > : ObjectTypeConverter<QtMobility::QContactRelationshipFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactRelationshipFetchRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactRelationshipFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinitionSaveRequest* > : ObjectTypeConverter<QtMobility::QContactDetailDefinitionSaveRequest >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinitionSaveRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactDetailDefinitionSaveRequest >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinitionRemoveRequest* > : ObjectTypeConverter<QtMobility::QContactDetailDefinitionRemoveRequest >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinitionRemoveRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactDetailDefinitionRemoveRequest >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinitionFetchRequest* > : ObjectTypeConverter<QtMobility::QContactDetailDefinitionFetchRequest >
{
};

template<>
struct Converter<QtMobility::QContactDetailDefinitionFetchRequest& > : ObjectTypeReferenceConverter<QtMobility::QContactDetailDefinitionFetchRequest >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QtMobility::QContactRelationshipFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactRelationshipFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRelationshipFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactRelationshipFilter Shiboken::Converter<QtMobility::QContactRelationshipFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactRelationshipFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRelationshipFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactRelationshipFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactRelationshipFilter* cptr = reinterpret_cast<QtMobility::QContactRelationshipFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactRelationshipFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactIntersectionFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactIntersectionFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactIntersectionFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactIntersectionFilter Shiboken::Converter<QtMobility::QContactIntersectionFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactIntersectionFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactIntersectionFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactIntersectionFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactIntersectionFilter* cptr = reinterpret_cast<QtMobility::QContactIntersectionFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactIntersectionFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactLocalIdFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactLocalIdFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactLocalIdFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactLocalIdFilter Shiboken::Converter<QtMobility::QContactLocalIdFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactLocalIdFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactLocalIdFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactLocalIdFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactLocalIdFilter* cptr = reinterpret_cast<QtMobility::QContactLocalIdFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactLocalIdFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactLocalIdFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactUnionFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactUnionFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactUnionFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactUnionFilter Shiboken::Converter<QtMobility::QContactUnionFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactUnionFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactUnionFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactUnionFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactUnionFilter* cptr = reinterpret_cast<QtMobility::QContactUnionFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactUnionFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactUnionFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactDetailRangeFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactDetailRangeFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailRangeFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactDetailRangeFilter Shiboken::Converter<QtMobility::QContactDetailRangeFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactDetailRangeFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailRangeFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactDetailRangeFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactDetailRangeFilter* cptr = reinterpret_cast<QtMobility::QContactDetailRangeFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactDetailRangeFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactDetailRangeFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactDetailFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactDetailFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactDetailFilter Shiboken::Converter<QtMobility::QContactDetailFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactDetailFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDetailFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactDetailFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactDetailFilter* cptr = reinterpret_cast<QtMobility::QContactDetailFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactDetailFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactDetailFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactInvalidFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactInvalidFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactInvalidFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactInvalidFilter Shiboken::Converter<QtMobility::QContactInvalidFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactInvalidFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactInvalidFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactInvalidFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactInvalidFilter* cptr = reinterpret_cast<QtMobility::QContactInvalidFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactInvalidFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactInvalidFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactChangeLogFilter >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactChangeLogFilter >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactChangeLogFilter >());
    return Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactChangeLogFilter Shiboken::Converter<QtMobility::QContactChangeLogFilter >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactChangeLogFilter)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactChangeLogFilter >());
        if (Shiboken::Converter<const QtMobility::QContactFilter & >::checkType(pyobj))
            return QtMobility::QContactChangeLogFilter(Shiboken::Converter<const QtMobility::QContactFilter & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactChangeLogFilter* cptr = reinterpret_cast<QtMobility::QContactChangeLogFilter*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactChangeLogFilter > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactChangeLogFilter* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactUrl >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactUrl >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactUrl >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactUrl Shiboken::Converter<QtMobility::QContactUrl >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactUrl)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactUrl >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactUrl(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactUrl* cptr = reinterpret_cast<QtMobility::QContactUrl*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactUrl > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactUrl* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactTimestamp >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactTimestamp >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactTimestamp >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactTimestamp Shiboken::Converter<QtMobility::QContactTimestamp >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactTimestamp)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactTimestamp >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactTimestamp(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactTimestamp* cptr = reinterpret_cast<QtMobility::QContactTimestamp*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactTimestamp > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactTimestamp* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactThumbnail >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactThumbnail >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactThumbnail >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactThumbnail Shiboken::Converter<QtMobility::QContactThumbnail >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactThumbnail)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactThumbnail >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactThumbnail(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactThumbnail* cptr = reinterpret_cast<QtMobility::QContactThumbnail*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactThumbnail > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactThumbnail* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactTag >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactTag >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactTag >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactTag Shiboken::Converter<QtMobility::QContactTag >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactTag)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactTag >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactTag(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactTag* cptr = reinterpret_cast<QtMobility::QContactTag*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactTag > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactTag* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactType >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactType >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactType >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactType Shiboken::Converter<QtMobility::QContactType >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactType)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactType >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactType(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactType* cptr = reinterpret_cast<QtMobility::QContactType*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactType > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactType* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactSyncTarget >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactSyncTarget >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactSyncTarget >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactSyncTarget Shiboken::Converter<QtMobility::QContactSyncTarget >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactSyncTarget)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactSyncTarget >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactSyncTarget(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactSyncTarget* cptr = reinterpret_cast<QtMobility::QContactSyncTarget*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactSyncTarget > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactSyncTarget* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactRingtone >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactRingtone >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRingtone >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactRingtone Shiboken::Converter<QtMobility::QContactRingtone >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactRingtone)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactRingtone >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactRingtone(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactRingtone* cptr = reinterpret_cast<QtMobility::QContactRingtone*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactRingtone > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactPhoneNumber >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactPhoneNumber >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactPhoneNumber >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactPhoneNumber Shiboken::Converter<QtMobility::QContactPhoneNumber >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactPhoneNumber)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactPhoneNumber >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactPhoneNumber(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactPhoneNumber* cptr = reinterpret_cast<QtMobility::QContactPhoneNumber*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactPhoneNumber > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactPhoneNumber* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactDisplayLabel >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactDisplayLabel >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDisplayLabel >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactDisplayLabel Shiboken::Converter<QtMobility::QContactDisplayLabel >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactDisplayLabel)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactDisplayLabel >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactDisplayLabel(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactDisplayLabel* cptr = reinterpret_cast<QtMobility::QContactDisplayLabel*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactDisplayLabel > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactDisplayLabel* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactOrganization >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactOrganization >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactOrganization >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactOrganization Shiboken::Converter<QtMobility::QContactOrganization >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactOrganization)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactOrganization >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactOrganization(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactOrganization* cptr = reinterpret_cast<QtMobility::QContactOrganization*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactOrganization > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactOnlineAccount >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactOnlineAccount >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactOnlineAccount >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactOnlineAccount Shiboken::Converter<QtMobility::QContactOnlineAccount >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactOnlineAccount)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactOnlineAccount >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactOnlineAccount(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactOnlineAccount* cptr = reinterpret_cast<QtMobility::QContactOnlineAccount*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactOnlineAccount > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactNote >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactNote >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactNote >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactNote Shiboken::Converter<QtMobility::QContactNote >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactNote)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactNote >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactNote(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactNote* cptr = reinterpret_cast<QtMobility::QContactNote*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactNote > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactNote* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactNickname >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactNickname >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactNickname >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactNickname Shiboken::Converter<QtMobility::QContactNickname >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactNickname)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactNickname >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactNickname(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactNickname* cptr = reinterpret_cast<QtMobility::QContactNickname*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactNickname > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactNickname* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactName >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactName >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactName >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactName Shiboken::Converter<QtMobility::QContactName >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactName)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactName >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactName(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactName* cptr = reinterpret_cast<QtMobility::QContactName*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactName > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactName* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactGuid >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactGuid >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGuid >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactGuid Shiboken::Converter<QtMobility::QContactGuid >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactGuid)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGuid >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactGuid(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactGuid* cptr = reinterpret_cast<QtMobility::QContactGuid*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactGuid > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactGuid* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactGlobalPresence >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactGlobalPresence >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGlobalPresence >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactGlobalPresence Shiboken::Converter<QtMobility::QContactGlobalPresence >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactGlobalPresence)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGlobalPresence >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactGlobalPresence(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactGlobalPresence* cptr = reinterpret_cast<QtMobility::QContactGlobalPresence*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactGlobalPresence > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactPresence >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactPresence >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactPresence >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactPresence Shiboken::Converter<QtMobility::QContactPresence >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactPresence)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactPresence >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactPresence(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactPresence* cptr = reinterpret_cast<QtMobility::QContactPresence*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactPresence > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactGeoLocation >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactGeoLocation >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGeoLocation >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactGeoLocation Shiboken::Converter<QtMobility::QContactGeoLocation >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactGeoLocation)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGeoLocation >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactGeoLocation(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactGeoLocation* cptr = reinterpret_cast<QtMobility::QContactGeoLocation*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactGeoLocation > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactGender >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactGender >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGender >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactGender Shiboken::Converter<QtMobility::QContactGender >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactGender)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactGender >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactGender(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactGender* cptr = reinterpret_cast<QtMobility::QContactGender*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactGender > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactGender* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactFamily >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactFamily >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactFamily >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactFamily Shiboken::Converter<QtMobility::QContactFamily >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactFamily)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactFamily >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactFamily(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactFamily* cptr = reinterpret_cast<QtMobility::QContactFamily*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactFamily > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactFamily* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactEmailAddress >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactEmailAddress >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactEmailAddress >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactEmailAddress Shiboken::Converter<QtMobility::QContactEmailAddress >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactEmailAddress)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactEmailAddress >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactEmailAddress(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactEmailAddress* cptr = reinterpret_cast<QtMobility::QContactEmailAddress*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactEmailAddress > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactEmailAddress* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactBirthday >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactBirthday >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactBirthday >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactBirthday Shiboken::Converter<QtMobility::QContactBirthday >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactBirthday)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactBirthday >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactBirthday(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactBirthday* cptr = reinterpret_cast<QtMobility::QContactBirthday*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactBirthday > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactBirthday* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactAvatar >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactAvatar >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAvatar >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactAvatar Shiboken::Converter<QtMobility::QContactAvatar >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactAvatar)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAvatar >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactAvatar(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactAvatar* cptr = reinterpret_cast<QtMobility::QContactAvatar*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactAvatar > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactAvatar* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactAnniversary >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactAnniversary >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAnniversary >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactAnniversary Shiboken::Converter<QtMobility::QContactAnniversary >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactAnniversary)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAnniversary >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactAnniversary(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactAnniversary* cptr = reinterpret_cast<QtMobility::QContactAnniversary*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactAnniversary > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactAnniversary* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QContactAddress >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QContactAddress >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAddress >());
    return Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QContactAddress Shiboken::Converter<QtMobility::QContactAddress >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QContactAddress)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QContactAddress >());
        if (Shiboken::Converter<const QtMobility::QContactDetail & >::checkType(pyobj))
            return QtMobility::QContactAddress(Shiboken::Converter<const QtMobility::QContactDetail & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QContactAddress* cptr = reinterpret_cast<QtMobility::QContactAddress*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QContactAddress > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(pyobj);
}


#endif // SBK_CONTACTS_PYTHON_H

