/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_bearer_python.h"

#include "qtmobility_qnetworksession_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qnetworkconfiguration.h>
#include <qnetworkinterface.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QNetworkSessionWrapper::QNetworkSessionWrapper(const QtMobility::QNetworkConfiguration & connConfig, QObject * parent) : QtMobility::QNetworkSession(connConfig, parent), m_metaObject(0) {
    // ... middle
}

void QNetworkSessionWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkSessionWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QNetworkSession::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNetworkSessionWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkSessionWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QNetworkSession::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QNetworkSessionWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkSession.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QNetworkSessionWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkSession.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QNetworkSessionWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QNetworkSessionWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QNetworkSession::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QNetworkSessionWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QNetworkSession::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QNetworkSessionWrapper::~QNetworkSessionWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QNetworkSession_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QNetworkSession >()))
        return -1;

    QNetworkSessionWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Bearer.QNetworkSession(): not enough arguments");
        return -1;
    }

    if (!PyArg_ParseTuple(args, "|OO:QNetworkSession", &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QNetworkSession(QtMobility::QNetworkConfiguration,QObject*)
    if (Shiboken::Converter<const QtMobility::QNetworkConfiguration & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // QNetworkSession(QtMobility::QNetworkConfiguration,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            overloadId = 0; // QNetworkSession(QtMobility::QNetworkConfiguration,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkSession_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "parent";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Bearer.QNetworkSession(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return -1;
            QtMobility::QNetworkConfiguration* cpp_arg0 = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QObject* >::toCpp(pyargs[1]) : 0;

            if(!PyErr_Occurred()) {
            // QNetworkSession(QtMobility::QNetworkConfiguration,QObject*)
            cptr = new QNetworkSessionWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QNetworkSession >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QNetworkSession_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QNetworkSession_Init_TypeError:
        const char* overloads[] = {"QtMobility.Bearer.QtMobility::QNetworkConfiguration, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Bearer.QNetworkSession", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_accept(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // accept()
            cppSelf->QtMobility::QNetworkSession::accept();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_activeTime(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // activeTime()const
            quint64 cppResult = cppSelf->QtMobility::QNetworkSession::activeTime();
            pyResult = Shiboken::Converter<unsigned long long >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_bytesReceived(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // bytesReceived()const
            quint64 cppResult = cppSelf->QtMobility::QNetworkSession::bytesReceived();
            pyResult = Shiboken::Converter<unsigned long long >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_bytesWritten(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // bytesWritten()const
            quint64 cppResult = cppSelf->QtMobility::QNetworkSession::bytesWritten();
            pyResult = Shiboken::Converter<unsigned long long >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_close(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // close()
            cppSelf->QtMobility::QNetworkSession::close();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_configuration(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // configuration()const
            QtMobility::QNetworkConfiguration cppResult = cppSelf->QtMobility::QNetworkSession::configuration();
            pyResult = Shiboken::Converter<QtMobility::QNetworkConfiguration >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_connectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: connectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // connectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkSessionFunc_connectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // connectNotify(const char*)
            cppSelf->QtMobility::QNetworkSession::connectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QNetworkSessionFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Bearer.QNetworkSession.connectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_disconnectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: disconnectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // disconnectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkSessionFunc_disconnectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // disconnectNotify(const char*)
            cppSelf->QtMobility::QNetworkSession::disconnectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QNetworkSessionFunc_disconnectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Bearer.QNetworkSession.disconnectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_error(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QNetworkSession::SessionError cppResult = cppSelf->QtMobility::QNetworkSession::error();
            pyResult = Shiboken::Converter<QtMobility::QNetworkSession::SessionError >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_errorString(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = cppSelf->QtMobility::QNetworkSession::errorString();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_ignore(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // ignore()
            cppSelf->QtMobility::QNetworkSession::ignore();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_interface(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // interface()const
            QNetworkInterface cppResult = cppSelf->QtMobility::QNetworkSession::interface();
            pyResult = Shiboken::Converter<QNetworkInterface >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_isOpen(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isOpen()const
            bool cppResult = cppSelf->QtMobility::QNetworkSession::isOpen();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_migrate(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // migrate()
            cppSelf->QtMobility::QNetworkSession::migrate();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_open(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // open()
            cppSelf->QtMobility::QNetworkSession::open();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_reject(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // reject()
            cppSelf->QtMobility::QNetworkSession::reject();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_sessionProperty(PyObject* self, PyObject* arg)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: sessionProperty(QString)const
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // sessionProperty(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkSessionFunc_sessionProperty_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // sessionProperty(QString)const
            QVariant cppResult = cppSelf->QtMobility::QNetworkSession::sessionProperty(cpp_arg0);
            pyResult = Shiboken::Converter<QVariant >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QNetworkSessionFunc_sessionProperty_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Bearer.QNetworkSession.sessionProperty", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_setSessionProperty(PyObject* self, PyObject* args)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSessionProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setSessionProperty(QString,QVariant)
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[1])) {
        overloadId = 0; // setSessionProperty(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkSessionFunc_setSessionProperty_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QVariant cpp_arg1 = Shiboken::Converter<QVariant >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setSessionProperty(QString,QVariant)
            cppSelf->QtMobility::QNetworkSession::setSessionProperty(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QNetworkSessionFunc_setSessionProperty_TypeError:
        const char* overloads[] = {"QString, QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Bearer.QNetworkSession.setSessionProperty", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_state(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // state()const
            QtMobility::QNetworkSession::State cppResult = cppSelf->QtMobility::QNetworkSession::state();
            pyResult = Shiboken::Converter<QtMobility::QNetworkSession::State >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_stop(PyObject* self)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // stop()
            cppSelf->QtMobility::QNetworkSession::stop();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNetworkSessionFunc_waitForOpened(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QNetworkSession* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkSession* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "msecs" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Bearer.QNetworkSession.waitForOpened(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Bearer.QNetworkSession.waitForOpened(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForOpened", &arg))
        return 0;


    // Overloaded function decisor
    // 0: waitForOpened(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForOpened(int)
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // waitForOpened(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkSessionFunc_waitForOpened_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "msecs");
                if (value) {
                    if (arg)
                        errorArgName = "msecs";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Bearer.QNetworkSession.waitForOpened(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            int cpp_arg0 = arg ? Shiboken::Converter<int >::toCpp(arg) : 30000;

            if(!PyErr_Occurred()) {
            // waitForOpened(int)
            bool cppResult = cppSelf->QtMobility::QNetworkSession::waitForOpened(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QNetworkSessionFunc_waitForOpened_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Bearer.QNetworkSession.waitForOpened", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QNetworkSession_methods[] = {
    {"accept", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_accept, METH_NOARGS},
    {"activeTime", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_activeTime, METH_NOARGS},
    {"bytesReceived", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_bytesReceived, METH_NOARGS},
    {"bytesWritten", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_bytesWritten, METH_NOARGS},
    {"close", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_close, METH_NOARGS},
    {"configuration", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_configuration, METH_NOARGS},
    {"connectNotify", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_connectNotify, METH_O},
    {"disconnectNotify", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_disconnectNotify, METH_O},
    {"error", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_errorString, METH_NOARGS},
    {"ignore", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_ignore, METH_NOARGS},
    {"interface", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_interface, METH_NOARGS},
    {"isOpen", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_isOpen, METH_NOARGS},
    {"migrate", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_migrate, METH_NOARGS},
    {"open", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_open, METH_NOARGS},
    {"reject", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_reject, METH_NOARGS},
    {"sessionProperty", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_sessionProperty, METH_O},
    {"setSessionProperty", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_setSessionProperty, METH_VARARGS},
    {"state", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_stop, METH_NOARGS},
    {"waitForOpened", (PyCFunction)SbkQtMobility_QNetworkSessionFunc_waitForOpened, METH_VARARGS|METH_KEYWORDS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QNetworkSession_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Bearer.QNetworkSession",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QNetworkSession_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QNetworkSession_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QNetworkSession >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QNetworkSession*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QNetworkSession_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QNetworkSession*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QNetworkSession_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SessionError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QNetworkSession(PyObject* module)
{
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKSESSION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QNetworkSession_Type);

    SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QNetworkSession_Type.type_discovery = &SbkQtMobility_QNetworkSession_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QNetworkSession_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QNetworkSession_Type) < 0)
        return;

    PyDict_SetItemString(module,"QNetworkSession", (PyObject*)&SbkQtMobility_QNetworkSession_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: SessionError
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKSESSION_SESSIONERROR_IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
            "SessionError",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type,
        (long) QtMobility::QNetworkSession::UnknownSessionError, "UnknownSessionError");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "UnknownSessionError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type.tp_dict,
        "UnknownSessionError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type,
        (long) QtMobility::QNetworkSession::SessionAbortedError, "SessionAbortedError");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "SessionAbortedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type.tp_dict,
        "SessionAbortedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type,
        (long) QtMobility::QNetworkSession::RoamingError, "RoamingError");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "RoamingError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type.tp_dict,
        "RoamingError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type,
        (long) QtMobility::QNetworkSession::OperationNotSupportedError, "OperationNotSupportedError");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "OperationNotSupportedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type.tp_dict,
        "OperationNotSupportedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type,
        (long) QtMobility::QNetworkSession::InvalidConfigurationError, "InvalidConfigurationError");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "InvalidConfigurationError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_SessionError_Type.tp_dict,
        "InvalidConfigurationError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNetworkSession::SessionError");

    // init enum class: State
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKSESSION_STATE_IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::Invalid, "Invalid");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "Invalid", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "Invalid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::NotAvailable, "NotAvailable");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "NotAvailable", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "NotAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::Connecting, "Connecting");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "Connecting", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "Connecting", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::Connected, "Connected");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "Connected", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "Connected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::Closing, "Closing");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "Closing", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "Closing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::Disconnected, "Disconnected");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "Disconnected", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "Disconnected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type,
        (long) QtMobility::QNetworkSession::Roaming, "Roaming");
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict,
        "Roaming", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkSession_State_Type.tp_dict,
        "Roaming", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNetworkSession::State");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("error", "QtMobility::QNetworkSession::SessionError", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict, "error", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("preferredConfigurationChanged", "const QtMobility::QNetworkConfiguration&,bool", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict, "preferredConfigurationChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("newConfigurationActivated", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict, "newConfigurationActivated", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("opened", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict, "opened", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("closed", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict, "closed", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("stateChanged", "QtMobility::QNetworkSession::State", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkSession_Type.super.ht_type.tp_dict, "stateChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkSession >("QtMobility::QNetworkSession*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkSession >(typeid(QtMobility::QNetworkSession).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkSession >(typeid(QNetworkSessionWrapper).name());
    PySide::initQtMetaType<QtMobility::QNetworkSession* >();
}

