/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_BEARER_PYTHON_H
#define SBK_BEARER_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>
#include <pyside_qtnetwork_python.h>

// Binded library includes
#include <qnetworksession.h>
#include <qnetworkconfiguration.h>
#include <qnetworkconfigmanager.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_IDX                                           0
#define SBK_QTMOBILITY_QNETWORKCONFIGURATION_IDX                     1
#define SBK_QTMOBILITY_QNETWORKCONFIGURATION_PURPOSE_IDX             2
#define SBK_QTMOBILITY_QNETWORKCONFIGURATION_TYPE_IDX                3
#define SBK_QTMOBILITY_QNETWORKCONFIGURATION_STATEFLAG_IDX           4
#define SBK_QFLAGS_QTMOBILITY_QNETWORKCONFIGURATION_STATEFLAG__IDX   5
#define SBK_QTMOBILITY_QNETWORKSESSION_IDX                           6
#define SBK_QTMOBILITY_QNETWORKSESSION_SESSIONERROR_IDX              7
#define SBK_QTMOBILITY_QNETWORKSESSION_STATE_IDX                     8
#define SBK_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_IDX              9
#define SBK_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX   10
#define SBK_QFLAGS_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_CAPABILITY__IDX 11
#define SBK_Bearer_IDX_COUNT                                         12

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_BearerTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkConfiguration::Purpose >() { return SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_PURPOSE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkConfiguration::Type >() { return SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkConfiguration::StateFlag >() { return SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_STATEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QNetworkConfiguration::StateFlag> >() { return SbkQtMobility_BearerTypes[SBK_QFLAGS_QTMOBILITY_QNETWORKCONFIGURATION_STATEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkConfiguration >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkSession::SessionError >() { return SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKSESSION_SESSIONERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkSession::State >() { return SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKSESSION_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkSession >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKSESSION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkConfigurationManager::Capability >() { return SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QNetworkConfigurationManager::Capability> >() { return SbkQtMobility_BearerTypes[SBK_QFLAGS_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_CAPABILITY__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNetworkConfigurationManager >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QNetworkSession >(const QtMobility::QNetworkSession* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QNetworkSession >()),const_cast<QtMobility::QNetworkSession*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QNetworkConfigurationManager >(const QtMobility::QNetworkConfigurationManager* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QNetworkConfigurationManager >()),const_cast<QtMobility::QNetworkConfigurationManager*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QNetworkConfiguration::Purpose > : EnumConverter<QtMobility::QNetworkConfiguration::Purpose >
{
};

template<>
struct Converter<QtMobility::QNetworkConfiguration::Type > : EnumConverter<QtMobility::QNetworkConfiguration::Type >
{
};

template<>
struct Converter<QtMobility::QNetworkConfiguration::StateFlag > : EnumConverter<QtMobility::QNetworkConfiguration::StateFlag >
{
};
template<>
struct Converter<QFlags<QtMobility::QNetworkConfiguration::StateFlag> > : QFlagsConverter<QFlags<QtMobility::QNetworkConfiguration::StateFlag> >
{
};

template<>
struct Converter<QtMobility::QNetworkConfiguration > : ValueTypeConverter<QtMobility::QNetworkConfiguration >
{
};

template<>
struct Converter<QtMobility::QNetworkSession::SessionError > : EnumConverter<QtMobility::QNetworkSession::SessionError >
{
};

template<>
struct Converter<QtMobility::QNetworkSession::State > : EnumConverter<QtMobility::QNetworkSession::State >
{
};

template<>
struct Converter<QtMobility::QNetworkSession* > : ObjectTypeConverter<QtMobility::QNetworkSession >
{
};

template<>
struct Converter<QtMobility::QNetworkSession& > : ObjectTypeReferenceConverter<QtMobility::QNetworkSession >
{
};

template<>
struct Converter<QtMobility::QNetworkConfigurationManager::Capability > : EnumConverter<QtMobility::QNetworkConfigurationManager::Capability >
{
};
template<>
struct Converter<QFlags<QtMobility::QNetworkConfigurationManager::Capability> > : QFlagsConverter<QFlags<QtMobility::QNetworkConfigurationManager::Capability> >
{
};

template<>
struct Converter<QtMobility::QNetworkConfigurationManager* > : ObjectTypeConverter<QtMobility::QNetworkConfigurationManager >
{
};

template<>
struct Converter<QtMobility::QNetworkConfigurationManager& > : ObjectTypeReferenceConverter<QtMobility::QNetworkConfigurationManager >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_BEARER_PYTHON_H

