#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '0.5'

# files to install
inst_images = ['pixmaps/add.png', 'pixmaps/clear.png', 'pixmaps/delete.png',
'pixmaps/edit.png', 'pixmaps/image.png', 'pixmaps/play.png', 'pixmaps/reset.png',
'pixmaps/mark.png', 'pixmaps/maemoorg.png']
inst_dbus = ['pyrecipe.service']
inst_desktop = ['pyrecipe.desktop']
inst_icon = ['pyrecipe.png']
inst_icon_sca = ['pixmaps/pyrecipe.png']
inst_py = ['pyrecipe.py', 'shopping_list.py','timer.py', 'pyrecipe_utils.py',
'defaultrecipedb.py', 'portrait.py']
#inst_help = ['pyrecipe.xml']
inst_filters = ['filters/__init__.py', 'filters/gourmet_xml_export.py',
'filters/gourmet_xml_import.py', 'filters/html_export.py',
'filters/krecipe_export.py','filters/krecipe_import.py',
'filters/mealmaster_export.py']
backup_conf  = ['pyrecipe.conf']
sh = ['pyrecipe']

data_files = [
  ('/opt/pyrecipe/pixmaps', inst_images),
  ('share/applications/hildon', inst_desktop),
  ('share/dbus-1/services',   inst_dbus),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
  ('/opt/pyrecipe',   inst_py),
  ('/opt/pyrecipe/filters',   inst_filters),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'pyrecipe',
  version      = version,
  description  = 'Organizer for your cooking recipes',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'http://pyrecipe.garage.maemo.org/',
  data_files   = data_files,
  scripts      = sh
)
