import hildon
from lxml import etree
import pyrecipe_utils
import gettext

def show_info_banner(widget, msg):
    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

class KRecipes:
    def __init__ (self, exp_recipe_list, window, widget):
        for recipe in range(len(exp_recipe_list)):

            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            image = exp_recipe_list[recipe][9]

            if recipe == 0:
                xmldocu = self.write_xml(title, instructions, category,
                            preptime, cooktime, servings, notes, ingredients,
                            image, None)
            else:
                xmldocu = self.write_xml(title, instructions, category,
                            preptime, cooktime, servings, notes, ingredients,
                            image, xmldocu)

        if len(exp_recipe_list) > 1:
            title = _('Recipes')

        namefile = pyrecipe_utils.show_filechooser_dialog(window, 'save',
                        _('Save recipe as '), title, 'KRecipes', 'kreml')

        if namefile == None:
            print 'No saving recipe.'
            return

        success = pyrecipe_utils.save_xml_file(namefile, xmldocu)

        if success == True:
            show_info_banner(widget, _('Recipes saved'))
        else:
            show_info_banner(widget, _('Error ocurred while exporting the file'))


    def write_xml(self, title, instructions, category, preptime, cooktime,
        servings, notes, ingredients, image, xmldocu):

        #print 'xmldocu: ', xmldocu
        if xmldocu is None:
            xmldocu  = etree.Element("krecipes")
        else:
            xmldocu = etree.XML(xmldocu)

        recipe = etree.SubElement(xmldocu, "krecipes-recipe")

        desc = etree.SubElement(recipe, 'krecipes-description')

        title_el = etree.SubElement(desc, 'title')
        title_el.text = title

        img_el = etree.SubElement(desc, 'pictures')

        pic_el = etree.SubElement(img_el, 'pic')
        pic_el.set("id", "1")
        pic_el.set("format", "JPG")

        image = "<![CDATA[" + image.replace('"""', '') + "]]>"
        pic_el.text = image

        category_el = etree.SubElement(desc, 'category')
        cats_el = etree.SubElement(category_el, 'cat')
        cats_el.text = category


        #we change the default time in Pyrecipe to Krecipes format -> 00:00
        #This will be a bug if the time has 'hours' or different format.
        if 'minutes' in preptime:
            preptime = '00:' + preptime.split(" ")[0]

        preptime_el = etree.SubElement(desc, 'preparation-time')
        preptime_el.text = preptime

        yield_el = etree.SubElement(desc, 'yield')

        servamount_el = etree.SubElement(yield_el, 'amount')
        servamount_el.text = servings
        servings_el = etree.SubElement(yield_el, 'type')
        servings_el.text = 'Servings'

        ing_list_el = etree.SubElement(recipe, 'krecipes-ingredients')

        ing_list = pyrecipe_utils.ingredients_to_inglist(ingredients)

        for i in range(len(ing_list)):
            ingredien_el = etree.SubElement(ing_list_el, 'ingredient')

            amount_el = etree.SubElement(ing_list_el, 'amount')
            amount_el.text = ing_list[i][0]

            units_el = etree.SubElement(ing_list_el, 'unit')
            units_el.text = ing_list[i][1]

            items_el = etree.SubElement(ing_list_el, 'name')
            items_el.text = ing_list[i][2]

        instructions_el = etree.SubElement(recipe, 'krecipes-instructions')
        instructions_el.text = instructions

        xmldocu = (etree.tostring(xmldocu, pretty_print=True))

        return xmldocu
