#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '0.2'

# files to install
inst_images = ['pixmaps/add.png', 'pixmaps/clear.png', 'pixmaps/delete.png',
'pixmaps/edit.png', 'pixmaps/image.png', 'pixmaps/new.png',
'pixmaps/remove.png', 'pixmaps/save.png', 'pixmaps/view.png',
'pixmaps/play.png', 'pixmaps/reset.png', 'pixmaps/pause.png',
'pixmaps/mark.png', 'pixmaps/search.png', 'pixmaps/maemoorg.png']
#'pixmaps/about.png', 'pixmaps/backup.png', 'pixmaps/export.png', 'pixmaps/help.png'
#'pixmaps/import.png', 'pixmaps/list.png', 'pixmaps/quit.png'
#'pixmaps/timer.png', 'pixmaps/shop.png'
inst_dbus = [ 'pyrecipe_service.service' ]
inst_desktop = [ 'pyrecipe.desktop' ]
inst_icon = ['pyrecipe.png' ]
inst_icon_sca = ['pixmaps/pyrecipe.png']
inst_py = ['pyrecipe.py', 'shopping_list.py','timer.py', 'pyrecipe_utils.py',
'backup.py', 'defaultrecipedb.py']
#inst_help = ['pyrecipe.xml']
inst_filters = ['filters/__init__.py', 'filters/gourmet_xml_export.py',
'filters/gourmet_xml_import.py', 'filters/html_export.py',
'filters/krecipe_export.py','filters/krecipe_import.py',
'filters/mealmaster_export.py']
backup_conf  = ['pyrecipe-backup.conf']

data_files = [
  ('share/pyrecipe/pixmaps', inst_images),
  ('share/applications/hildon', inst_desktop),
  ('share/dbus-1/services',   inst_dbus),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
  ('share/pyrecipe',   inst_py),
#  ('PO',   inst_po),
  ('share/pyrecipe/filters',   inst_filters),
#  ('share/osso-help/en_GB',   inst_help),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'pyrecipe',
  version      = version,
  description  = 'Organizer for your cooking recipes',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'http://pyrecipe.garage.maemo.org/',
  data_files   = data_files
)
