from xml.dom import minidom
import os

class KRecipes:
    def initiation(self, filename):

        if os.path.splitext(filename)[1] == '.kre':
            import gzip
            f = gzip.open(filename, 'rb')
            data = data = f.read().rsplit('\x00')
            f.close()
            for item in data:
                if item.startswith("<?xml"):
                    xmlstring = item
                    xml_document = minidom.parseString(xmlstring)
        else:
            xml_document = minidom.parse(filename)

        title_list, category_list, preptime_list, servings_list, ing_list, \
                instructions_list, picture_list = self.xml_load(xml_document)
        #print category_list

        recipes_info = [title_list, category_list, preptime_list, '0 minutes', servings_list,
                                ing_list, instructions_list, '', picture_list]

        print recipes_info[4]

        n_items = len(title_list)
        for lista in recipes_info:
            if lista == instructions_list:
                lista = self.do_treatment_to_lists(lista, n_items, True, False)
            elif lista == ing_list:
                pass
            elif lista == '0 minutes' or lista == '':
                nlist = []
                for i in range(n_items):
                    nlist.append([i+1, lista])
                if lista == '':
                    #recipes_info[1] = nlist
                    recipes_info[7] = nlist
                elif lista == '0 minutes':
                    recipes_info[3] = nlist

            else:
                lista = self.do_treatment_to_lists(lista, n_items, False, False)

        #print 'antes:', ing_list
        #print 'despues: ', ing_list
        recipes_info[5] = ing_list
        #print ing_list
        #print 'lista: ', ing_list

        #print recipes_info[1]

        return recipes_info

    def xml_load(self, xml_document):
        ing_list = []

        title_list = []
        category_list = []
        preptime_list = []
        servings_list = []
        instructions_list = []
        picture_list = []
        idd = 0
        for node in xml_document.documentElement.childNodes:
            if node.nodeName == 'krecipes-recipe':
                for item_node in node.childNodes:
                    if item_node.nodeName == 'krecipes-description':
                        for desc_nodes in item_node.childNodes:
                            if desc_nodes.nodeName == 'title':
                                idd += 1
                                tup = [idd, desc_nodes.firstChild.nodeValue]
                                title_list.append(tup)
                            elif desc_nodes.nodeName == 'category':
                                for categ_node in desc_nodes.childNodes:
                                    if categ_node.nodeName == 'cat':
                                        if categ_node.firstChild is None:
                                            pass
                                        else:
                                            tup = [idd, categ_node.firstChild.nodeValue]
                                            category_list.append(tup)
                                            #Just get the first available category
                                            break
                            elif desc_nodes.nodeName == 'preparation-time':
                                if desc_nodes.firstChild is None:
                                    pass
                                else:
                                    tup = [idd, desc_nodes.firstChild.nodeValue]
                                    preptime_list.append(tup)
                            elif desc_nodes.nodeName == 'yield':
                                for yield_node in desc_nodes.childNodes:
                                    if yield_node.firstChild is None:
                                        continue
                                    if yield_node.nodeName == "amount":
                                        amserv = yield_node.firstChild.nodeValue
                                    if yield_node.firstChild.nodeValue == "Servings":
                                        tup = [idd, amserv]
                                        servings_list.append(tup)
                            elif desc_nodes.nodeName == 'pictures':
                                for pict_node in desc_nodes.childNodes:
                                    if pict_node.nodeName == 'pic':
                                        if pict_node.firstChild is None:
                                            pass
                                        else:
                                            tup = [idd, pict_node.firstChild.nodeValue]
                                            picture_list.append(tup)
                                            #Just get the first available pic
                                            break
                    elif item_node.nodeName == 'krecipes-ingredients':
                        one_item = ''
                        new_list = []
                        for each_node in item_node.childNodes:
                            if each_node.nodeName == 'ingredient':
                                for new_nodes in each_node.childNodes:
                                    if new_nodes.nodeName == 'name':
                                        if new_nodes.firstChild is None:
                                            pass
                                        else:
                                            item = new_nodes.firstChild.nodeValue.replace('\t', '').replace('\n', '')
                                            one_item = one_item + item + '\n'
                                    elif new_nodes.nodeName == 'amount':
                                        if new_nodes.firstChild.nodeValue is None:
                                            pass
                                        else:
                                            amount = new_nodes.firstChild.nodeValue.replace('\t', '').replace('\n', '')
                                            one_item = amount + '||<unit>||' + one_item
                                    elif new_nodes.nodeName == 'unit':
                                        if new_nodes.firstChild is None:
                                            pass
                                        else:
                                            unit = new_nodes.firstChild.nodeValue.replace('\t', '').replace('\n', '')
                                            one_item = one_item.replace('<unit>', unit)
                                one_item = self.tratar_one_ing(one_item)
                                new_list.append(one_item)
                                one_item = ''
                        tup = [idd, ('').join(new_list)]
                        ing_list.append(tup)
                    elif item_node.nodeName == 'krecipes-instructions':
                        if item_node.firstChild is None:
                            pass
                        else:
                            tup = [idd, item_node.firstChild.nodeValue]
                            instructions_list.append(tup)

        return title_list, category_list, preptime_list, \
                servings_list, ing_list, instructions_list, picture_list


    def tratar_one_ing(self, one_item):
        import re
        #print 'antes: ', one_item
        one_item = one_item.replace('<unit>', '')
        hele = re.compile(r'\||')
        if hele.findall(one_item).count('|') == 4: #tiene cuatro |||| no hacer nada
            pass
        elif hele.findall(one_item).count('|') == 2: #tiene solo dos ||, reemplazar || por ||||
            one_item  = one_item.replace('||', '||||')
        elif hele.findall(one_item).count('|') == 0: ## anadir |||| al principio.
            one_item = '||||' + one_item

        #print 'despues: ', one_item
        return one_item

    def do_treatment_to_lists(self, lista, n_items, text_list, categlist):
        if categlist:
            pass

        else:
            for i in range(len(lista)):
                if text_list:
                    new_item = lista[i][1].replace('\t', '')
                else:
                    if lista[i][1] == None:
                        lista[i][1] = ''
                    new_item = lista[i][1].replace('\t', '').replace('\n', '')
                lista[i][1] = new_item

            lista2 = []
            for i in range(len(lista)):
                lista2.append(lista[i][0])

            lista1 = []
            for i in range(n_items):
                lista1.append(i+1)

            for i in lista1:
                if i in lista2:
                    pass
                else:
                    lista.append([i, ''])

            lista = lista.sort()

        return lista
