import gtk
import hildon
import os
import datetime
import pyrecipe_utils
import shutil
import sqlite3

dbfile = os.path.expanduser("~")+'/.pyrecipe/database'

fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL

class BackupGui:
    def __init__(self, window):
        backup_dlg = gtk.Dialog(title='Backup', parent=None)
        self.backup_type = None

        date_today = datetime.date.today()
        title = 'pyrecipe-backup-' + date_today.isoformat()

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Import Backup')
        button.connect("clicked", self.on_import_backup, backup_dlg,
                                title, window)
        backup_dlg.vbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_title('Export Backup')
        button.connect("clicked", self.on_export_backup, backup_dlg,
                                title, window)
        backup_dlg.vbox.pack_start(button, True, True, 0)

        backup_dlg.show_all()

        result = backup_dlg.run()
        backup_dlg.destroy()

    def on_import_backup(self, widget, dialog, title, window):
        dialog.destroy()
        self.backup_type = 'import'
        namefile = pyrecipe_utils.show_filechooser_dialog(window, 'open',
                    'Import ', '', 'backup', '')

        if namefile == None:
            self.backup_type = None
            return

        db_old = sqlite3.connect(namefile)
        saved_reclist = pyrecipe_utils.get_recipe_list(db_old)
        #print 'saved_list: ', saved_reclist

        db_current = sqlite3.connect(dbfile)
        current_reclist = pyrecipe_utils.get_recipe_list(db_current)
        #print 'current list: ', current_reclist

        same_recipe = []
        self.backup_titles = []
        for i in range(len(saved_reclist)):
            for j in range(len(current_reclist)):
                if saved_reclist[i][1] == current_reclist[j][1]:
                    #print 'same recipe: ', saved_reclist[i][1]
                    same_recipe.append(saved_reclist[i][1])
                else:
                    #print 'different recipe: ', saved_reclist[i][1]
                    pass

        for k in range(len(saved_reclist)):
            if saved_reclist[k][1] in same_recipe:
                pass
            else:
                self.backup_titles.append(saved_reclist[k][1])

        self.recipe_ids = []
        for n in range(len(self.backup_titles)):
            lista = []
            ##get the new recipes from the database
            for row in db_old.execute('select * from recipes where title="%s"'
                                    % self.backup_titles[n]):
                lista.append(row)

            ##add the new recipes to the database
            sqlite_cursor = db_current.cursor()

            sqlite_cursor.execute('INSERT INTO recipes VALUES (null, ?, ?, '
                            '?, ?, ?, ?, ?, ?, ?)', (lista[0][1], lista[0][2],
                            lista[0][3], lista[0][4], lista[0][5], lista[0][6],
                            lista[0][7], lista[0][8], lista[0][9]))

            db_current.commit()

            new_recipe_id = sqlite_cursor.lastrowid
            self.recipe_ids.append(new_recipe_id)
            sqlite_cursor.close()

    def on_export_backup(self, widget, dialog, title, window):
        dialog.destroy()
        self.backup_type = 'export'
        namefile = pyrecipe_utils.show_filechooser_dialog(window, 'save',
                            'Export ', title, 'backup', 'db')

        if namefile == None:
            self.backup_type = None
            return

        shutil.copyfile(dbfile, namefile)
