# -*- coding: UTF8 -*-
import gtk
import hildon
import os
import pyrecipe_utils
import gobject
import osso
#FIXME:
#import osso.alarmd
import time

fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL

class Timer:
    def __init__(self, imagesdir, osso_c):
        self.window = hildon.Window()
        self.window.set_default_size(800, 480)
        self.window.set_title('Pyrecipe - Timer')
        self.window.connect("delete-event", self.hide_window)

        vbox = gtk.VBox()
        vbox.set_homogeneous(True)

        self.osso_c = osso_c

        self.running = False

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        self.hours = hildon.PickerButton(fhsize, horbtn)
        data = []
        for i in range(24):
            data.append(str(i))
        selector = self.create_selector(data)
        self.hours.set_selector(selector)
        self.hours.set_title("Hours")
        self.hours.set_value("0")

        self.minutes = hildon.PickerButton(fhsize, horbtn)
        data = []
        for i in range(60):
            data.append(str(i))
        selector = self.create_selector(data)
        self.minutes.set_selector(selector)
        self.minutes.set_title("Minutes")
        self.minutes.set_value("10")

        self.seconds = hildon.PickerButton(fhsize, horbtn)
        data = []
        for i in range(60):
            data.append(str(i))
        selector = self.create_selector(data)
        self.seconds.set_selector(selector)
        self.seconds.set_title("Seconds")
        self.seconds.set_value("0")

        hbox.pack_start(self.hours, True, True, 0)
        hbox.pack_start(self.minutes, True, True, 0)
        hbox.pack_start(self.seconds, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_label("Reset")
        img = gtk.Image()
        img.set_from_file(imagesdir + 'reset.png')
        button.set_image(img)
        button.connect('clicked', self.on_reset)
        hbox.pack_start(button, True, True, 0)

        #FIXME: quit pause button??
        button = hildon.Button(fhsize, horbtn)
        button.set_label("Pause")
        img = gtk.Image()
        img.set_from_file(imagesdir + 'pause.png')
        button.set_image(img)
        #button.connect('clicked', self.on_reset)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_label("Start")
        img = gtk.Image()
        img.set_from_file(imagesdir + 'play.png')
        button.set_image(img)
        button.connect('clicked', self.on_start)
        hbox.pack_start(button, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        self.ennote = hildon.Entry(fhsize)
        self.ennote.set_placeholder("Note")

        vbox.pack_start(self.ennote, False, False, 0)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        button.set_label("Hide")
        button.connect('clicked', self.only_hide)
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_label("Delete")
        button.connect('clicked', self.hide_window)
        hbox.pack_start(button, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        self.window.add(vbox)
        self.window.show_all()

    def create_selector(self, data):
        selector = hildon.hildon_touch_selector_new_text()
        for i in range(len(data)):
            selector.append_text(data[i])

        return selector

    #Show the window if it isn' running
    def show(self):
        self.window.show()
        self.window.present()
        return True

    #Hide window and reset value, clicking in 'Delete' button or closing window
    def hide_window(self, widget, ev=None):
        self.on_reset(widget)
        self.window.hide()
        return True

    #Only hide the window, clicking in 'Hide' button
    def only_hide(self, widget):
        self.window.hide()
        return True

    #Set timer to default values
    def on_reset(self, widget):
        self.running = False
        self.ennote.set_text('')
        self.hours.set_value("0")
        self.minutes.set_value("10")
        self.seconds.set_value("0")
        try:
            osso.alarmd.cancel_alarm(self.alarm_id)
        except:
            print 'no alarm setted'

    #Start the timer
    def on_start(self, widget):
        self.running = True
        self.timer_id = gobject.timeout_add(1000, self.do_timer)

    #Update the timer values
    def do_timer(self):
        if self.running:
            ##This code is from eggtimer app. Thank you axique.
            svalue=int(self.seconds.get_value())
            mvalue=int(self.minutes.get_value())
            hvalue=int(self.hours.get_value())

            if ((svalue==0)and(mvalue==0)and(hvalue==0)): return True
            svalue-=1
            if (svalue<0):
                svalue=0
                if ((mvalue>0)or(hvalue>0)): svalue=59
                mvalue-=1
                if (mvalue<0):
                    mvalue=0
                    if (hvalue>0): mvalue=59
                    hvalue-=1
                    if (hvalue<1):
                        hvalue=0

            if ((svalue==0)and(mvalue==0)and(hvalue==0)):
                self.timefinished()
                return False


            self.hours.set_value(str(hvalue))
            self.minutes.set_value(str(mvalue))
            self.seconds.set_value(str(svalue))
        else:
            return False
        return True # run again in one second

    #Run when the timer is finished
    def timefinished(self):
        devstat = osso.DeviceState(self.osso_c)
        devstat.display_state_on()

        note_txt = self.ennote.get_text()
        self.window.present()

        #run the alarm dialog
        alarm_time=long(time.time())
        title='Pyrecipe alarm'
        message=note_txt
        sound="/dev/null"

        try:
            self.alarm_id = osso.alarmd.add_alarm(alarm_time, snooze=1,
                        title=title, message=message, sound=sound)
        except:
            pass
