import hildon
from xml.dom import minidom
import pyrecipe_utils

def show_info_banner(widget, msg):
    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

class GourmetXML:
    def __init__ (self, exp_recipe_list, window, widget):
        rid = 0
        for recipe in range(len(exp_recipe_list)):

            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            imagesrc = exp_recipe_list[recipe][9]

            if recipe == 0:
                xmldocu = self.write_xml(title, instructions, category,
                        ingredients, preptime, cooktime, servings, notes, None,
                        rid, imagesrc)
            else:
                xmldocu = self.write_xml(title, instructions, category,
                        ingredients, preptime, cooktime, servings, notes,
                        xmldocu, rid, imagesrc)

            rid += 1



        if len(exp_recipe_list) > 1:
            title = 'recipes'

        namefile = pyrecipe_utils.show_filechooser_dialog(window, 'save',
                        'Save recipe as ', title, 'Gourmet XML', 'grmt')

        if namefile == None:
            print 'No saving recipe.'
            return

        success = pyrecipe_utils.save_xml_file(namefile, xmldocu)

        if success == True:
            show_info_banner(widget, 'Recipes saved')
        else:
            show_info_banner(widget, 'Error ocurred while exporting the file')

    def write_xml(self, title, instructions, category, ingredients, \
                  preptime, cooktime, servings, notes, xmldocu, rid, image):
        impl = minidom.getDOMImplementation()
        if xmldocu is None:
            xmldocu = impl.createDocument(None, 'gourmetDoc', None)

        id_element = xmldocu.createElement('recipe')
        id_element.setAttributeNS("recipe", "id", str(rid))

        title_element = xmldocu.createElement('title')
        title_element.appendChild(xmldocu.createTextNode(title))

        category_element = xmldocu.createElement('category')
        category_element.appendChild(xmldocu.createTextNode(category))


        img_element = xmldocu.createElement('image')
        img_element.setAttributeNS("pic", "format", "jpg")
        image = "<![CDATA[" + image.replace('"""', '') + "]]>"
        img_element.appendChild(xmldocu.createTextNode(image))


        preptime_element = xmldocu.createElement('preptime')
        preptime_element.appendChild(xmldocu.createTextNode(preptime))

        cooktime_element = xmldocu.createElement('cooktime')
        cooktime_element.appendChild(xmldocu.createTextNode(cooktime))

        servings_element = xmldocu.createElement('servings')
        servings_element.appendChild(xmldocu.createTextNode(servings))

        ing_list_element = xmldocu.createElement('ingredient-list')

        ing_list = pyrecipe_utils.ingredients_to_inglist(ingredients)

        for i in range(len(ing_list)):
            ingredient_element = xmldocu.createElement('ingredient')
            amount_element = xmldocu.createElement('amount')
            amount_element.appendChild(xmldocu.createTextNode(ing_list[i][0]))

            units_element = xmldocu.createElement('unit')
            units_element.appendChild(xmldocu.createTextNode(ing_list[i][1]))

            items_element = xmldocu.createElement('item')
            items_element.appendChild(xmldocu.createTextNode(ing_list[i][2]))

            ingredient_element.appendChild(amount_element)
            ingredient_element.appendChild(units_element)
            ingredient_element.appendChild(items_element)

            ing_list_element.appendChild(ingredient_element)

        instructions_element = xmldocu.createElement('instructions')
        instructions_element.appendChild(xmldocu.createTextNode(instructions))

        notes_element = xmldocu.createElement('modifications')
        notes_element.appendChild(xmldocu.createTextNode(notes))


        id_element.appendChild(title_element)
        id_element.appendChild(category_element)
        id_element.appendChild(img_element)
        id_element.appendChild(preptime_element)
        id_element.appendChild(cooktime_element)
        id_element.appendChild(servings_element)
        id_element.appendChild(ing_list_element)
        id_element.appendChild(instructions_element)
        id_element.appendChild(notes_element)

        xmldocu.documentElement.appendChild(id_element)

        return xmldocu
