#! /usr/bin/env python
# -*- coding: utf-8 -*-

""" This is a Qt Gui file for pyKake. """

APP_TITLE="pyKake"
APP_VERSION="0.7.2"
LOGO = '/opt/pykake/pykake.png'
BUGTRACKER= "http://talk.maemo.org/showthread.php?t=50204"

import sys

""" Crazy hack to instantiate QApplication in PR 1.3 (From DropN900 by Jonne Nauha)."""
from PyQt4.QtGui import QApplication
app = QApplication(sys.argv)

import osso, gst, subprocess
from PyQt4.QtGui import *
from PyQt4.QtCore import *

# Global variables from settings file
CURRENT_REMOTETYPE= ""
TIME2BEEB = "" # Interwall of beebs (if counting up)
USEFULLSCREEN = ""

# Paths to files:
beeb = "file:/opt/pykake/sounds/bell.wav" # Sound file of beeb
alert = "file:/opt/pykake/sounds/drums.wav" # Sound file of alert
styleFile = "/opt/pykake/styles/basicStyle.css" # This is the stylesheet in use

globURI = "" # File to play
bulbStatus = False  # On/Off told if this is first or second time button is hitted in bulb
timedOn = False # Intializing timed mode.
mod2sec = False # Told Canon should it use 2sec delay or not
timeAdded = False # Told that is there time added in Counter or not (used in Bulb and Timed)

# Variables for timer(s)
bulbUser = "" # This identifies the user mode for timer (currently used by Bulb Mode and Timed Mode)
hours = 0 # How many hours has passed/left (only in Timed mode)
minutes = 0 # How many minutes has passed/left 
seconds = 0   # How many seconds has passed/left
timeSeconds = 0 # control timers beeb time (only in bulb)

timedTime = 0 # Maximum time for timed mode, all in seconds (test time 3906 = 1h, 5min, 6 sec)
photoNumber = 0 # Number of photos to take in timed mode.
photosTaken = 0 # Number of photos already taken.
timedBulbTime = 0 # Bulb time for timed mode, given in seconds.
timedPhotoInterval = 10 # Time between photos in timed mode (seconds).

bulbStarted = False
bulbTime = 0

# Public settings:
sizePolicy = QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding) # Size policy fo buttons

class MainWindow(QMainWindow): # Class for main application
	def __init__(self):
		print "Intializing Main..."
		QMainWindow.__init__(self, None)		 # Intializing the main window
		self.mapper = QSignalMapper() # Intializing the Signal mapper for the program
		
		# Collecting settings for app, if this is first run
		print "Check that settings has been set..."
		if CURRENT_REMOTETYPE == "None" or TIME2BEEB == "None":
			self.settingsDialog()
			
		self.resize(800, 480)
		print "Reading style..."
		self.setStyleSheet(MiscFunctions().readFile(styleFile))
		self.setWindowTitle("%s %s" %(APP_TITLE, APP_VERSION))
		
		# Creating menu buttons:
		if USEFULLSCREEN != True:
			print "Creating menu..."
			self.mbSettings = QAction('Settings', self)
			self.mbSettings.setObjectName("menuButton")
			self.connect(self.mbSettings, SIGNAL('triggered()'), self.settingsDialog)
			
			self.mbAbout = QAction('About', self)
			self.connect(self.mbAbout, SIGNAL('triggered()'), self.aboutDialog)
			
			self.mbHelp = QAction('Help', self)
			self.connect(self.mbHelp, SIGNAL('triggered()'), self.helpDialog)
			
			self.mbBugger = QAction('Bugtracker', self)
			self.connect(self.mbBugger, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
			self.mapper.setMapping(self.mbBugger, "bugger")
			
			# Creating menu
			menubar = self.menuBar()
			mitem = menubar.addMenu('File')
			mitem.addAction(self.mbSettings)
			mitem.addAction(self.mbAbout)
			mitem.addAction(self.mbHelp)
			mitem.addAction(self.mbBugger)
		
		# Creating tabs and using tab widget as a Central widget
		print "Creating tabs..."
		self.tabs = QTabWidget()
		self.tabs.TabShape(QTabWidget.Rounded)
		self.tabs.addTab(self.basicMode(), "Basic") # index = 0
		self.tabs.addTab(self.bulbMode(), "Bulb") # index = 1
		self.tabs.addTab(self.timedMode(), "Timed") # index = 2
		self.tabs.addTab(self.viewerMode(), "Viewer") # index = 3
		self.tabs.addTab(self.systemMode(), "System") # index = 4
		
		self.connect(self.tabs, SIGNAL("currentChanged(int)"), self.onPageChange)
		
		self.setCentralWidget(self.tabs)
			
		self.buttonVisibility()
		self.tabVisibility()
		
		self.connect(self.mapper, SIGNAL("mapped(const QString &)"), self.buttonClicked) # Connects signals to functions.
		print "Main ready!"

########## Modes in tabs ##########

	def basicMode(self):
		print "Creating Basic..."
		widget = QWidget()
		hbox = QHBoxLayout()
	
		# Buttons
		shutter = QPushButton("Shutter")
		shutter.setSizePolicy(sizePolicy)
		self.connect(shutter, SIGNAL('clicked()'), self.mapper, SLOT("map()"))
		self.mapper.setMapping(shutter, "shutter") # Gives needed value to signal mapper
		
		self.sec2mod = QPushButton("Activate 2 sec mode")
		self.sec2mod.setCheckable(True)
		self.sec2mod.setSizePolicy(sizePolicy)
		self.connect(self.sec2mod, SIGNAL('clicked()'), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.sec2mod, "mod2sec")
	
		hbox.addWidget(shutter)
		hbox.addWidget(self.sec2mod)
		widget.setLayout(hbox)
		
		print "Basic ready!"
		return widget

	def bulbMode(self):
		print "Creating bulb..."
		widget = QWidget()
		
		hbox = QHBoxLayout()
		
		# Left side, includes only Bulb Button
		self.bulbButton = QPushButton("Bulb On")
		self.bulbButton.setSizePolicy(sizePolicy)
		self.connect(self.bulbButton, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.bulbButton, "bulbButton")
		hbox.addWidget(self.bulbButton)
		
		# Right side, includes Timer label, Add time and activate 2 sec mode button 
		vbox = QVBoxLayout()
		self.timer = QBasicTimer()
		self.timeLabel = QLabel("0:00")
		self.timeLabel.setAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
		self.timeLabel.setSizePolicy(sizePolicy)
		vbox.addWidget(self.timeLabel)
		
		addButton = QPushButton("Add time")
		addButton.setSizePolicy(sizePolicy)
		self.connect(addButton, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(addButton, "addButton")
		vbox.addWidget(addButton)
		
		self.sec2mod2 = QPushButton("Activate 2 sec mode")
		if CURRENT_REMOTETYPE != "CANON-RC1/RC5": # Hides mod2sec button from others than Canon
			self.sec2mod2.hide() 
		self.sec2mod2.setSizePolicy(sizePolicy)
		self.sec2mod2.setCheckable(True)
		self.connect(self.sec2mod2, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.sec2mod2, "mod2sec")
		vbox.addWidget(self.sec2mod2)
		
		hbox.addLayout(vbox, 0)
		widget.setLayout(hbox)
		
		print "Bulb ready!"
		return widget
		
	def timedMode(self):
		print "Creating timed..."
		widget = QWidget()		
		main = QVBoxLayout()
		
		# Photo info:
		grid = QGridLayout()
		main.addLayout(grid, 1)
		
		label = QLabel("Photos:")
		grid.addWidget(label, 1,0)
		self.photoLabel = QLabel("0")
		grid.addWidget(self.photoLabel, 1,1)
		
		# Time info1 (ellapsed time):
		label = QLabel("Time ellapsed:")
		grid.addWidget(label, 1,2)
		self.ellapsedTime = QLabel("0:00:00")
		grid.addWidget(self.ellapsedTime, 1,3)
		
		# Interval between photos:
		label = QLabel("Interval:")
		grid.addWidget(label, 2,0)
		self.photoInter = QLabel ("10 seconds")
		grid.addWidget(self.photoInter, 2,1)
		
		# Time info2 (time left):
		label = QLabel("Time left:")
		grid.addWidget(label, 2,2)
		self.timeLeft = QLabel("0:00:00")
		grid.addWidget(self.timeLeft, 2,3)

		# Buttons	
		self.addPhotos = QPushButton("Add photos")
		self.addPhotos.setSizePolicy(sizePolicy)
		self.connect(self.addPhotos, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.addPhotos, "addPhotos")
		
		self.addTime = QPushButton("Add time")
		self.addTime.setSizePolicy(sizePolicy)
		self.connect(self.addTime, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.addTime, "addTime")
		
		self.photoTime = QPushButton("Add photo interval")
		self.photoTime.setSizePolicy(sizePolicy)
		self.connect(self.photoTime, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.photoTime, "photoTime")

		self.timedBulb = QPushButton("Set bulb")
		self.timedBulb.setSizePolicy(sizePolicy)
		self.connect(self.timedBulb, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.timedBulb, "timedBulb")
		
		self.startButton = QPushButton("Start")
		self.startButton.setSizePolicy(sizePolicy)
		self.connect(self.startButton, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(self.startButton, "startTimer")
		
		# Button grid
		bgrid = QGridLayout()
		main.addLayout(bgrid, 1)
		bgrid.addWidget(self.addPhotos, 1,0)
		bgrid.addWidget(self.addTime, 2,0)
		bgrid.addWidget(self.photoTime, 3,0)
		bgrid.addWidget(self.timedBulb, 1,1)
		bgrid.addWidget(self.startButton, 2,1, 3,1)
		
		widget.setLayout(main)
		
		print "Timed ready!"
		return widget
		
	def viewerMode(self):
		print "Creating viewer..."
		widget = QWidget()
		hbox = QHBoxLayout()
		
		# Zoom buttons
		left = QVBoxLayout()
		
		zoomIn = QPushButton("Zoom in") # QIcon("icons/zoom-in.png"), "Zoom in")
		zoomIn.setSizePolicy(sizePolicy)
		self.connect(zoomIn, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(zoomIn, "zoomin")
		left.addWidget(zoomIn)
		
		zoomOut = QPushButton("Zoom out") # QIcon("icons/zoom-out.png"), "Zoom out")
		zoomOut.setSizePolicy(sizePolicy)
		self.connect(zoomOut, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(zoomOut, "zoomout")
		left.addWidget(zoomOut)
		
		hbox.addLayout(left, 0)
		
		# Movement buttons
		right = QVBoxLayout()
		
		previous = QPushButton("Previous") # QIcon("icons/arrow-left-big.png"), "Previous")
		previous.setSizePolicy(sizePolicy)
		self.connect(previous, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(previous, "previous")
		right.addWidget(previous)
		
		next = QPushButton("Next") # QIcon("icons/arrow-right.png"), "Next")
		next.setSizePolicy(sizePolicy)
		self.connect(next, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(next, "next")
		right.addWidget(next)
		
		hbox.addLayout(right, 0)
		
		widget.setLayout(hbox)
		
		print "Viewer ready!"
		return widget

	def systemMode(self):
		print "Creating system..."
		widget  = QWidget()

		griddy = QGridLayout()
		
		settingsButton = QPushButton("Settings")
		settingsButton.setSizePolicy(sizePolicy)
		self.connect(settingsButton, SIGNAL("clicked()"), self.settingsDialog)
		griddy.addWidget(settingsButton, 1,0)
		
		aboutButton = QPushButton("About")
		aboutButton.setSizePolicy(sizePolicy)
		self.connect(aboutButton, SIGNAL("clicked()"), self.aboutDialog)
		griddy.addWidget(aboutButton, 2,0)
		
		helpButton = QPushButton("Help")
		helpButton.setSizePolicy(sizePolicy)
		self.connect(helpButton, SIGNAL("clicked()"), self.helpDialog)
		griddy.addWidget(helpButton, 3,0)
		
		bugButton = QPushButton("Bugtracker")
		bugButton.setSizePolicy(sizePolicy)
		self.connect(bugButton, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(bugButton, "bugger")
		griddy.addWidget(bugButton, 1,1)
		
		exitButton = QPushButton("Exit")
		exitButton.setSizePolicy(sizePolicy)
		self.connect(exitButton, SIGNAL("clicked()"), self.mapper, SLOT("map()"))
		self.mapper.setMapping(exitButton, "exit")
		griddy.addWidget(exitButton, 2,1, 3,1)
		
		widget.setLayout(griddy)
		
		print "System ready!"
		return widget

######### Timer for Bulb and Timed Modes #########
	def timerEvent(self, event):
		global seconds, minutes, hours, timeSeconds, timeAdded, globURI, beebRun, timerUser, bulbStarted, bulbTime, photosTaken
		
		if timerUser == "bulbMode":
			if timeAdded != True:
				if seconds == 59:
					minutes += 1
					seconds = 0
					timeSeconds +=1
					self.timeLabel.setText("%i:%02i" %(minutes, seconds))
					
				else:
					seconds += 1
					timeSeconds +=1
					self.timeLabel.setText("%i:%02i" %(minutes, seconds))

				if int(TIME2BEEB) != 0:
					if timeSeconds >= 1 and timeSeconds % int(TIME2BEEB) == 0:
						globURI = beeb 
						player().run()
						if timeSeconds >= 600:
							timeSeconds = 0

			else:
				if minutes >0:
					if seconds < 1:
						minutes -=1
						seconds = 59
					else:
						seconds -= 1
				elif seconds > 0:
					seconds -= 1
				else:
					globURI = alert
					player().run()
					self.timer.stop()
					self.buttonClicked("bulbButton")
					timeAdded = False
				self.timeLabel.setText("%i:%02i" %(minutes, seconds))
		
		elif timerUser == "timedMode":

			if seconds == 59:
				minutes += 1
				seconds = 0
				timeSeconds +=1
				self.ellapsedTime.setText("%i:%02i:%02i" %(hours, minutes, seconds))
				if timeAdded == True:
					self.timeLeft.setText(self.countReturner(hours, minutes, seconds))
				
			elif minutes == 60:
				hours += 1
				minutes = 0
				seconds = 0
				timeSeconds +=1
				self.ellapsedTime.setText("%i:%02i:%02i" %(hours, minutes, seconds))
				if timeAdded == True:
					self.timeLeft.setText(self.countReturner(hours, minutes, seconds))

			else:
				seconds += 1
				timeSeconds +=1
				self.ellapsedTime.setText("%i:%02i:%02i" %(hours, minutes, seconds))
				if timeAdded == True:
					text = self.countReturner(hours, minutes, seconds)
					self.timeLeft.setText(text)
			
			if timeSeconds != 0 and timeSeconds%timedPhotoInterval == 0 and bulbStarted == False: # This is will take photos. Except, if bulb timer is still on for previous, in this situation, photo event will be passed.
				
				if bulbStatus != True:
					ButtonFunctions().buttonPressed("shutter")
					photosTaken += 1
					self.updatePhotoInfo()
				
				else: # Using bulb
					bulbStarted = True
					ButtonFunctions().buttonPressed("bulbon")
			
			if bulbStarted == True: # Stopping bulb, when BulbTime is full
				bulbTime +=1 # just counting seconds up
				
				if bulbTime == timedBulbTime: # if bulb time is full, sending quit command
					bulbTime = 0
					bulbStarted = False
					ButtonFunctions().buttonPressed("bulboff")
					photosTaken += 1
					self.updatePhotoInfo()
	
	def updatePhotoInfo(self):
		global globURI
		if photoNumber != 0:
			self.photoLabel.setText("%i / %i" % (photosTaken, photoNumber))
			if photoNumber == photosTaken:
				self.timeLeft.setText("Session ready!")
				self.startButton.setText("Clear")
				globURI = alert
				player().run()
				self.timer.stop()
		else:
			self.photoLabel.setText("%i" %photosTaken)

	def countReturner(self, h, m, s):
		global timedTime, globURI
		ellapsed = (h*60*60)+(m*60)+s # (transferring hours and minutes to seconds and counting all together to get ellapsed time in seconds)
		current = timedTime-ellapsed # get the current time left
		
		if current > 0:
			s = current%60 # Getting the seconds out
			current = current/60 # transferring seconds to minutes
			m = current%60 # getting the minutes out
			h = current/60 # getting the hour
			string = "%i:%02i:%02i" % (h, m ,s) # Creating the string
		
		elif current <= 0 and bulbStarted != True: # End the session, if time is up and bulb is not in use.
			string = "Session ready!"
			self.startButton.setText("Clear")
			globURI = alert
			player().run()
						
			self.timer.stop()
			
		elif current <= 0 and bulbStarted == True: # If bulb is use, wait till it ends and ends the session ^
			string = "Waiting bulb..."
		
		return string # returning the string

############# Time selection dialogs #############
	def addTimeDialog(self):
		self.checker = self.tabs.currentIndex() # Using the index of current tab to select correct layouts and return functions

		self.dial = QDialog()
		self.dial.setWindowTitle("Add time")
		mainBox = QHBoxLayout()
		
		hbox = QHBoxLayout()
		
		if self.checker == 2: # If used from timed mode, adds hour box
			self.hourBox = QComboBox()
			self.hourDict = {}
			for i in range(25):
				self.hourDict["%s hour" %i] = int(i)
				self.hourBox.addItem("%s hour" %i)
			hbox.addWidget(self.hourBox)
				
		self.minBox = QComboBox()
		self.minDict = {}
		for i in range(61):
			if self.checker == 2 and i == 60: # In timed mode, we only need 59 minutes, not 60 or more.
				break
			self.minDict["%s min" %i] = int(i)
			self.minBox.addItem("%s min" %i)
		hbox.addWidget(self.minBox)
		
		self.secBox = QComboBox()
		self.secDict = {}
		for i in range(60):
			self.secDict["%s sec" %i] = int(i)
			self.secBox.addItem("%s sec" %i)
		hbox.addWidget(self.secBox)
		
		mainBox.addLayout(hbox, 0)
		
		buttonBox = QDialogButtonBox(Qt.Vertical)
		button1 = QDialogButtonBox.Save
		button2 = QDialogButtonBox.Cancel
		buttonBox.addButton(button1)
		buttonBox.addButton(button2)

		buttonBox.accepted.connect(self.dialGetTime)
			
		buttonBox.rejected.connect(self.dial.reject)
		
		mainBox.addWidget(buttonBox)
		
		self.dial.setLayout(mainBox)
		self.dial.exec_()
		
	def dialGetTime(self):
		global minutes, seconds, timeAdded, timedTime
		
		if self.checker == 2: # Get the hours if using timed
			hours = self.hourDict[str(self.hourBox.currentText())]
		
		mins = self.minDict[str(self.minBox.currentText())]
		secs = self.secDict[str(self.secBox.currentText())]
		
		if mins+secs > 0 and self.checker != 2: #easy way to check that there is something selected + check that this is for bulb, not for timed
			minutes = mins
			seconds = secs
			timeAdded = True
			self.timeLabel.setText("%i:%02i" %(minutes, seconds))
			
		elif hours+mins+secs > 0 and self.checker == 2:
			timedTime = (hours*60*60)+(mins*60)+secs
			self.timeLeft.setText("%i:%02i:%02i" %(hours, mins, secs))
			timeAdded = True
		else:
			print "No time selected, or error with time handling"
			
		self.dial.accept()

############# Photo selection dialog #############
	def addPhotosDialog(self):
		self.dial = QDialog()
		self.dial.setWindowTitle("Give the number of photos")
		mainBox = QHBoxLayout()
		
		vbox = QVBoxLayout()
		
		self.slider = QSlider(Qt.Horizontal)
		self.slider.setRange(0, 1000)
		vbox.addWidget(self.slider)
		self.connect(self.slider, SIGNAL('valueChanged(int)'), self.changeSpinValue)
		self.spin = QSpinBox()
		self.connect(self.spin, SIGNAL('valueChanged(int)'), self.changeSliderValue)
		self.spin.setRange(0, 1000)
		vbox.addWidget(self.spin)
			
		mainBox.addLayout(vbox, 0)

		buttonBox = QDialogButtonBox(Qt.Vertical)
		button1 = QDialogButtonBox.Save
		button2 = QDialogButtonBox.Cancel
		buttonBox.addButton(button1)
		buttonBox.addButton(button2)

		buttonBox.accepted.connect(self.getPhotoNumb)
			
		buttonBox.rejected.connect(self.dial.reject)
		
		mainBox.addWidget(buttonBox)
		
		self.dial.setLayout(mainBox)
		self.dial.exec_()

	def getPhotoNumb(self):
		global photoNumber
		value = self.slider.value()
		photoNumber = value
		self.updatePhotoInfo()
		self.dial.accept()
		
	def changeSpinValue(self):
		value = self.slider.value()
		self.spin.setValue(value)

	def changeSliderValue(self):
		value = self.spin.value()
		self.slider.setValue(value)

############### Bulb selector ###################
	def bulbSelectDialog(self):
		self.dial = QDialog()
		self.dial.setWindowTitle("Give the time for bulb")
		mainBox = QHBoxLayout()
		
		hbox = QHBoxLayout()
		self.minBox = QComboBox()
		self.minDict = {}
		for i in range(61):
			self.minDict["%s min" %i] = int(i)
			self.minBox.addItem("%s min" %i)
		hbox.addWidget(self.minBox)
		
		self.secBox = QComboBox()
		self.secDict = {}
		for i in range(60):
			self.secDict["%s sec" %i] = int(i)
			self.secBox.addItem("%s sec" %i)
		hbox.addWidget(self.secBox)

		mainBox.addLayout(hbox, 0)

		buttonBox = QDialogButtonBox(Qt.Vertical)
		button1 = QDialogButtonBox.Save
		button2 = QDialogButtonBox.Cancel
		buttonBox.addButton(button1)
		buttonBox.addButton(button2)

		buttonBox.accepted.connect(self.getBulbTime)
			
		buttonBox.rejected.connect(self.dial.reject)
		
		mainBox.addWidget(buttonBox)
		
		self.dial.setLayout(mainBox)
		self.dial.exec_()
	
	def getBulbTime(self):
		global timedBulbTime, bulbStatus
		mins = self.minDict[str(self.minBox.currentText())]
		secs = self.secDict[str(self.secBox.currentText())]
		
		if mins+secs > 0: 
			timedBulbTime = mins*60+secs
			bulbStatus = True
			self.timedBulb.setText("Bulbtime: %i min %i sec\nPress to unset bulb" % (mins, secs))
			print "Bulb on, bulb time: ", timedBulbTime
			self.dial.accept()
		else:
			self.timedBulb.setText("Set bulb")
			print "No time selected"
			self.dial.reject()
		
##### Photo time interval selector #####	
	def addIntervalDialog(self):
		self.dial = QDialog()
		self.dial.setWindowTitle("Add time between photos")
		mainBox = QHBoxLayout()
		
		hbox = QHBoxLayout()

		self.hourBox = QComboBox()
		self.hourDict = {}
		for i in range(24):
			self.hourDict["%s hour" %i] = int(i)
			self.hourBox.addItem("%s hour" %i)
		hbox.addWidget(self.hourBox)
				
		self.minBox = QComboBox()
		self.minDict = {}
		for i in range(60):
			self.minDict["%s min" %i] = int(i)
			self.minBox.addItem("%s min" %i)
		hbox.addWidget(self.minBox)
		
		self.secBox = QComboBox()
		self.secDict = {}
		for i in range(60):
			self.secDict["%s sec" %i] = int(i)
			self.secBox.addItem("%s sec" %i)
		hbox.addWidget(self.secBox)
		
		mainBox.addLayout(hbox, 0)
		
		buttonBox = QDialogButtonBox(Qt.Vertical)
		button1 = QDialogButtonBox.Save
		button2 = QDialogButtonBox.Cancel
		buttonBox.addButton(button1)
		buttonBox.addButton(button2)

		buttonBox.accepted.connect(self.dialGetInterval)
			
		buttonBox.rejected.connect(self.dial.reject)
		
		mainBox.addWidget(buttonBox)
		
		self.dial.setLayout(mainBox)
		self.dial.exec_()
		
	def dialGetInterval(self):
		global timedPhotoInterval

		hours = self.hourDict[str(self.hourBox.currentText())]
		mins = self.minDict[str(self.minBox.currentText())]
		secs = self.secDict[str(self.secBox.currentText())]
		
		if hours+mins+secs > 0:
			timedPhotoInterval = (hours*60*60)+(mins*60)+secs
			if hours > 0:
				self.photoInter.setText("%i h %i min %i sec" %(hours, mins, secs))
			elif mins > 0:
				self.photoInter.setText("%i min %i sec" %(mins, secs))
			else:
				self.photoInter.setText("%i seconds" %secs)
		else:
			print "No time selected, or error with time handling"
			
		self.dial.accept()

	def onPageChange(self): # Function to clean up the variables (and renaming few buttons and fields in Bulb and timing mode)
		global timeAdded, bulbUser, hours, minutes, seconds, timeSeconds, timedTime, photoNumber, photosTaken, timedBulbTime, bulbStarted, bulbTime
		# Cleaning global variables
		timeAdded = False
		bulbUser = ""
		hours = 0
		minutes = 0 
		seconds = 0
		timeSeconds = 0
		timedTime = 0
		photoNumber = 0
		photosTaken = 0
		timedBulbTime = 0
		bulbStarted = False
		bulbTime = 0
		
		# Renaming buttons and fields
		self.photoLabel.setText("0")
		self.timeLeft.setText("0:00:00")
		self.timedBulb.setText("Set bulb")
		self.timeLabel.setText("0:00")
			
####### Button clicks connector ########
	def buttonClicked(self, string): # Button functions, and resendings.
		global bulbStatus, mod2sec, minutes, seconds, timerUser, timeAdded, timedOn, timeSeconds, photosTaken, photoNumber
		
		if string == "mod2sec": 
			if self.sec2mod.isChecked() and mod2sec != True:
				mod2sec = True
				self.sec2mod.setText("Dectivate 2 sec mode")
				self.sec2mod2.setText("Dectivate 2 sec mode")
				self.sec2mod2.toggle()
			elif self.sec2mod2.isChecked() and mod2sec != True:
				mod2sec = True
				self.sec2mod2.setText("Dectivate 2 sec mode")
				self.sec2mod.setText("Dectivate 2 sec mode")
				self.sec2mod.toggle()
			else: 
				self.sec2mod.setText("Activate 2 sec mode")
				self.sec2mod.setChecked(False)
				self.sec2mod2.setText("Activate 2 sec mode")
				self.sec2mod2.setChecked(False)
				mod2sec = False
		
		# basicMode
		elif string == "shutter":
			ButtonFunctions().buttonPressed("shutter")	
		
		# bulbMode
		elif string == "bulbButton":		
			if bulbStatus == False:
				timerUser = "bulbMode"
				self.tabEnabler(False)
				self.bulbButton.setText("Bulb Off")
				data = "bulbon"
				self.timer.start(1000, self)
				bulbStatus = True
			elif string == "bulbButton" and bulbStatus == True:
				self.tabEnabler(True)
				self.bulbButton.setText("Bulb On")
				data = "bulboff"
				self.timer.stop()
				timeAdded = False
				minutes = 0
				seconds = 0
				self.timeLabel.setText("0:00")
				timerUser = ""
				bulbStatus = False
			else:
				print "Something wrong in bulbButton."
			ButtonFunctions().buttonPressed(data)
		
		elif string == "addButton":
			self.dialog = self.addTimeDialog()
				
		# timedMode
		elif string == "startTimer" and timedOn == False:
			
			""" painikkeet pois painokelvottomiksi """
			self.addPhotos.setEnabled(False)
			self.addTime.setEnabled(False)
			self.photoTime.setEnabled(False)
			self.timedBulb.setEnabled(False)
			self.tabEnabler(False)

			
			self.startButton.setText("Stop")
			timerUser = "timedMode"
			self.timer.start(1000, self)
			timedOn = True
		
		elif string == "startTimer" and timedOn == True:
			self.timer.stop()
			
			photosTaken = 0
			photoNumber = 0
			minutes = 0
			seconds = 0
			timeSeconds = 0
			timedTime = 0
			timeAdded = False
			timedOn = False
			
			self.updatePhotoInfo()
			self.ellapsedTime.setText("0:00:00")
			self.timeLeft.setText("0:00:00") 
			self.startButton.setText("Start")
			
			self.addPhotos.setEnabled(True)
			self.addTime.setEnabled(True)
			self.photoTime.setEnabled(True)
			self.timedBulb.setEnabled(True)
			self.tabEnabler(True)
			
		elif string == "addTime":
			self.addTimeDialog()
		elif string == "addPhotos":
			self.addPhotosDialog()
		elif string == "photoTime":
			self.addIntervalDialog()
		
		elif string == "timedBulb":
			if bulbStatus == False:
				self.bulbSelectDialog()
			else:
				self.timedBulb.setText("Set bulb")
				bulbStatus = False
				
		# viewerMode
		elif string == "zoomin" or string == "zoomout" or string == "next" or string == "previous":
			ButtonFunctions().buttonPressed(str(string))
		
		# systemMode (bugger & exit)
		elif string == "bugger":
			self.osso_context = osso.Context("org.maemo.pykake", APP_VERSION, False)
			self.osso_rpc = osso.Rpc(self.osso_context)
			self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (BUGTRACKER,))

		elif string == "exit":
			MiscFunctions().exitFunction()
		else: # Failsafe, something wrong in buttons!
			print "Something wrong in buttons"

	def tabEnabler(self, val): # Enabling/disabling tabs in timed and bulb mode (when process is on, tabs can't be changed).
		print "Handling tab enbality..."
		for i in range(self.tabs.count()):
			if i != self.tabs.currentIndex():
				self.tabs.setTabEnabled(i, val)

####### Visibility handling #######

	def buttonVisibility(self): # Button visibility, currently only sec2mod & sec2mod2 for canon
		print "Setting button visibility..."
		if CURRENT_REMOTETYPE != "CANON-RC1/RC5":
			self.sec2mod.hide()
			self.sec2mod2.hide()
		else:
			self.sec2mod.show()
			self.sec2mod2.show()

	def tabVisibility(self):
		print "Setting tab visibility..."
		count = self.tabs.count() # Number of tabs, used for failsafe!
		if USEFULLSCREEN != True and count == 5: # Removing systemMode if not fullscreen
			self.tabs.removeTab(count-1)
		
		if CURRENT_REMOTETYPE == "Olympus_RM-1" and USEFULLSCREEN == True and count < 5: # Includes Viewer tab, only if it is not there!
			self.tabs.removeTab((count-1))
			self.tabs.addTab(self.viewerMode(), "Viewer")
			self.tabs.addTab(self.systemMode(), "System")
		
		elif CURRENT_REMOTETYPE == "Olympus_RM-1" and USEFULLSCREEN != True and count == 3: # Includes Viewer tab, only if it is not there!
			self.tabs.addTab(self.viewerMode(), "Viewer")
		
		elif CURRENT_REMOTETYPE != "Olympus_RM-1" and count == 5:
			self.tabs.removeTab(3)

		
######### Settings dialog #########
	def settingsDialog(self):
		self.dialog = QDialog()
		mainBox = QHBoxLayout()
		self.dialog.setWindowTitle("Settings")
		
		vboxy = QVBoxLayout()
		
		mainBox.addLayout(vboxy, 1)
		widget = QWidget()
		vbox = QVBoxLayout()
		
		area = QScrollArea()
		area.setWidgetResizable(True)
		area.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding)
		
		widget.setLayout(vbox)
		area.setWidget(widget)
		vboxy.addWidget(area)
		
		# Cameras:
		label = QLabel("Select camera:")
		vbox.addWidget(label)
		
		self.cameraGroup = QButtonGroup()
		cbox = QVBoxLayout()
		hbox = QHBoxLayout()
		
		canon = QRadioButton("Canon")
		self.cameraGroup.addButton(canon)
		hbox.addWidget(canon)
		
		nikon = QRadioButton("Nikon")
		self.cameraGroup.addButton(nikon)
		hbox.addWidget(nikon)
		
		olympus = QRadioButton("Olympus")
		self.cameraGroup.addButton(olympus)
		hbox.addWidget(olympus)
		cbox.addLayout(hbox,1)
		
		pentax = QRadioButton("Pentax and Samsung")
		self.cameraGroup.addButton(pentax)
		cbox.addWidget(pentax)
		
		# Activating current camera + failsafe to canon
		if CURRENT_REMOTETYPE == "CANON-RC1/RC5": canon.toggle()
		elif CURRENT_REMOTETYPE == "NikonDSLR": nikon.toggle()
		elif CURRENT_REMOTETYPE == "Olympus_RM-1": olympus.toggle()
		elif CURRENT_REMOTETYPE == "Pentax_RC-F": pentax.toggle()
		else: canon.toggle()
		
		vbox.addLayout(cbox, 0)		
		
		# /Cameras	
		# Beeb interval
		label = QLabel("Select beeb interval:")
		vbox.addWidget(label)
		
		self.beebGroup = QButtonGroup()
		hbox = QHBoxLayout()
		
		t30sec = QRadioButton("30 Sec")
		self.beebGroup.addButton(t30sec)
		hbox.addWidget(t30sec)
		
		t1min = QRadioButton("1 Min")
		self.beebGroup.addButton(t1min)
		hbox.addWidget(t1min)
		
		t10min = QRadioButton("10 Min")
		self.beebGroup.addButton(t10min)
		hbox.addWidget(t10min)
		
		tOff = QRadioButton("Off")
		self.beebGroup.addButton(tOff)
		hbox.addWidget(tOff)
		
		vbox.addLayout(hbox, 1)
		
		if TIME2BEEB == "30": t30sec.toggle()
		elif TIME2BEEB == "60": t1min.toggle()
		elif TIME2BEEB == "600": t10min.toggle()
		elif TIME2BEEB == "0": tOff.toggle()
		else: tOff.toggle()
		
		self.fullscreenSelect = QCheckBox("Use Fullscreen mode\nNeeds restart to get active")
		if USEFULLSCREEN == True: self.fullscreenSelect.setChecked(True)
		vbox.addWidget(self.fullscreenSelect)
		
		buttonBox = QDialogButtonBox(Qt.Vertical)
		button1 = QDialogButtonBox.Save
		button2 = QDialogButtonBox.Cancel
		buttonBox.addButton(button1)
		buttonBox.addButton(button2)
		
		buttonBox.accepted.connect(self.setSettings)
		buttonBox.rejected.connect(self.dialog.reject)
		
		mainBox.addWidget(buttonBox)
		
		self.dialog.setLayout(mainBox)
		
		print "Running settings dialog..."
		self.dialog.exec_()
		
	def setSettings(self):
		print "Save settings..."
		global CURRENT_REMOTETYPE, TIME2BEEB, USEFULLSCREEN
		settings = QSettings("pyKake", "pyKake")
		
		cam = self.cameraGroup.checkedButton()
		if  cam.text() == "Canon": remote = "CANON-RC1/RC5"
		elif cam.text() == "Nikon": remote = "NikonDSLR"
		elif cam.text() == "Olympus": remote = "Olympus_RM-1"
		elif cam.text() == "Pentax and Samsung": remote = "Pentax_RC-F"
		settings.setValue("settings/camera", remote)
		CURRENT_REMOTETYPE = remote
		
		timed = self.beebGroup.checkedButton()
		
		if timed.text() == "30 Sec": addedTime = "30"
		elif timed.text() == "1 Min": addedTime = "60"
		elif timed.text() == "10 Min": addedTime = "600"
		elif timed.text() == "Off": addedTime = "0"
		settings.setValue("settings/beebtime", addedTime)
		TIME2BEEB = addedTime
		
		if self.fullscreenSelect.isChecked(): settings.setValue("settings/fullscreen", True)
		else: settings.setValue("settings/fullscreen", False)
		
		settings.sync()
		
		self.buttonVisibility() # Hiding showing mod2sec buttons for canon
		self.tabVisibility() # Handling visibility of tabs
		
		print "Settings saved."
		self.dialog.accept()

########## Other dialogs ##########
	def aboutDialog(self):
		dialog = QDialog()
		dialog.setWindowTitle("About %s %s" %(APP_TITLE, APP_VERSION))
		mainbox = QVBoxLayout()
		
		tabby = QTabWidget()
		
		# Info tab
		area1 = QScrollArea()
		area1.setWidgetResizable(True)
		area1.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding)
		
		info = QWidget()
		vbox = QVBoxLayout()
		img = QPixmap(LOGO)
		icon = QLabel(self)
		icon.setPixmap(img)
		icon.setAlignment(Qt.AlignHCenter)
		vbox.addWidget(icon)
		
		text = QLabel("<div  align=\"center\"><h3>%s %s</h3><b><p>All logos and trademarks are property<br/>of their respective owners and are used<br/>for informational purposes only.</p></b><i>Copyright 2010 &copy; Janne Pekkala</i></div>" %(APP_TITLE, APP_VERSION))
		vbox.addWidget(text)
		info.setLayout(vbox)
		area1.setWidget(info)
		tabby.addTab(area1, "Info")
		
		# Developers tab
		devs = QWidget()
		vbox = QVBoxLayout()
		text = "<h3>Programming:</h3> Janne Pekkala <yabbapappa@gmail.com> <h3>Graphics:</h3> <b>Program icon:</b> Tomi Taipaleenm&auml;ki <br/>" # <b>Other icons:</b> From Open Icon Library <http://openiconlibrary.sourceforge.net/>"
		label = QLabel(text)
		vbox.addWidget(label)
		devs.setLayout(vbox)
		tabby.addTab(devs, "Developers")
		
		# License tab

		area2 = QScrollArea()
		area2.setWidgetResizable(True)
		area2.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding)
		
		lic = QWidget()
		vbox = QVBoxLayout()
		txt = MiscFunctions().readFile("/opt/pykake/files/license.html")
		label = QLabel(txt)
		label.setWordWrap(True)
		vbox.addWidget(label)
		lic.setLayout(vbox)
		area2.setWidget(lic)
		tabby.addTab(area2, "License")
		
		mainbox.addWidget(tabby)
				
		dialog.setLayout(mainbox)
		
		print "Running about dialog..."
		dialog.exec_()

	def helpDialog(self):
		dialog = QDialog()
		dialog.setWindowTitle("Help")
		mainbox = QVBoxLayout()
		
		tabby = QTabWidget()
		
		# Help: pyKake How-To!
		area1 = QScrollArea()
		area1.setWidgetResizable(True)
		area1.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding)
		
		settings = QWidget()
		vbox = QVBoxLayout()
		txt = MiscFunctions().readFile("/opt/pykake/files/help.html")
		label = QLabel(txt)
		label.setWordWrap(True)
		vbox.addWidget(label)
		settings.setLayout(vbox)
		area1.setWidget(settings)
		tabby.addTab(area1, "pyKake How-To")
	
		# Help: Supported cameras
		area2 = QScrollArea()
		area2.setWidgetResizable(True)
		area2.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding)
		
		supCams = QWidget()
		vbox = QVBoxLayout()
		txt = MiscFunctions().readFile("/opt/pykake/files/supported.html")
		label = QLabel(txt)
		label.setWordWrap(True)
		vbox.addWidget(label)
		supCams.setLayout(vbox)
		area2.setWidget(supCams)
		tabby.addTab(area2, "Supported cameras")
		
		mainbox.addWidget(tabby)
		dialog.setLayout(mainbox)
		
		print "Running help dialog..."
		dialog.exec_()
		
############ Other classes ############
class ButtonFunctions:
	   def buttonPressed(self, data): # Function for shutter commands button.
		if CURRENT_REMOTETYPE == "Olympus_RM-1": digitalCamera().olympus(data)
		elif CURRENT_REMOTETYPE == "CANON-RC1/RC5": digitalCamera().canon()
		elif CURRENT_REMOTETYPE == "Pentax_RC-F": digitalCamera().pentax(data)
		else: digitalCamera().oneButtonRemotes(CURRENT_REMOTETYPE)	
			
class MiscFunctions:
	def controlLircd(self, cmd): # Starting and stoping lirc
		arg = ["sudo","/etc/init.d/lirc", cmd]
		lircing = subprocess.Popen(arg, stdout=subprocess.PIPE)
		output = lircing.stdout.readline()
		print "Lirc output: %s" %output
		lircing.wait()

	def readQSettings(self, path, default): # Reading QSettings
		print "Reading QSettings..."
		settings = QSettings("pyKake", "pyKake")
		value = settings.value(path, default) # path == location of the value | default == default value (failback)
		return value
	
	def exitFunction(self): # Exiting the application
		print "Exit..."
		MiscFunctions().controlLircd("stop")
		print "Bye Bye!"
		sys.exit()
	
	def readFile(self, fileName):
		print "Reading file..."
		file = QFile(fileName)
		
		if not file.open(QFile.ReadOnly | QFile.Text):
			print "Problems while loading file."
		
		data = QTextStream(file)
		text = data.readAll()
		return text

	def loadSettings(self): # Reloading settings from conf file at /home/user/.config/pyKake/pyKake.conf
		print "Settingsloader..."
		global CURRENT_REMOTETYPE, TIME2BEEB, USEFULLSCREEN
		CURRENT_REMOTETYPE = QVariant(self.readQSettings("settings/camera", "None")).toString()
		TIME2BEEB = QVariant(self.readQSettings("settings/beebtime", "None")).toString()
		USEFULLSCREEN = QVariant(self.readQSettings("settings/fullscreen", True)).toBool()
		 
class player (QThread):
	def run(self):
		print "a"
		QThread.__init__(self)
		print "b"
		global beebRun
		print "c"
		player = gst.element_factory_make("playbin","player")
		print "d"
		player.set_property('uri', globURI)
		print "e"
		player.set_state(gst.STATE_PLAYING)
		print "done"
				
class digitalCamera: # This is class where commands from GUI are translated ready to be send to camera
	def olympus(self,rawdata):
		comDict = {"shutter":"capture" , "bulbon":"W" , "bulboff":"T" , "zoomin":"T" , "zoomout":"W" , "previous":"-" , "next":"+"}
		cmd = comDict[rawdata]
		self.remote(cmd)

	def canon(self):
		# global mod2sec
		if mod2sec == True:
			cmd = "2S"
		else:
			cmd = "S"
		self.remote(cmd)

	def pentax(self, data):
		if data == "bulbon":
			""" Sending start command in bulb mode """
			self.bulbPatchPentax("start")
		elif data == "bulboff":
			""" Sending stop command in bulb mode """
			self.bulbPatchPentax("stop")
		else:
			""" Sending normal shutter command. """
			cmd = "Capture"
			self.remote(cmd)

	def oneButtonRemotes(self, remote):
		if remote == "NikonDSLR":
			cmd = "shutter"
		else:
			print "There is no camera selected"
			cmd = "ShutterError"
		self.remote(cmd)

	# COMMANDING INFRA RED
	def remote(self, code):
		print "Shooting..."
		remote = CURRENT_REMOTETYPE
		arg = ["/usr/bin/irsend", "send_once", remote, code]
		shoot = subprocess.Popen (arg, stdin = subprocess.PIPE, stdout = subprocess.PIPE)
		output = shoot.stdout.readline()
		shoot.stdin.close()
		if output != "":
			print "irsend error: %s" %output
		shoot.wait()

	def bulbPatchPentax(self, state):
		print "Shooting Pentax"
		remote = CURRENT_REMOTETYPE
		code = "Capture"
		if state == "start":
			directive = "send_start"
		elif state == "stop":
			directive = "send_stop"
		else:
			directive = "send_once"
		arg = ["/usr/bin/irsend", directive, remote, code]
		shoot = subprocess.Popen (arg, stdin = subprocess.PIPE, stdout = subprocess.PIPE)
		output = shoot.stdout.readline()
		shoot.stdin.close()
		if output != "":
			print "irsend error: %s" %output
		shoot.wait()

	################################################################################################


####### Running the Application #######

#app = QApplication(sys.argv) # Currently out of use (since v. 0.7.1), because Pr 1.3 causing problems at the moment (2.11.2010).
print "Loading settings..."
MiscFunctions().loadSettings()
print "Starting Lirc..."
MiscFunctions().controlLircd("start")

print "Calling Main window..."
main = MainWindow()

if USEFULLSCREEN == True:
	print "Showing window: Fullscreen"
	main.showFullScreen()
else:
	print "Showing window: Normal"
	main.show()


print "Executing the app..."
app.exec_()
MiscFunctions().exitFunction()
