#! /usr/bin/env python
#! coding=utf-8

APP_TITLE="pyKake"
APP_VERSION="0.5.0"
CONFPATH = "/apps/Maemo/%s/" % APP_TITLE.lower()

import gtk
import hildon
import subprocess
import gobject
import time
import gconf
import gst
import threading
import pango

# Global variables
CURRENT_REMOTETYPE= ""
TIME2BEEB = "" # Interwall of beebs (if counting up)
beeb = "/opt/pykake/sounds/bell.wav" # Sound file of beeb
alert = "/opt/pykake/sounds/drums.wav" # Sound file of alert

bulbStatus = False  # On/Off told is this first or second time button hitted in bulb
mod2sec = False # Told Canon (in bulbmode) should it use 2sec delay or not
timeAdded = False # Told that is there time added in Counter or not
minutes = 0 # How many minutes user wants to keep shutter open in bulb
seconds = 0.0   # If need some Seconds more in bulb mode :p
timeSeconds = 0.0 # control timers beeb time
globURI = "" # File to play
beebRun = False # Duck tape solution
gobjid = 0

# Layouting
fontLabel = pango.FontDescription("Sans 20")
fontButt = pango.FontDescription("Sans Bold 25")
fontTimer = pango.FontDescription("Monotype Bold 35")

class pykakeGui:
    def __init__(self):
	 global CURRENT_REMOTETYPE, TIME2BEEB
	 miscFuncs().controlLircd("start") # Start Lirc in start-up
	 # Loading needed info from gconf
	 CURRENT_REMOTETYPE = miscFuncs().confReader("remote")
	 TIME2BEEB = miscFuncs().confReader("beebtime")
	 self.mainWindow()
	 if not CURRENT_REMOTETYPE and not TIME2BEEB: # Opening settings dialog, if first start
	    self.settingsDialog("open")

    # WINDOWS
    def mainWindow(self):  # Window to select between modes
	 program = hildon.Program.get_instance()
	 win = hildon.StackableWindow()
	 win.set_title("%s v.%s" % (APP_TITLE, APP_VERSION))
	 win.connect('destroy', self.destroy)
	 win.set_border_width(0)
	 menu = self.mainMenu()
	 win.set_app_menu(menu)
	 vbox = gtk.VBox(False, 0)
	 win.add(vbox)
	 label = gtk.Label("Select mode:")
	 label.modify_font(fontLabel)
	 vbox.pack_start(label, False, True, 0)
	 hbox = gtk.HBox(False, 10)
	 vbox.pack_start(hbox, True, True, 0)
	 self.butt1 = gtk.Button("Basic")
	 self.butt1.child.modify_font(fontButt)
	 self.butt1.connect('clicked', self.singleShot, None)
	 hbox.pack_start(self.butt1, True, True, 0)
	 self.butt2 = gtk.Button("Bulb")
	 self.butt2.child.modify_font(fontButt)
	 self.butt2.connect('clicked', self.bulbMode, None)
	 hbox.pack_start(self.butt2, True, True, 0)
	 self.butt3 = gtk.Button("Viewer")
	 self.butt3.child.modify_font(fontButt)
	 self.butt3.connect('clicked', self.viewerMode, None)
	 vbox.pack_start(self.butt3, True, True, 0)
	 win.show_all()
	 self.buttControl()

    def singleShot(self, widget, data): # Mode to just take photos
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" %(APP_TITLE, APP_VERSION))
	win.connect('delete_event', self.deleteChild, "single")
	win.set_border_width(0)
	menu=self.mainMenu()
	win.set_app_menu(menu)
	vbox = gtk.VBox(False, 0)
	win.add(vbox)
	label = gtk.Label("Single shoot mode")
	label.modify_font(fontLabel)
	vbox.pack_start(label, False, True, 0)
	hbox = gtk.HBox(True, 0)
	vbox.pack_start(hbox, True, True, 0)
	self.butt4 = gtk.Button("Shutter")
	self.butt4.child.modify_font(fontButt)
	self.butt4.connect('clicked', self.buttonClicked, "shutter")
	hbox.pack_start(self.butt4, True, True, 0)
	self.buttMod2sec = gtk.Button("Activate 2sec mode")
	self.buttMod2sec.child.modify_font(fontButt)
	self.buttMod2sec.connect('clicked', self.mode2sec,"5")
	hbox.pack_start(self.buttMod2sec, True, True, 0)
	win.show_all()
	self.buttControl()

    def bulbMode(self, widget, data): # Mode to use bulb
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" %(APP_TITLE, APP_VERSION))
	win.connect('delete_event', self.deleteChild, "bulb")
	win.set_border_width(0)
	menu=self.mainMenu()
	win.set_app_menu(menu)
	vbox1 = gtk.VBox(False, 0)
	win.add(vbox1)
	label = gtk.Label("Bulb mode:")
	label.modify_font(fontLabel)
	vbox1.pack_start(label, False, True, 0)
	hbox = gtk.HBox(False, 0)
	vbox1.pack_start(hbox, True, True, 0)
	self.buttBulb = gtk.Button("Bulb On")
	self.buttBulb.child.modify_font(fontButt)
	self.buttBulb.connect('clicked', self.buttonClicked, "bulb")
	hbox.pack_start(self.buttBulb, True, True, 0)
	vbox2 = gtk.VBox(True, 0)
	hbox.pack_start(vbox2, True, True, 0)
	aspFrame = gtk.AspectFrame()
	self.timerLabel = gtk.Label("0:00")
	self.timerLabel.modify_font(fontTimer)
	self.timerLabel.set_padding(10, 5)
	aspFrame.add(self.timerLabel)
	vbox2.pack_start(aspFrame, True, True, 0)
	self.butt7 = gtk.Button("Add time")
	self.butt7.child.modify_font(fontButt)
	self.butt7.connect('clicked', self.timerDialog, win)
	vbox2.pack_start(self.butt7, True, True, 0)
	self.buttMod2sec = gtk.Button("Activate 2sec mode")
	self.buttMod2sec.child.modify_font(fontButt)
	self.buttMod2sec.connect('clicked', self.mode2sec, "8")
	vbox2.pack_start(self.buttMod2sec, True, True, 0)
	win.show_all()
	self.buttControl()

    def viewerMode(self,widget,data): # Mode to show photos remotely
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" %(APP_TITLE, APP_VERSION))
	win.connect('delete_event', self.deleteChild, "viewer")
	win.set_border_width(0)
	menu = self.mainMenu()
	win.set_app_menu(menu)
	vbox = gtk.VBox(False, 0)
	win.add(vbox)
	label = gtk.Label("Viewer mode")
	label.modify_font(fontLabel)
	vbox.pack_start(label, False, True, 0)
	hbox1 = gtk.HBox(True, 0)
	vbox.pack_start(hbox1, True, True, 0)
	hbox2 = gtk.HBox(True, 0)
	vbox.pack_start(hbox2, True, True, 0)
	self.butt9 = gtk.Button("Zoom In")
	self.butt9.child.modify_font(fontButt)
	self.butt9.connect('clicked',self.buttonClicked, "zoomin")
	hbox1.pack_start(self.butt9, True, True, 0)
	self.butt10 = gtk.Button("Zoom Out")
	self.butt10.child.modify_font(fontButt)
	self.butt10.connect('clicked',self.buttonClicked, "zoomout")
	hbox2.pack_start(self.butt10, True, True, 0)
	self.butt11 = gtk.Button("Previous")
	self.butt11.child.modify_font(fontButt)
	self.butt11.connect('clicked', self.buttonClicked, "previous")
	hbox1.pack_start(self.butt11, True, True, 0)
	self.butt12 = gtk.Button("Next")
	self.butt12.child.modify_font(fontButt)
	self.butt12.connect('clicked', self.buttonClicked, "next")
	hbox2.pack_start(self.butt12, True, True, 0)
	win.show_all()

    # WINDOW FUNCS
    def deleteChild(self, widget, event, data):
	global mod2sec
	mod2sec = False

    def destroy(self, event):
	miscFuncs().controlLircd("stop") # Stop Lirc in shut-down
	gtk.main_quit()

    def buttControl(self):
	if CURRENT_REMOTETYPE == "Olympus_RM-1":
	    self.butt3.show()
	else:
	    self.butt3.hide()
	try:
	    if CURRENT_REMOTETYPE == "CANON-RC1/RC5":
		self.buttMod2sec.show()
	    else:
		self.buttMod2sec.hide()
	except Exception:
	    print "No button for Mod2sec in current window"

    # MAIN MENU
    def mainMenu(self):
	menu = hildon.AppMenu()
	mbutt1 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
	mbutt1.set_label("Settings")
	mbutt1.connect('clicked', self.settingsDialog)
	menu.append(mbutt1)
	mbutt2 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
	mbutt2.set_label("About")
	mbutt2.connect('clicked', self.aboutDialog)
	menu.append(mbutt2)
	menu.show_all()
	return menu

    def settingsDialog(self, widget):
	global CURRENT_REMOTETYPE, TIME2BEEB
	settings = gtk.Dialog("Settings", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
	save = settings.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
	vbox = gtk.VBox()
	selector = hildon.TouchSelector()
	selector.add(vbox)

	# Selecting remote
	canon = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, None)
	canon.set_label("Canon")
	canon.set_mode(False)
	nikon = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, canon)
	nikon.set_label("Nikon")
	nikon.set_mode(False)
	olympus = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, canon)
	olympus.set_label("Olympus")
	olympus.set_mode(False)
	pentax = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, canon)
	pentax.set_label("Pentax")
	pentax.set_mode(False)

	if CURRENT_REMOTETYPE == "CANON-RC1/RC5":
	    canon.set_active(True)
	elif CURRENT_REMOTETYPE == "NikonDSLR":
	    nikon.set_active(True)
	elif CURRENT_REMOTETYPE == "Olympus_RM-1":
	    olympus.set_active(True)
	elif CURRENT_REMOTETYPE == "Pentax_RC-F":
	    pentax.set_active(True)
	else:
	    olympus.set_active(True) # Default

	label1 = gtk.Label("Select camera:")

	hbox1 = gtk.HBox()
	hbox1.pack_start(canon, True, True, 0)
	hbox1.pack_start(nikon, True, True, 0)
	hbox1.pack_start(olympus, True, True, 0)
	hbox1.pack_start(pentax, True, True, 0)
	vbox.pack_start(label1, False, False, 0)
	vbox.pack_start(hbox1, True, True, 0)

	# Selecting timer beeb interwall
	label2 = gtk.Label("Select time interwall for beebs:")
	t30sec = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, None)
	t30sec.set_label("30 Sec")
	t30sec.set_mode(False)
	t1min = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, t30sec)
	t1min.set_label("1 Min")
	t1min.set_mode(False)
	t10min = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, t30sec)
	t10min.set_label("10 Min")
	t10min.set_mode(False)
	tOff = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, t30sec)
	tOff.set_label("Off")
	tOff.set_mode(False)

	if TIME2BEEB == 30:
	    t30sec.set_active(True)
	elif TIME2BEEB == 60:
	    t1min.set_active(True)
	elif TIME2BEEB == 600:
	    t10min.set_active(True)
	elif TIME2BEEB == 0:
	    tOff.set_active(True)
	else:
	    t30sec.set_active(True) # Default

	vbox.pack_start(label2, False, False, 0)
	hbox2 = gtk.HBox()
	vbox.pack_start(hbox2, True, True, 0)
	hbox2.pack_start(t30sec, True, True, 0)
	hbox2.pack_start(t1min, True, True, 0)
	hbox2.pack_start(t10min, True, True, 0)
	hbox2.pack_start(tOff, True, True, 0)

	settings.vbox.add(selector)
	settings.show_all()
	response = settings.run()

	# Adding new settings in gConf
	if response == gtk.RESPONSE_OK:
	    # Adding remote in gconf
	    cameragroup = canon.get_group()
	    label = ""
	    for button in cameragroup:
		selected = button.get_active()
		if selected == True:
		    label = button.get_label()
		    break
	    remoteDict = {"Canon":"CANON-RC1/RC5", "Nikon":"NikonDSLR", "Olympus":"Olympus_RM-1", "Pentax":"Pentax_RC-F"}
	    miscFuncs().confAdder("remote", remoteDict[label])

	    # Adding beeb time in gconf
	    timergroup = t30sec.get_group()
	    for button in timergroup:
		selected = button.get_active()
		if selected == True:
		    label = button.get_label()
		    break
	    timeDict = {"Off":0, "30 Sec":30, "1 Min":60, "10 Min":600}
	    miscFuncs().confAdder("beebtime", timeDict[label])

	    self.buttControl() # Show hide buttons, if needed

	settings.destroy()

    def aboutDialog(self, widget):
	about = gtk.AboutDialog()
	about.set_title("About")
	about.set_name(APP_TITLE)
	about.set_version(APP_VERSION)
	about.set_copyright("Copyright 2010 Janne Pekkala")
	about.set_authors(["Janne Pekkala <yabbapappa@gmail.com>",""])
	about.set_artists(["Icon: Tomi Taipaleenmäki",""])
	#about.set_logo(gtk.pixbuf_new_from_file(LOGO))
	about.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
	about.set_license( """This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public
License along with this program.   If not, see
<http://www.gnu.org/licenses/>.""")
	#set_wrap_license(True)
	about.show_all()
	about.run()
	about.destroy()

    def main(self):
	gtk.main()

    # BUTTON FUNCS
    def buttonClicked(self, widget, data): # Function to direct button clicks in correct address. (To avoid all non-needed code in GUIs.)
	if data == "bulb": # This function will change outfit of bulb button between Bulb On and Bulb Off. It will modify the data send to Olympus.
	    global bulbStatus
	    if bulbStatus == False:
		self.buttBulb.set_label("Bulb Off")
		self.buttBulb.child.modify_font(fontButt)
		self.timer()
		bulbStatus = True
		if CURRENT_REMOTETYPE == "Olympus_RM-1":
		    data = "bulbon"
	    else:
		self.buttBulb.set_label("Bulb On")
		self.buttBulb.child.modify_font(fontButt)
		self.timerStop()
		bulbStatus = False
		if CURRENT_REMOTETYPE == "Olympus_RM-1":
		    data = "bulboff"

	if CURRENT_REMOTETYPE == "Olympus_RM-1":
	    digitalCamera().olympus(data)
	elif CURRENT_REMOTETYPE == "CANON-RC1/RC5":
	    digitalCamera().canon()
	else:
	    digitalCamera().oneButtonRemotes(CURRENT_REMOTETYPE)

    def mode2sec(self,widget, nmb):
	global mod2sec
	if mod2sec == False:
	    mod2sec = True
	    self.buttMod2sec.set_label("Deactivate 2 sec mode")
	    self.buttMod2sec.child.modify_font(fontButt)
	else:
	    mod2sec = False
	    self.buttMod2sec.set_label("Activate 2 sec mode")
	    self.buttMod2sec.child.modify_font(fontButt)

    def timerDialog(self, widget, win): # Dialog to add time in timer
	global minutes, seconds, timeAdded
	dialog = gtk.Dialog()
	dialog.set_transient_for(win)
	dialog.set_title("Select time!")
	dbutt = dialog.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
	vbox = gtk.HBox()
	dialog.vbox.add(vbox)

	minPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
	minSelect = hildon.TouchSelector(text = True)
	minDict = {}
	for i in range(61):
	    minDict["%s min" %i] = int(i)
	    minSelect.append_text("%s min" %i)
	    if i == 0:
		minSelect.set_active(i, i)
	minPicker.set_selector(minSelect)
	vbox.pack_start(minPicker, True, True,0)

	secPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
	secSelect = hildon.TouchSelector(text = True)
	secDict = {}
	for i in range(60):
	    secDict["%s sec" %i] = int(i)
	    secSelect.append_text("%s sec" %i)
	    if i == 0:
		secSelect.set_active(i, i)
	secPicker.set_selector(secSelect)
	vbox.pack_start(secPicker, True, True, 0)

	dialog.show_all()
	response = dialog.run()

	if response == gtk.RESPONSE_OK:
	    mins = minSelect.get_current_text()
	    secs = secSelect.get_current_text()
	    if minDict[mins]+secDict[secs] > 0:
		minutes = minDict[mins]
		seconds = secDict[secs]
		timeAdded = True
		self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
		self.timerLabel.modify_font(fontTimer)

	dialog.destroy()

    # TIMER & TIMER FUNCS
    def timer(self): # This function controls timer.
	global gobjid, timeAdded
	if timeAdded == True:
	    if gobjid == 0:
		gobjid = gobject.timeout_add(100, self.counterMinus)
	elif timeAdded == False:
		if gobjid == 0:
		    gobjid = gobject.timeout_add(100, self.counterPlus)

    def timerStop(self): # Function to stop
	global gobjid, seconds, minutes, timeAdded, timeSeconds, beebRun
	if gobjid != 0:
	    gobject.source_remove(gobjid)
	    gobjid = 0
	seconds = 0.0
	minutes = 0
	timeSeconds = 0.0
	beebRun = False
	if timeAdded == True:
	    timeAdded = False

    def counterPlus(self): # Function to count up
	global seconds, minutes, timeSeconds, globURI, beebRun
	if seconds > 59.9:
	    minutes += 1
	    seconds = 0.0
	    self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
	    self.timerLabel.modify_font(fontTimer)
	else:
	    seconds += 0.1
	    timeSeconds +=0.1
	    self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
	    self.timerLabel.modify_font(fontTimer)
	if TIME2BEEB != 0:
	    if timeSeconds >= 1.0 and beebRun == False and int(timeSeconds) % TIME2BEEB == 0:
		globURI = beeb
		player().start()
		beebRun = True
		if timeSeconds >= 600:
		    timeSeconds = 0.0
	return True

    def counterMinus(self): # Function to count down
	global seconds, minutes, globURI
	if minutes > 0:
	    if seconds < 0.1:
		minutes -=1
		seconds = 59.9
	    else:
		seconds -= 0.1
	elif seconds == 10.0:
		seconds -= 0.1
	elif seconds > 0.1:
	    seconds -= 0.1
	else:
	    globURI = alert
	    player().start()
	    self.timerStop()
	self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
	self.timerLabel.modify_font(fontTimer)
	return True

class player (threading.Thread):
    def run(self):
	global beebRun
	player = gst.element_factory_make("playbin","player")
	print "Playing: ",globURI
	player.set_property('uri', globURI)
	player.set_state(gst.STATE_PLAYING)
	time.sleep(3)
	beebRun = False

class digitalCamera: # This is class where commands from GUI are translated ready to be send to camera
    #CAMERAS
    def olympus(self,rawdata):
	comDict = {"shutter":"capture" , "bulbon":"W" , "bulboff":"T" , "zoomin":"T" , "zoomout":"W" , "previous":"-" , "next":"+"}
	cmd = comDict[rawdata]
	self.remote(cmd)

    def canon(self):
	global mod2sec
	if mod2sec == True:
	    cmd = "2S"
	else:
	    cmd = "S"
	self.remote(cmd)

    def oneButtonRemotes(self, remote):
	if remote == "Pentax_RC-F":
	    cmd = "Capture"
	elif remote == "NikonDSLR":
	    cmd = "shutter"
	else:
	    print "There is no camera selected"
	    cmd = "ShutterError"
	self.remote(cmd)

    # COMMANDING INFRA RED
    def remote(self, code):
	remote = CURRENT_REMOTETYPE
	# Sending ir commands to camera, using Popen from subprocess and external irsend program (part of Lirc).
	arg = ["/usr/bin/irsend", "send_once", remote, code]
	shoot = subprocess.Popen (arg, stdin = subprocess.PIPE)
	shoot.stdin.close()
	shoot.wait()
	# Need some kind of failback system + some info (more than what camera it self gives, example some kind of sound played after send.

class miscFuncs: # Some miscaleous functions (For the sake of simplicity
    # Lircd controller
    def controlLircd(self, cmd): # For starting and shutting down lirc in the start-up and close of program (or drive any other command you want
	arg = ["sudo","/etc/init.d/lirc", cmd]
	lircing = subprocess.Popen(arg)
	lircing.wait()

    # GCONF FUNCS
    def confReader(self, target): # To get data
	global CONFPATH
	client = gconf.client_get_default()
	client.add_dir(CONFPATH, gconf.CLIENT_PRELOAD_NONE)
	try:
	    data = client.get_string(CONFPATH+target)
	except Exception:
	    try:
		data = client.get_int(CONFPATH+target)
	    except Exception:
		print "Reading feeds from gconf failed miserable"
	return data

    def confAdder(self, target, data): # To put data
	global CONFPATH, CURRENT_REMOTETYPE, TIME2BEEB
	client = gconf.client_get_default()
	client.add_dir(CONFPATH, gconf.CLIENT_PRELOAD_NONE)
	try:
	    if type(data) != int:
		client.set_string(CONFPATH+target, str(data))
	    else:
		client.set_int(CONFPATH+target, int(data))
	except Exception:
	    print "Feeding gconf failed miserable"

	if target == "remote":
	    CURRENT_REMOTETYPE = str(data)
	elif target == "beebtime":
	    TIME2BEEB = int(data)

### Running up the program ####

if __name__ == "__main__":
    gui = pykakeGui()
    gui.main()
