#!/usr/bin/python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
import py2deb

if __name__ == "__main__":
    try:
        os.chdir(os.path.dirname(sys.argv[0]))
    except:
        pass

    p=py2deb.Py2deb("pygtkeditor")
    p.description="PyGTKEditor is a source code editor specially designed for maemo internet tablet."
    p.author="Benoît HERVIER"
    p.mail="khertan@khertan.net"
    p.depends = "python2.5-hildon,python2.5-gtk2,python2.5-pygtksourceview,python2.5-osso,python2.5-xml"
    p.section="user/office"
    p.arch="any"
    p.urgency="low"
    p.distribution="diablo"
    p.repository="extras-devel"
    p["/usr/bin"] = ["pygtkeditor",]
    p["/usr/share/dbus-1/services"] = ["pygtkeditor.service",]
    p["/usr/share/pixmaps"] = ["pygtkeditor.png",]
    p["/usr/share/applications/hildon"] = ["pygtkeditor.desktop",]
    p["/usr/share/mime/packages"] = ["cpp-mime.xml",
                                     "glade-mime.xml",
                                     "latex-mime.xml",
                                     "perl-mime.xml",
                                     "cpp-mime.xml",
                                     "xml-mime.xml",
                                     "sql-mime.xml",
                                     "sh-mime.xml",
                                     "ruby-mime.xml",
                                     "python-mime.xml",]
    p["/usr/lib/pygtkeditor"] = [ "codeeditor.py",
      "preferences.py","pygtkeditor_window.py",
      "make.py",

      "pygtkeditor.png",

      "pygtkeditor.glade",]

    p.postinstall = """#!/bin/sh
chmod +x /usr/bin/pygtkeditor"""

    print p
    r = p.generate("2.4.0","1",changelog=" * Fixes and first upload with autobuilder",tar=True,dsc=True,changes=True,build=False,src=True)
    print r
#scp *2.4.0-1* khertan@garage.maemo.org:/var/www/extras-devel/incoming-builder/diablo