/*
 * This file is part of PWSAFE
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef PWSAFE_APPDATA_H
#define PWSAFE_APPDATA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#endif

#include <libosso.h>
#include <glib.h>

typedef struct _AppData AppData;

struct _AppData {
    HildonProgram *app; /* handle to application */
    HildonWindow *main_view; /* handle to app's view */
    osso_context_t *osso; /* handle to osso */
};

enum {
	NAME=0, UUID=0x1, GROUP = 0x2, TITLE = 0x3, USER = 0x4, NOTES = 0x5,
	PASSWORD = 0x6, CTIME = 0x7, MTIME = 0x8, ATIME = 0x9, LTIME = 0xa,
	POLICY = 0xb, END = 0xff
}; /* field types, from formatV2.txt */


/* data records linked in a glist */
typedef struct rec {
	char *uuid; /* NULL or 16 bytes long */
	char *group;
	char *title;
	char *user;
	char *notes;
	char *password;
    int skip;
} rec;

GList *recs;  /* should be in the mainview struct */
char *showing_group;

#endif
