/*
 * This file is part of pwsafe
 *
 * Copyright (C) 2005 HolisTech Limited
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <src/interface.h>
#include <src/appdata.h>
#include <src/crypto.h>

#include <src/preferences.h>

#include <gtk/gtkmain.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#endif

#include <libintl.h>
#include <locale.h>
#include <libosso.h>
/* 
 * #include <libmb/mbutil.h>
 */

#define _(String) gettext(String)

#define APP_NAME "pwsafe"
#define APP_VER "1.4.0"

extern void save_mod_file(MainView *mainview);
extern void close_file(MainView *mainview);

/*
 * create our application specific data
 * This consists of allocating some space
 * for the AppData structure, and also
 * creating the list store that will act
 * as a model for the contact list.
 * The other elements of the AppData structure
 * are implicitly set by the call to g_new0
 * which zeroes the memory of the AppData, thereby
 * setting create_new to FALSE, and iter to NULL.
 *
 */
static AppData *create_data ()
{
	AppData *result = g_new0( AppData, 1 );
	result->osso = osso_initialize ( APP_NAME, APP_VER, FALSE, NULL );
	g_assert ( result->osso );
	return result;
}

/* Here we clean up all the data that we allocated */
static void destroy_data ( AppData *data ) {
	g_free ( data );
}

int main( int argc, char* argv[] ) {
	AppData* data; 
	HildonProgram* app; 
	MainView* main_view;

	/* Initialise the locale stuff */
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	recs=NULL;
	
	/* Init the gtk - must be called before any hildon stuff */
	gtk_init( &argc, &argv );

	/* Create the hildon application and setup the title */
	app = HILDON_PROGRAM ( hildon_program_get_instance () );
	g_set_application_name ( _("Password Safe") );

	/* Create the data and views for our application */
	data = create_data ();
	data->app = app;
	main_view = interface_main_view_new ( data );
	hildon_program_add_window( app, data->main_view );
	
	/* Begin the main app */
	gtk_widget_show ( GTK_WIDGET ( data->main_view ) );

	main_view->last_file=conf_get_string(CONF_LASTFILE);
	g_signal_emit_by_name(G_OBJECT(main_view->open_last_item), "activate");
	
	gtk_main();

	/* Clean up */
    save_mod_file(main_view);
	close_file(main_view);
	osso_deinitialize(data->osso);
	interface_main_view_destroy ( main_view );
	destroy_data ( data );

	return 0;
}
