#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
##################################################################################
##    PVR image creator.                                                        ##
##    Copyright (C) 2010 Mohammad Abu-Garbeyyeh                                 ##
##                                                                              ##
##    This program is free software; you can redistribute it and/or modify      ##
##    it under the terms of the GNU General Public License as published by      ##
##    the Free Software Foundation; either version 2 of the License, or         ##
##    (at your option) any later version.                                       ##
##                                                                              ##
##    This program is distributed in the hope that it will be useful,           ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of            ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             ##
##    GNU General Public License for more details.                              ##
##                                                                              ##
##    You should have received a copy of the GNU General Public License         ##
##    along with this program; if not, write to the Free Software               ##
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA ##
##################################################################################

import hildon
import os
import gtk, gobject, glib
import re
import time

class GUI(hildon.Program):

	def __init__(self):
		self.window = hildon.Window()
		gtk.set_application_name("PVR Creator")
		self.window.set_title("PVR Creator")
		self.buttonimage = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | \
					gtk.HILDON_SIZE_FINGER_HEIGHT, \
					hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.buttonimage.set_title("Select image file")
		self.buttonimage.connect('clicked', lambda b: self.open_file_dialog())	
		self.vb = gtk.VBox()
		self.vb.pack_start(self.buttonimage, False, False)
		self.footer = gtk.Label()
		self.footer.set_markup('<small>© 2010 Mohammad Abu-Garbeyyeh. Licensed under GPL.</small>')
		self.footer.set_alignment(1., 1.)
		self.vb.pack_start(self.footer, True, True)
		self.window.add(self.vb)
		self.vb.show()
    		self.window.connect('destroy', gtk.main_quit)

	def take_ss(self):
		""" Takes a screenshot of the application used by hildon to show while loading.
		inspired by Andrew Flegg and WimpWorks.
		@see http://maemo.org/api_refs/5.0/5.0-final/hildon/hildon-Additions-to-GTK+.html#hildon-gtk-window-take-screenshot 
		"""
		if os.path.isfile("/home/user/.cache/launch/org.maemo.pvrcreator.pvr"):
			gobject.timeout_add(10, hildon.hildon_gtk_window_take_screenshot, self.window, False)
	
		gobject.timeout_add(10, hildon.hildon_gtk_window_take_screenshot, self.window, True)

	#From fMMS, thanks frals :D
	def open_file_dialog(self, data=None):
		# this shouldnt issue a warning according to the pymaemo mailing list, but does
		# anyway, nfc why :(
		#fcd = gobject.new(hildon.FileChooserDialog, self.window, action=gtk.FILE_CHOOSER_ACTION_OPEN)
		fcd = hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_OPEN)
		fcd.set_default_response(gtk.RESPONSE_OK)
		fcd.set_transient_for(self.window)
		ret = fcd.run()
		if ret == gtk.RESPONSE_OK:
			self.imageFile = fcd.get_filename()
			fcd.destroy()
			print self.imageFile
			self.vb.hide()
			self._background, mask = gtk.gdk.pixbuf_new_from_file(self.imageFile).render_pixmap_and_mask()
			self.window.realize()
			self.window.window.set_back_pixmap(self._background, False)
			self.take_ss()	
		else:
			fcd.destroy()
		return True

	def run(self):
		self.window.show_all()
		gtk.main()


if __name__ == "__main__":
	UI = GUI()
	UI.run()
