#include "pair.h"

#include <QDebug>
#include <QMutexLocker>
#include "board.h"


Pair::Pair()
{
    //qDebug() << "Pair::Pair()";
}

Pair::~Pair()
{    
    foreach( Smily* smily, mList ) {
        delete smily;
    }
    mList.clear();
}

void Pair::createPair( int aColumn )
{
    QMutexLocker locker(&mMutex);
    append( new Smily( qrand() % 4 ,BoardPos( 0, aColumn)) );
    append( new Smily( qrand() % 4 ,BoardPos( 0, aColumn + 1)) );
}

void Pair::append( Smily* aSmily )
{
    //qDebug() << "Pair::append()";
    mList.append( aSmily );
}

void Pair::draw( QPainter& aPainter )
{
    //qDebug() << "Pair::draw()";
    foreach( Smily* smily, mList ) {
        smily->draw(aPainter);
    }    
}

void Pair::fall()
{
    QMutexLocker locker(&mMutex);

    qDebug() << "Pair::fall()";
    foreach( Smily* smily, mList ) {
        smily->fall();
    }
}

void Pair::rotate( Board& aBoard )
{
    if( mList.count() < 2) {
        return;
    }

    QMutexLocker locker(&mMutex);

    //direction down
    if( mList[1]->boardPos().row() > mList[0]->boardPos().row() ) {
        rotate( aBoard,mList[1], -1,  -1 );
    } else if( mList[1]->boardPos().row() < mList[0]->boardPos().row()  ) {
        rotate( aBoard, mList[1], 1,  1 );
    } else if(mList[1]->boardPos().column() > mList[0]->boardPos().column() ) {
        rotate( aBoard, mList[1], -1,  1 );
    } else if (mList[1]->boardPos().column() < mList[0]->boardPos().column() ) {
        rotate( aBoard, mList[1], 1,  -1 );
    }
}

void Pair::rotate( Board& aBoard, Smily* aSmily,int aColMove,int aRowMove )
{
    BoardPos oldPos = aSmily->boardPos();
    BoardPos pos = aSmily->boardPos();
    pos.setColumn( pos.column() + aColMove);
    pos.setRow( pos.row() + aRowMove);

    aSmily->mBoardPos = pos;
    if(aBoard.isColliding( *aSmily)) {
        aSmily->mBoardPos = oldPos;
    }
}

void Pair::slide( Board& aBoard, int aDirection)
{
    QMutexLocker locker(&mMutex);

    if( !canSlide(aBoard, aDirection)) {
        return;
    }

    foreach( Smily* smily, mList ) {
        smily->slide( aDirection );
    }
}

bool Pair::canSlide( Board& aBoard, int aDirection)
{
    if( mList.count() < 2 ) {
        return false;
    }

    foreach( Smily* smily, mList ) {
        bool canSlide = aBoard.canSlide( *smily, aDirection );
        if( !canSlide ) return false;
    }
    return true;
}

int Pair::count()
{
    return mList.count();
}

bool Pair::isValid()
{
    return !mList.isEmpty();
}

Smily* Pair::operator[]( int aIndex )
{
    return mList[ aIndex ];
}

Smily* Pair::remove( int aIndex )
{
    qDebug() << "remove";
    Smily* smily = mList[ aIndex ];
    mList.removeAt( aIndex );
    return smily;
}

bool Pair::isVerticale()
{   
    return ( mList.count() >= 2 && mList[0]->boardPos().column() == mList[1]->boardPos().column() );
}

QList<Smily*> Pair::removeIfCollidingWith( Board& aBoard )
{
    QList<Smily*> removedSmilys;    
    bool isVert = isVerticale();
    int i=0;
    while( mList.count() > 0 && i < mList.count() ) {
        Smily* smily = mList[i];
        bool isColliding = aBoard.isColliding( *smily );
        if ( isColliding && isVert ) {
            removedSmilys.append(  mList );
            mList.clear();
        } else if ( isColliding ) {
            removedSmilys.append(smily);            
            mList.removeAt(i);
        } else {
            i++;
        }
    }
    return removedSmilys;
}

