#include "mainwidget.h"

#include <QPushButton>
#include <QVBoxLayout>
#include <QLayout>
#include <QStackedLayout>

//#include <qmaemo-ext/widget/qorientationcapability.h>
#include <QtDBus>
#include <QtCore>
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#include <QPalette>

#include "gamewidget.h"
#include "gamewindow.h"
#include "menuwidget.h"

MainWidget::MainWidget(QWidget *aParent)
    :QWidget(aParent)
{    
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);

    mGamePage = new GameWidget(this);
    mMenuPage = new MenuWidget(this);

    mStackedLayout = new QStackedLayout;
    mStackedLayout->addWidget(mGamePage);
    mStackedLayout->addWidget(mMenuPage);

    setLayout(mStackedLayout);

    mStackedLayout->setCurrentWidget( mMenuPage );

    QObject::connect( mMenuPage,SIGNAL(newGame()),this,SLOT(newGame()));
    QObject::connect( mMenuPage,SIGNAL(resumeGame()),this,SLOT(resumeGame()));
    QObject::connect( mGamePage,SIGNAL(pauseGame()),this,SLOT(pauseGame()));
    QObject::connect( mGamePage,SIGNAL(pauseGame()),mMenuPage,SLOT(pauseGame()));
    QObject::connect( mGamePage,SIGNAL(gameEnded(int)),mMenuPage,SLOT(gameEnded(int)));
    QObject::connect( mGamePage,SIGNAL(gameEnded(int)),this,SLOT(pauseGame()));

    disableDisplayOff();

    //QPalette palette( this->palette() );
    //palette.setColor(QPalette::Window, QColor(0,0,0,50));
    //setPalette(palette);

    this->resize(480,800);    
}


void MainWidget::pauseGame()
{
    mStackedLayout->setCurrentWidget(mMenuPage);    
}

void MainWidget::newGame()
{
    mStackedLayout->setCurrentWidget(mGamePage);
    mGamePage->newGame();
}

void MainWidget::resumeGame()
{
    mStackedLayout->setCurrentWidget( mGamePage );
    mGamePage->resumeGame();
}

void MainWidget::disableDisplayOff()
{
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                                         MCE_REQUEST_IF, MCE_PREVENT_BLANK_REQ));
}

