#include "gamethread.h"

#include <QDebug>

#include "board.h"
#include "pair.h"
#include "smily.h"

GameThread::GameThread( Board* aBoard, Pair* aPair, QObject* aParent)
    :QThread(aParent),mBoard(aBoard),mPair(aPair)
{        
    mBoard->moveToThread( this );        
    mTimer = new QTimer(this);
    start();
}

void GameThread::startGame()
{
    QObject::connect(mTimer,SIGNAL(timeout()),this,SLOT(timeout()));
    mTimer->start( 600 );
}

void GameThread::pauseGame()
{
    QObject::disconnect(mTimer,SIGNAL(timeout()),this,SLOT(timeout()));
    mTimer->stop();
}

void GameThread::run()
{
    exec();
}

//does pair exist --create pair if required
//check for GameOver
//check for collison of board with pair
//check for match
//remove matching object
//collide top object if required

void GameThread::timeout()
{
    if( ! mPair->isValid() ) {
        //create pair and wait for next tick
        createPair();        
        return;
    }

   if( checkForCollision() ) {
        mBoard->checkForMatch();
   }

   if ( mBoard->isTouchingTop() ) {
       pauseGame();
       emit gameEnded();
   }

   mPair->fall();
}

void GameThread::createPair()
{
    int position = qrand() % ( mBoard->size().width() - 1 ) ;
    qDebug() << "GameThread::createPair()" << position ;

    mPair->createPair( position );   
}

bool GameThread::checkForCollision()
{
    //qDebug() << "GameWindow::checkForCollision()";
    return ( checkCollisionWithBoard() );
}

bool GameThread::checkCollisionWithBoard()
{
    qDebug() << "GameThread::checkCollisionWithBoard()";
    bool collisionOccured(false);
    QList<Smily*> removedSmily = mPair->removeIfCollidingWith(*mBoard);
    collisionOccured = removedSmily.count() > 0 ? true:false;
    foreach( Smily* smily, removedSmily ) {
        mBoard->append( smily );
    }
    removedSmily.clear();
    return collisionOccured;
}

