#ifndef ANIMATION_H
#define ANIMATION_H

#include <QObject>
#include <QTimer>
#include <QVariant>
#include <QDebug>
#include "animable.h"

class Animation : public QObject
{
    Q_OBJECT

public:

    Animation( QObject *aParent = 0 )
        :QObject( aParent )
    {
        mTimer = new QTimer(this);
    }

    ~Animation()
    {
        foreach ( Animable *animableObj, mAnimbaleList ) {
           delete animableObj;
        }
        mAnimbaleList.clear();
    }

    void setAnimableObject( const QList<Animable *> &aTargetObject )
    {
        mAnimbaleList = aTargetObject;
    }

    void addAnimableObject( Animable* aAnimanleObject )
    {
        mAnimbaleList.append( aAnimanleObject );
    }

    void setTimeValue( int aInterval )
    {        
        mInterval = aInterval;
    }

    const QList<Animable* >& targetObject() const
    {
        return *(&mAnimbaleList);
    }

public slots:

    void start()
    {
        qDebug() << "Animation::start()";

        QObject::connect(mTimer,SIGNAL(timeout()),this,SLOT(timeout()));
        mTimer->start( mInterval );
    }

signals:

    void animationComplete( Animation *aAnimation );

private slots:

    void timeout()
    {
        qDebug() << "Animation::timeout() count:" << mAnimbaleList.count() ;
        bool animComplete = true;
        foreach ( Animable *animableObj, mAnimbaleList ) {
            qDebug() << "timeout:: outer" << animableObj;
            if( !animableObj->animate() &&  animComplete ) {
                qDebug() << "timeout:: inner" << animableObj ;
                animComplete = false;
            }
        }

        if ( animComplete ) {
            mTimer->stop();
            emit animationComplete( this );
        }
    }

private:

    QTimer *mTimer;    
    int mInterval;
    QList<Animable*> mAnimbaleList;
};


//AnimationSequence
//
//        Start()
//        {
//                if( list.count() > 0 )
//                {
//                        list[0].start();
//                }
//        }
//
//AddAnimation( AnimHelper animation )
//        {
//                if( list.count() > 0 )
//                {
//                AnimHelper prevAnimation = list[ list.count() - 1];
//                connect( prevAnimation, SIGNAL( complete), animation, SLOT(start));
//                }
//                list.append( animation );
//        }


#endif // ANIMATION_H

