#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QFile>
#include <QFileDialog>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                images[x][y] = new Label(this);
                images[x][y]->setGeometry(x*30,y*30,30,30);
                images[x][y]->x=x;
                images[x][y]->y=y;
                images[x][y]->type = 0;
                //connect(this,SLOT(setType(int,int)),images[x][y],SIGNAL(setType(int,int)));
                connect(images[x][y],SIGNAL(setType(int,int)),this,SLOT(setType(int,int)));
            }
        }
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showFullScreen();
#else
    show();
#endif
}

void MainWindow::setType(int x, int y){

    images[x][y]->type=ui->cmbType->currentIndex();

    switch (ui->cmbType->currentIndex()){
    case 0:
        images[x][y]->setStyleSheet("");
        break;
    case 1:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
        break;
    case 2:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
        break;
    case 3:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
        break;
    case 4:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
        break;
    case 5:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
        break;
    case 6:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
        break;
    case 7:
        images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
        break;
    }
}


void MainWindow::on_btnClose_pressed(){
    exit(0);
}

void MainWindow::on_btnSave_pressed(){
    for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                this->repaint();
            }
    }
}

void MainWindow::on_btnClear_pressed(){
    ui->btnClear->setText("Clearing..");
    this->repaint();
    for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                images[x][y]->setStyleSheet("");
                images[x][y]->type = 0;
            }
    }
    ui->btnClear->setText("Clear");
}

void MainWindow::on_btnApply_clicked()
{
    switch (ui->cmbFill->currentIndex()){
    case 0:
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {

                images[x][y]->type=ui->cmbType->currentIndex();

                switch (ui->cmbType->currentIndex()){
                case 0:
                    images[x][y]->setStyleSheet("");
                    break;
                case 1:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
                    break;
                case 2:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
                    break;
                case 3:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
                    break;
                case 4:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
                    break;
                case 5:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
                    break;
                case 6:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
                    break;
                case 7:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
                    break;
                }

            }
        }
        break;
    case 1:
        for (int x = 1; x < 15; ++x) {
            for (int y = 1; y < 15; ++y) {

                images[x][y]->type=ui->cmbType->currentIndex();

                switch (ui->cmbType->currentIndex()){
                case 0:
                    images[x][y]->setStyleSheet("");
                    break;
                case 1:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
                    break;
                case 2:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
                    break;
                case 3:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
                    break;
                case 4:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
                    break;
                case 5:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
                    break;
                case 6:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
                    break;
                case 7:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
                    break;
                }

            }
        }
        break;
    case 2:
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {

                if (x!=0&&x!=15){
                    if (y!=0&&y!=15){
                        continue;
                    }
                }

                images[x][y]->type=ui->cmbType->currentIndex();

                switch (ui->cmbType->currentIndex()){
                case 0:
                    images[x][y]->setStyleSheet("");
                    break;
                case 1:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
                    break;
                case 2:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
                    break;
                case 3:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
                    break;
                case 4:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
                    break;
                case 5:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
                    break;
                case 6:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
                    break;
                case 7:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
                    break;
                }

            }
        }
        break;

    case 3:
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {

                if (x==0||x==15||x==1||x==14||x==2||x==13||x==3||x==12){
                    continue;
                }

                if (y==0||y==15||y==1||y==14||y==2||y==13||y==3||y==12){
                    continue;
                }

                images[x][y]->type=ui->cmbType->currentIndex();

                switch (ui->cmbType->currentIndex()){
                case 0:
                    images[x][y]->setStyleSheet("");
                    break;
                case 1:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
                    break;
                case 2:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
                    break;
                case 3:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
                    break;
                case 4:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
                    break;
                case 5:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
                    break;
                case 6:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
                    break;
                case 7:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
                    break;
                }

            }
        }
        break;

    case 4:
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {

                if (x % 2 ==0){
                        continue;
                }

                images[x][y]->type=ui->cmbType->currentIndex();

                switch (ui->cmbType->currentIndex()){
                case 0:
                    images[x][y]->setStyleSheet("");
                    break;
                case 1:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
                    break;
                case 2:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
                    break;
                case 3:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
                    break;
                case 4:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
                    break;
                case 5:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
                    break;
                case 6:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
                    break;
                case 7:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
                    break;
                }

            }
        }
        break;

    case 5:
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {

                if (y % 2 ==0){
                        continue;
                }

                images[x][y]->type=ui->cmbType->currentIndex();

                switch (ui->cmbType->currentIndex()){
                case 0:
                    images[x][y]->setStyleSheet("");
                    break;
                case 1:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
                    break;
                case 2:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
                    break;
                case 3:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
                    break;
                case 4:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
                    break;
                case 5:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
                    break;
                case 6:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
                    break;
                case 7:
                    images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
                    break;
                }

            }
        }
        break;

    }
}

void MainWindow::drawLevel(){
    /*
		#########################################
		# 0 empty
		# 1 field
		# 2 wall
		# 3 destination
		# 4 box
		# 5 completed box
		# 6 player
		# 7 player on destination
		#########################################
		*/

    for (int j = 0;j < 16; ++j) {
	for (int i = 0; i< 16; ++i) {
	    if (images[i][j]->type == 0){
		images[i][j]->setStyleSheet("");
	    }else if (images[i][j]->type == 1){
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
	    }else if (images[i][j]->type == 2){
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
	    }else if (images[i][j]->type == 3){
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
	    }else if ( images[i][j]->type == 4){
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
	    }else if ( images[i][j]->type == 5) {
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
	    }else if ( images[i][j]->type == 6){
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
	    }else if ( images[i][j]->type == 7){
		images[i][j]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
	    }else{
		images[i][j]->setStyleSheet("");
	    }
	}
    }
}

void MainWindow::on_btnSav_clicked()
{
    QString customLevel;

    QString name=QFileDialog::getSaveFileName(this,"Select a Custom Level","/home/user/MyDocs/", "Pusher Files (*.psh)");
    if (name.indexOf(".psh")==-1){
        name=name+".psh";
    }

    QFile file(name);

    if ( file.open(QIODevice::WriteOnly | QIODevice::Text) )
    {
        QTextStream stream( &file );

        for (int x = 0; x < 16; ++x) {
            customLevel="";
            for (int y = 0; y < 16; ++y) {

                if (customLevel.isEmpty()){
                    customLevel="{"+QString::number(images[y][x]->type);
                }else if (y==15){
                    customLevel=customLevel+","+QString::number(images[y][x]->type);
                    stream << customLevel << "}\n";
                }else{
                    customLevel=customLevel+","+QString::number(images[y][x]->type);
                }
            }
        }

        file.close();
    }
}

void MainWindow::on_btnLoad_clicked()
{
    QString fullLine;
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"),"",tr("Pusher level file (*.psh)"));
    QFile file(fileName);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
	//showmessage that file is corrupted
    }else{
	QTextStream in(&file);
	QString line = in.readLine();
	QStringList lines;

	line = line.remove('{');
	line = line.remove('}');
	line = line.remove(',');
	lines.append(line);
	fullLine=fullLine+line;

	while (!line.isNull()) {
	    line = in.readLine();
	    line = line.remove('{');
	    line = line.remove('}');
	    line = line.remove(',');
	    lines.append(line);
	    fullLine=fullLine+line;
	}

	for (int var = 0; var < lines.count(); ++var) {
	    qDebug() << lines.at(var);
	}

	if (lines.count()>15){
	    for (int x = 0; x < 16; ++x) {
		for (int y = 0; y < 16; ++y) {
		    images[y][x]->type=QString(lines.at(x).at(y)).toInt();
		}
	    }
	    drawLevel();
	}else{
	    //showmessage that file is corrupted
	}

    }
}
