#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    for (int x = 0; x < 16; ++x) {
	    for (int y = 0; y < 16; ++y) {
		images[x][y] = new Label(this);
		images[x][y]->setGeometry(x*30,y*30,30,30);
		images[x][y]->x=x;
		images[x][y]->y=y;
		//connect(this,SLOT(setType(int,int)),images[x][y],SIGNAL(setType(int,int)));
		connect(images[x][y],SIGNAL(setType(int,int)),this,SLOT(setType(int,int)));
	    }
	}
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::setType(int x, int y){

    if (ui->rdbEmpty->isChecked()) {

	images[x][y]->setStyleSheet("");
	images[x][y]->type = 0;

    } else if (ui->rdbField->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);}");
	images[x][y]->type = 1;

    } else if (ui->rdbWall->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/walls/wall_0.png);}");
	images[x][y]->type = 2;

    } else if (ui->rdbDestination->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/destinations/destination_0.png);}");
	images[x][y]->type =3;

    } else if (ui->rdbBox->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/boxes/box_0.png);}");
	images[x][y]->type = 4;

    } else if (ui->rdbCompletedBox->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/completedBoxes/completedBox_0.png);}");
	images[x][y]->type = 5;

    } else if (ui->rdbPlayer->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/players/player_0.png);}");
	images[x][y]->type = 6;

    } else if (ui->rdbPlayerOnDestination->isChecked()){

	images[x][y]->setStyleSheet("QLabel{ background-image: url(:/icons/fields/field_0.png);image: url(:/icons/playersOnDestination/playerOnDestination_0.png);}");
	images[x][y]->type = 7;

    }
}


void MainWindow::on_btnClose_pressed()
{
    exit(0);
}
