/*
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <stdio.h>

#include <QMainWindow>
#include <QTimer>
#include <QPushButton>
#include <QAction>
#include <QMenuBar>

#include "fullscreenexitbutton.h"
#include "timekeeper.h"
#include "releaseinformation.hpp"

//QTM_USE_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

  public slots:
    void mainButtonHandler();
    void mainButtonRefresh();
    void mainButtonRefreshTextOnly();
    void mainButtonTimeoutUpdate();

    void resetProgram();
    void resetProgramAndFullscreen();
    void pauseCounting();
    void saveToFile();
    void about();
    void showFullList();
    void showFullScreenHandler();
    void slotFullscreenExit();

    void changeNumberOfLines(int number = 0);
    void changeFontSize(int size = 0);

    void toggleStartStopMode();
    void toggleUseDeltaTime();
    void toggleFullDate();
    void toggleTimeDate();
#ifdef Q_WS_MAEMO_5
    void toggleDisableScreensaver();
#endif

private:
    /* Datatypes */
    struct StringFunctionMap
    {
      QString string;
      int (MainWindow::*getFunction)();
      int (MainWindow::*setFunction)(int);
    };

    /* Functions */
    int resetCounters();
    int resetUi();
    int updateTime();
    int toggleTimer();
    int toggleActionPause();

    QString generateHistoryString();
    QString getHeaderLine();

    //config file handling
    int loadFile();
    int saveFile();

    //ui setup
    void setupUi();
    void retranslateUi();

    //config file handling support
    //getting
    int getNumberOfLines();
    int getFontSize();
    int getDeltaModeFlag();
    int getShowTimeDateFlag();
    int getShowFullDateFlag();
    int getStartPauseFlag();
    int getScreensaverDisabledFlag();
    //setting
    int setNumberOfLines(int);
    int setFontSize(int);
    int setDeltaModeFlag(int);
    int setShowTimeDateFlag(int);
    int setShowFullDateFlag(int);
    int setStartPauseFlag(int);
    int setScreensaverDisabled(int);

    StringFunctionMap* getSfm();

    /* QT ui stuff */
    QAction *actionReset;
    QAction *actionPause;
    QAction *actionStartStopMode;

    QAction *actionShow_full_list;
    QAction *actionEnable_full_date;
    QAction *actionEnable_time_and_date;

    QAction *action_Fullscreen;
    QAction *actionResetFs;
    QAction *actionChangeNumberOfLines;
    QAction *actionChangeFontSize;
    QAction *actionUseDeltaTime;
#ifdef Q_WS_MAEMO_5
    QAction *actionDisableScreensaver;
#endif

    QAction *actionAbout;

    QWidget *centralWidget;
    QPushButton *mainButton;
    QMenuBar *menuBar;
    QMenu *menuPush_It_Menu;
    QMenu *menuHelp;
    QMenu *menuData;
    QMenu *menuView;
    FullScreenExitButton *fsExitButton;

    /* Used classes */
    TimeKeeper overallTime;
    ReleaseInformation releaseInfo;

    /* Variables */
    char mainButtonStartText[BUFSIZ];
    QTimer *timer;
    QString completeString;
    int hitCount;
    int timerRefreshTimeMs;

    //ui customization
    QString path;
    bool timeOutput;
    int maximumNumberOfLines;
    int fontSize;
    bool isStartStopModeActive;
    bool useDeltaTime;
    bool isScreenSaverDisabled;

    StringFunctionMap *sfm;
};

#endif // MAINWINDOW_H
