/**************************************************************************
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**   Special keywords: markus 8/8/2010 2010
**   Environment variables: %$VARIABLE%
**************************************************************************/

#include "releaseinformation.hpp"

ReleaseInformation::ReleaseInformation()
{
  time_t now;
  time(&now);
  packageName = "Push It!";
  packageVersion = "0.1.2";
  localtime_r(&now,&packageDate);

  packageDate.tm_year = 2010-1900;
  packageDate.tm_mon = 8-1;
  packageDate.tm_mday = 14;
  packageDate.tm_hour = 22;
  packageDate.tm_min = 02;
  packageDate.tm_sec = 0;
}

/**********************************************************
  Get package name
  ********************************************************/
std::string ReleaseInformation::getPackageName()
{
  return packageName.toStdString();
}

QString ReleaseInformation::getPackageNameQ()
{
  return packageName;
}

/**********************************************************
  Get package version
  ********************************************************/
std::string ReleaseInformation::getPackageVersion()
{
  return packageVersion.toStdString();
}

QString ReleaseInformation::getPackageVersionQ()
{
  return packageVersion;
}

/**********************************************************
  Get package date
  ********************************************************/
QString ReleaseInformation::dateToString()
{
  char buffer[BUFSIZ];
  strftime(buffer,BUFSIZ-1,"%FT%T%z%Z",&packageDate);
  QString date = buffer;
  return date;
}

QString ReleaseInformation::getPackageDateQ()
{
  return dateToString();
}

std::string ReleaseInformation::getPackageDate()
{
  return dateToString().toStdString();
}

struct tm ReleaseInformation::getPackageDateTm()
{
  return packageDate;
}
