/*
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QPushButton>
#include <QAction>
#include <QMenuBar>
#include "fullscreenexitbutton.h"
#include "timekeeper.h"
#include <stdio.h>

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

  public slots:
    void mainButtonRefresh();
    void mainButtonRefreshTextOnly();
    void resetProgram();
    void resetProgramAndFullscreen();
    void pauseCounting();
    void mainButtonTimeoutUpdate();
    void saveToFile();
    void toggleFullDate();
    void toggleTimeDate();
    void about();
    void showFullList();
    void showFullScreenHandler();
    void slotFullscreenExit();
    void changeNumberOfLines(int number = 0);
    void changeFontSize(int size = 0);

private:
    int resetCounters();
    int resetUi();
    int updateTime();
    int toggleTimer();
    int toggleActionPause();
    int updateUiText();

    void setupUi();
    void retranslateUi();

    QAction *actionReset;
    QAction *actionResetFs;
    QAction *actionSimulated_click;
    QAction *actionPause;
    QAction *actionShow_full_list;
    QAction *actionSave_full_list;
    QAction *actionAbout;
    QAction *actionEnable_full_date;
    QAction *actionEnable_time_and_date;
    QAction *action_Fullscreen;
    QAction *actionChangeNumberOfLines;
    QAction *actionChangeFontSize;
    QWidget *centralWidget;
    QPushButton *mainButton;
    QMenuBar *menuBar;
    QMenu *menuPush_It_Menu;
    QMenu *menuHelp;
    QMenu *menuData;
    QMenu *menuView;
    FullScreenExitButton *fsExitButton;

    QString generateHistoryString();
    QString getHeaderLine();

    class timeKeeper overallTime;

    char mainButtonStartText[BUFSIZ];
    QTimer *timer;
    QString completeString;
    int hitCount;
    int timerRefreshTimeMs;
    bool timeOutput;
    int maximumNumberOfLines;
};

#endif // MAINWINDOW_H
