/*
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef ABOUTDIALOG_HPP
#define ABOUTDIALOG_HPP

#include <QTextBrowser>
#include <QDialog>
#include <QTranslator>
#include <QTabWidget>

class AboutDialog : public QDialog
{
  Q_OBJECT

public:
  explicit AboutDialog(QString name = "", QString customUrl = "", QWidget *parent = 0);
  ~AboutDialog();
  int setProgramName(QString name);
  int setProgramUrl(QString url);
  int setGeneralHtmlText(QString htmlText = "");
  int setDonateHtmlText(QString htmlText = "");
  int setWebsiteHtmlText(QString htmlText = "");
  int setFeedbackHtmlText(QString htmlText = "");
  QTabWidget *tabs;

private:
  int refreshDefaultTexts();

  QTextBrowser *browserGeneral;
  QTextBrowser *browserDonate;
  QTextBrowser *browserWebsite;
  QTextBrowser *browserFeedback;

  QString textGeneral;
  QString textDonate;
  QString textFeedback;
  QString textWebsite;

  QString programName;
  QString programUrl;
};

#endif // ABOUTDIALOG_HPP
