#ifndef _PTSSDB_H_
#define _PTSSDB_H_

#include <QtSql>


enum DayIdx {
	ALL_WEEK=0,
	WORK_DAYS,
	WEEKEND,
	
	MONDAY,
	TUESDAY,
	WEDNESDAY,
	THURSDAY,
	FRIDAY,
	SATURDAY,
	SUNDAY,
} ;

enum {
	//in case this program is used on Mars, use other value :-)
	HOURS_PER_DAY=24,
};

typedef unsigned int DayFlagArray;

static const DayFlagArray DayIdxTable[] = 
{
//ALL   WORK  WEEKEND
	0x7f, 0x7c, 0x03,

//MON   TUE   WED   THU   FRI   SAT   SUN
	0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01
};

typedef struct {
	QString linkId, fromStop, toStop;
	DayFlagArray day;
	int minute;
	int tag;
} SingleConnectionTime;

class PtssGroupContentsModel : public QSqlQueryModel
{
public:
	PtssGroupContentsModel(QObject *parent, QSqlDatabase db): QSqlQueryModel(parent) { qDb=db; }
	virtual ~PtssGroupContentsModel() { }
	
	QVariant data(const QModelIndex &item, int role) const;
	
	void setGroupName(QString groupName);
	void insertConnection(int connId);
	void removeConnection(int connId);
	
private:
	QString _groupName;
	QSqlDatabase qDb;
};


class PtssStopsTableModel : public QSqlTableModel
{
public:
	PtssStopsTableModel(QObject *parent, QSqlDatabase db): QSqlTableModel(parent, db) { }
	virtual ~PtssStopsTableModel() { }
	
	virtual int rowCount ( const QModelIndex &i=QModelIndex() ) const { return QSqlTableModel::rowCount(i)+1; }
	virtual QVariant data(const QModelIndex &item, int role) const;
	bool setData(const QModelIndex &index, const QVariant &value, int role);
};



class PtssTimesTableModel : public QAbstractTableModel
{
public:
	PtssTimesTableModel(QObject *parent, QSqlDatabase db): QAbstractTableModel(parent) {qDb=db; }
	virtual ~PtssTimesTableModel() { }
	
	void setParameters(QString link, int fromStop, int toStop, DayFlagArray days) {
		qLink=link;
		qStopFrom=fromStop;
		qStopTo=toStop;
		qDays=days;
	}
	
	virtual int columnCount ( const QModelIndex & ) const { return 2; }
	virtual int rowCount ( const QModelIndex & ) const { return HOURS_PER_DAY; }
	QVariant data(const QModelIndex &item, int role) const;
	QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
	
	Qt::ItemFlags flags(const QModelIndex &index) const;
	bool setData(const QModelIndex &index, const QVariant &value, int role);
	
private:
	QString qLink;
	int qStopFrom, qStopTo;
	DayFlagArray qDays;
	
	QSqlDatabase qDb;
};


class PtssConnTableModel : public QSqlQueryModel
{
public:
	PtssConnTableModel(QObject *parent, QSqlDatabase db);
	virtual ~PtssConnTableModel() { }
	
	virtual int columnCount ( const QModelIndex & ) const { return 4; }
	virtual QVariant data(const QModelIndex &item, int role) const;
	QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
};



class PtssDb : public QObject
{
	Q_OBJECT

public:
	PtssDb(QString path);
	virtual ~PtssDb();
	
	QStringList getGroupsLabels();
	
	PtssGroupContentsModel *getGroupContentsModel(QString groupName) {
		_groupContentsModel->setGroupName(groupName);
		return _groupContentsModel;
	}
	
	PtssStopsTableModel *getStopsTableModel() { return _stopsModel; }
	
	PtssTimesTableModel *getTimesTableModel(QString link, int fromStop, int toStop, DayFlagArray days) {
		_timesModel->setParameters(link, fromStop, toStop, days);
		return _timesModel;
	}
	
	PtssConnTableModel *getConnTableModel();
	
	void removeStopRecord(const QModelIndex&);
	
	/**
	 * @param onlyBiggestGroup if true, only the numerically biggest found day group is
	 * 					returned; otherwise the found days are OR'ed
	**/
	DayFlagArray timetableDays(QString linkId, int fromStop, int toStop, bool onlyBiggestGroup=false);
	
	QStringList getUsedLinkIds();
	
	/**
	 * The single most important function of the program, took a few weeks to get here :-)
	**/
	QStringList getConnsFromGroupForTime(QString groupName, int day, int minute, int count);
	
	QString getSetting(QString name);
	void setSetting(QString name, QString val);
	
private:
	void initializeModels();
	
	/**
	 * The second most important function of the program, took a few weeks+minutes to get here :-)
	**/
	QList<SingleConnectionTime> getConnsFromGroupForDay(QString groupName, DayFlagArray day, int tag);
	
private:
	QSqlDatabase db;
	
	PtssGroupContentsModel *_groupContentsModel;
	PtssStopsTableModel *_stopsModel;
	PtssTimesTableModel *_timesModel;
	PtssConnTableModel *_connModel;
};

#endif //_PTSSDB_H_
