#ifndef _PTSS_CONFIGURATION_H_
#define _PTSS_CONFIGURATION_H_

#include "ui_ptssConfiguration.h"
#include "ptssDb.h"

class PtssConfiguration : public QWidget
{
	Q_OBJECT

public:
	PtssConfiguration(PtssDb *db, QWidget *parent=0);

public slots:
	void rmStop();
	void stopSelected();
	
	void updateGroupView();
	void updateTimesView_conn();
	void updateTimesView_day();
	void updateTimesView_unused(bool unused);
	
	void addConnToGroup();
	void rmConnFromGroup();
	
	void closeEvent(QCloseEvent * event);
	
signals:
	void closing();
	
private:
	void initGroups();
	void initStops();
	void initTimes();
	void initSettings();
	
	void updateGroupView_full();
	
	Ui::PtssConfiguration ui;
	
private:
	PtssDb *_db;
	QAbstractTableModel *stopsModel;
};

#endif /* _PTSS_CONFIGURATION_H_ */
