#include "ptssChooseConnection.h"
#include <QSortFilterProxyModel>
#include <QPushButton>
#include <assert.h>

PtssChooseConnection::PtssChooseConnection(PtssDb *db, QWidget *parent)
: QDialog(parent)
{
	_db=db;
	
	ui.setupUi(this);
	#ifdef Q_WS_MAEMO_5
		setAttribute(Qt::WA_Maemo5StackedWindow);
	#endif
	
	QAbstractItemModel *sm=_db->getConnTableModel();
	
	QSortFilterProxyModel *proxyModel = new QSortFilterProxyModel(this);
	proxyModel->setSourceModel(sm);
 
	ui.connection_tableView->setModel(proxyModel);
	ui.connection_tableView->setColumnHidden(3, true);
	ui.connection_tableView->resizeColumnsToContents();
	
	connect(ui.connection_tableView->selectionModel(), SIGNAL(selectionChanged(QItemSelection, QItemSelection)), this, SLOT(itemSelected()));
	
	itemSelected();
}

void PtssChooseConnection::itemSelected()
{
	ui.buttonBox->button(QDialogButtonBox::Ok)->setEnabled(
		!ui.connection_tableView->selectionModel()->selectedIndexes().empty()
	);
}

int PtssChooseConnection::getSelected()
{
	if (result()==Accepted) {
		assert(!ui.connection_tableView->selectionModel()->selectedIndexes().empty());
		
		return ui.connection_tableView->model()->data(
			ui.connection_tableView->model()->index(
				ui.connection_tableView->selectionModel()->selectedIndexes()[0].row(),
				3
			)
		).toInt();
	} else {
		return -1;
	}
}
