#ifndef ACCELEROMETERCONFIG_H
#define ACCELEROMETERCONFIG_H

#include <QMainWindow>
#include <QEventLoop>
#include <QPen>

namespace Ui {
    class AccelerometerConfig;
}

class AccelerometerConfig : public QMainWindow
{
    Q_OBJECT

public:
    explicit AccelerometerConfig(QWidget *parent = 0, int sens=0, int ydef=0, int maxValue=0);
    ~AccelerometerConfig();

    int GetSens();
    int GetYDef();
    int GetMaxValue();

public slots:
    void show();

private:
    Ui::AccelerometerConfig *ui;

    QEventLoop* m_Loop;
    QPixmap m_Pixmap;
    QPen m_Pen;
    QBrush m_Brush;

protected:
    void paintEvent(QPaintEvent *event);
    void hideEvent(QHideEvent *);
};

#endif // ACCELEROMETERCONFIG_H
