#include "savestateselect.h"
#include "ui_savestateselect.h"

#include <QDir>
#include "cfg.h"

SavestateSelect::SavestateSelect(QWidget *parent, RomInfo* rom) :
    QDialog(parent),
    ui(new Ui::SavestateSelect)
{
    ui->setupUi(this);

    ui->listWidget->setIconSize(QSize(160, 112));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(SavestateSelected(QListWidgetItem*)));

    m_Rom = rom;
    FillList();
}

SavestateSelect::~SavestateSelect()
{
    delete ui;
}

void SavestateSelect::FillList()
{
    QFileInfo f(m_Rom->SaveStateName);
    QDir dir;
    if (current_core == "pcsx")
        dir.setPath(sstate_path);
    else
        dir.setPath(rom_path);
    dir.setFilter(QDir::Files);
    dir.setSorting(QDir::Name | QDir::IgnoreCase);
    dir.setNameFilters(QStringList()<< QString("%1*").arg(f.completeBaseName()));

    m_List.clear();
    ui->listWidget->clear();
    foreach (QFileInfo f, dir.entryInfoList()) {
        if (f.size() > 0){
            QIcon icon;
            QString screenshot = QString("%1%2.%3").arg(screenshots_path).arg(m_Rom->FileName).arg(f.suffix());
            if (QFile::exists(screenshot))
                icon = QIcon(screenshot);
            else{
                QPixmap p("/opt/psx4m/no_data.png");
                icon = QIcon(p.scaled(160,112));
            }

            int slot = f.suffix().toInt();
            ui->listWidget->addItem(new QListWidgetItem(icon, QString("Slot %1: %2").arg(slot + 1)
                                                        .arg(f.lastModified().toString(Qt::SystemLocaleLongDate))));

            m_List.append(f.absoluteFilePath());
        }
    }

    if (m_List.count() > 0){
        ui->listWidget->setCurrentRow(0);
        SavestateSelected(NULL);
    }
}

void SavestateSelect::SavestateSelected(QListWidgetItem*)
{
    m_Selected = m_List.at(ui->listWidget->currentRow());
}

int SavestateSelect::Selected()
{
    QFileInfo f(m_Selected);
    return f.suffix().toInt() + 1;
}
