#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "rominfo.h"
#include "options.h"
#include "keys.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QSettings *settings;

public slots:
    void rom_config();
    void rom_exec();
    void rom_exec_savestate();

    void def_cfg();
    void gui_cfg();
    void open_help();
    void set_keys();

    void currentRowChanged ( int );
	void set_rom_dir();
	void set_bios_dir();
    void process_finished(int);
    void memory_cards();

private:
    void rom_exec(int slot);
    void get_roms();
    int count_save_states(QString name);

    Ui::MainWindow *ui;
    QList<RomInfo*> m_Roms;
    options *cfg;
    keys *keyopt;
    QLabel* lbl1;
    QLabel* lbl2;
    QProcess* myProcess;
    QByteArray get_pbp_icon(QString filename);

};

#endif // MAINWINDOW_H
