#include "memorycardselect.h"
#include "ui_memorycardselect.h"

#include <QDir>
#include "PSX_memory_card.h"

MemoryCardSelect::MemoryCardSelect(QWidget *parent, QString selected) :
    QDialog(parent),
    ui(new Ui::MemoryCardSelect)
{
    ui->setupUi(this);
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(MemoryCardSelected(QListWidgetItem*)));

    FillList();
    if (!selected.isEmpty()){
        int row = m_List.indexOf(selected);
        if (row >= 0){
            ui->listWidget->setCurrentRow(row);
            MemoryCardSelected(NULL);
        }
    }
}

MemoryCardSelect::~MemoryCardSelect()
{
    delete ui;
}

void MemoryCardSelect::FillList()
{
    QDir dir("/home/user/.pcsx/memcards/");
    dir.setFilter(QDir::Files);
    dir.setSorting(QDir::Name | QDir::IgnoreCase);
    dir.setNameFilters(QStringList()<<"*.mcd");

    m_List.clear();
    ui->listWidget->clear();
    int i = 0;
    foreach (QFileInfo f, dir.entryInfoList()) {
        if (f.size() > 0){
            PSX_memory_card* c = new PSX_memory_card();
            c->load_file(f.absoluteFilePath());

            ui->listWidget->addItem(tr("Memory card %1 [%2 slots used]").arg(i + 1).arg(c->get_used_slots()));
            m_List.append(f.absoluteFilePath());
            delete c;
            i++;
        }
    }

    if (m_List.count() > 0){
        ui->listWidget->setCurrentRow(0);
        MemoryCardSelected(NULL);
    }
}

void MemoryCardSelect::MemoryCardSelected(QListWidgetItem*)
{
    m_Selected = m_List.at(ui->listWidget->currentRow());
}

QString MemoryCardSelect::Selected()
{
    return m_Selected;
}
