#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "memorycardmanager.h"
#include "savestateselect.h"

QString game;
#ifdef Q_WS_MAEMO_5
QString cfg_path="/home/user/.config/Team16/psx4m/";
#else
QString cfg_path= QString("%1/.config/Team16/psx4m/").arg(QDir::homePath());
#endif
QString bios_path="/home/user/MyDocs/";
QString rom_path="/home/user/MyDocs";
QString sstate_path="/home/user/.pcsx/sstates/";
QString screenshots_path="/opt/maemo/usr/games/screenshots/";

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    myProcess = NULL;
    settings=new QSettings();
    bios_path=settings->value("bios_path","/home/user/MyDocs/").toString();
    if (bios_path.right(1)!="/") bios_path+="/";
    rom_path=settings->value("rom_path","/home/user/MyDocs/").toString();
    if (rom_path.right(1)!="/") rom_path+="/";

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    cfg=new options(this);
    cfg->hide();
    game="";
    cfg->load_cfg();


    QDir cfg_dir(cfg_path);
    if (!cfg_dir.exists()){
        if (!cfg_dir.mkdir(cfg_path))
            qDebug("Can't create cfg dir, permission error?");
        else
            cfg->save_cfg();
    }

    ui->listWidget->setStyleSheet("QListView::item{ height: 86px; }");
    ui->listWidget->setAutoFillBackground(true);
    ui->listWidget->setIconSize(QSize(144,80));

    get_roms();

    connect (ui->pushButton_2,SIGNAL(clicked()),this,SLOT(rom_config()));
    connect (ui->pushButton,SIGNAL(clicked()),this,SLOT(rom_exec()));
    connect (ui->pbnSstate,SIGNAL(clicked()),this,SLOT(rom_exec_savestate()));

    this->menuBar()->addAction("Default config",this,SLOT(def_cfg()));
    this->menuBar()->addAction("GUI config",this,SLOT(gui_cfg()));
    this->menuBar()->addAction("Configure keys",this,SLOT(set_keys()));
    this->menuBar()->addAction("Edit Memory cards",this,SLOT(memory_cards()));
    this->menuBar()->addAction("Help",this,SLOT(open_help()));

    connect(ui->listWidget,SIGNAL(currentRowChanged(int)),this,SLOT(currentRowChanged(int)));
}

void MainWindow::get_roms()
{
    qDebug() << "Reading roms from" << rom_path;
    m_Roms.clear();
    ui->listWidget->clear();
    QDir dir(rom_path);
    dir.setFilter(QDir::Files);
    dir.setSorting(QDir::Name | QDir::IgnoreCase);
    dir.setNameFilters(QStringList()<<"*.bin"<<"*.iso"<<"*.img"<<"*.z"<<"*.znx"<<"*.pbp");

    QFileInfoList list = dir.entryInfoList();
    foreach (QFileInfo fileInfo, list){
        if (fileInfo.fileName()=="scph1001.bin") continue;

        RomInfo* rom = new RomInfo();
        qDebug() << "  Rom:" << fileInfo.fileName();

        QIcon icon(":/images/ICON0.PNG");
        if (QFile::exists(QString("%1.png").arg(fileInfo.filePath())))
            icon = QIcon(QString("%1.png").arg(fileInfo.filePath()));
        else if (QFile::exists(QString("%1png").arg(fileInfo.filePath().replace(fileInfo.suffix(), ""))))
            icon = QIcon(QString("%1png").arg(fileInfo.filePath().replace(fileInfo.suffix(), "")));
        ui->listWidget->addItem(new QListWidgetItem(icon, fileInfo.fileName()));

        rom->FilePath = fileInfo.absoluteFilePath();
        rom->FileName = fileInfo.fileName();
        m_Roms.append(rom);
    }
    if (m_Roms.count() > 0){
        ui->listWidget->setCurrentRow(0);
        currentRowChanged(0);
    }
}

void MainWindow::rom_exec_savestate()
{
    SavestateSelect* dlg = new SavestateSelect(this, m_Roms.at(ui->listWidget->currentRow()));
    if (dlg->exec() == QDialog::Accepted){
        int slot = dlg->Selected();
        rom_exec(slot);
    }

}

void MainWindow::rom_exec(){
    rom_exec(-1);
}

void MainWindow::rom_exec(int slot)
{
    if (ui->listWidget->currentRow()!=-1){
        game=ui->listWidget->currentItem()->text();
        cfg->load_cfg();

        if (myProcess == NULL){
            ui->pushButton->setEnabled(false);
            ui->pushButton_2->setEnabled(false);
            ui->pbnSstate->setEnabled(false);
            myProcess = new QProcess(this);
            myProcess->setWorkingDirectory("/home/user/");
            connect(myProcess, SIGNAL(finished(int)), this, SLOT(process_finished(int)));

            QStringList args = current_config;
            args << m_Roms.at(ui->listWidget->currentRow())->FilePath;
            if (slot >= 0)
                args << "-load" << QString::number(slot);

            qDebug (QString("%1 %2").arg("/opt/maemo/usr/games/"+current_core).arg(args.join(" ")).toAscii());
            myProcess->start("/opt/maemo/usr/games/"+current_core, args);
            if (!myProcess->waitForStarted(10000)){
                qDebug() << "Failed to start process.";
                process_finished(-1);
            }
        }
    }
}

void MainWindow::process_finished(int)
{
    ui->pushButton->setEnabled(true);
    ui->pushButton_2->setEnabled(true);
    ui->pbnSstate->setEnabled(true);
    myProcess->deleteLater();
    myProcess = NULL;
}

void MainWindow::currentRowChanged ( int  ){
    if (ui->listWidget->currentRow()!=-1){
        game="";
        cfg->load_cfg();
        game=ui->listWidget->currentItem()->text();
        cfg->load_cfg();

        RomInfo* rom = m_Roms.at(ui->listWidget->currentRow());
        if (rom->SaveStateName.isEmpty()){
            if (current_core == "pcsx"){
                QProcess* p = new QProcess(this);
                p->setWorkingDirectory("/home/user/");
                QStringList args = QStringList() << "-cdfile" << rom->FilePath << "-get_sstatename" << "0";
                p->start("/opt/maemo/usr/games/pcsx", args);
                if (p->waitForFinished(3000)){
                    QString out = p->readAll();
                    QStringList lines = out.split("\n", QString::SkipEmptyParts);
                    foreach (QString line, lines){
                        line = line.trimmed();
                        if (line.startsWith("SAVESTATE:")){
                            QFileInfo f(line.remove(0, 8).trimmed());
                            rom->SaveStateName = f.fileName();
                            break;
                        }
                    }
                }else{
                    p->kill();
                }
                delete p;
            }else{
                QFileInfo f(rom->FileName);
                rom->SaveStateName = QString("%1.save.0").arg(f.fileName());
            }
        }

        int count = count_save_states(m_Roms.at(ui->listWidget->currentRow())->SaveStateName);
        ui->pbnSstate->setEnabled(count > 0);

/*        QString scr = QString("%1/%2_bkg.png").arg(rom_path).arg(game);
        if (QFile::exists(scr)){
            ui->listWidget->setStyleSheet(QString("QListView { \
                                                    background-image: url(%1); background-position: center; \
                                                    background-repeat: no-repeat; \
                                                    background-color: black; \
                                                    color: white; \
                                                   }    \
                                                   QListView::item { \
                                                       color: white; \
                                                       border-left: 1px solid black; \
                                                       border-top: 1px none black; \
                                                       border-bottom: 1px none black; \
                                                   } \
                                                   QListView::item:selected { \
                                                       color: white; \
                                                       background-color: rgba(0,0,0,125); \
                                                       border: 1px solid white; \
                                                   }").arg(scr));
        }else{
            ui->listWidget->setStyleSheet(QString("QListView { \
                                                    background-image: url(:/images/Gameboot.png); background-position: center; \
                                                    background-repeat: no-repeat; \
                                                    background-color: black; \
                                                    color: white; \
                                                   }    \
                                                   QListView::item { \
                                                       color: white; \
                                                       border-left: 1px solid black; \
                                                       border-top: 1px none black; \
                                                       border-bottom: 1px none black; \
                                                   } \
                                                   QListView::item:selected { \
                                                       color: white; \
                                                       background-color: rgba(0,0,0,125); \
                                                       border: 1px solid white; \
                                                   }"));
        }*/
    }
}

void MainWindow::set_keys(){
    keyopt=new keys(this);
    keyopt->show();
    keyopt = NULL;
}

void MainWindow::def_cfg()
{
    game="";
    cfg->load_cfg();
    cfg->setWindowTitle("Config: default");
    cfg->show();
}

void MainWindow::gui_cfg()
{
    QDialog *dlg=new QDialog(this);
    dlg->setMinimumWidth(200);
    dlg->setWindowTitle(tr("Gui config"));
    QGridLayout *lay=new QGridLayout(dlg);

    lbl1 = new QLabel(settings->value("rom_path").toString());
    lbl1->setWordWrap(true);
    lbl2 = new QLabel(settings->value("bios_path").toString());
    lbl2->setWordWrap(true);

    QPushButton *btn1=new QPushButton(tr("Rom directory"),dlg);
    QPushButton *btn2=new QPushButton(tr("Bios directory"),dlg);
    connect (btn1,SIGNAL(clicked()),this,SLOT(set_rom_dir()));
    connect (btn2,SIGNAL(clicked()),this,SLOT(set_bios_dir()));
    lay->addWidget(lbl1,1,0);
    lay->addWidget(btn1,2,0);
    lay->addWidget(lbl2,3,0);
    lay->addWidget(btn2 ,4,0);
    dlg->exec();
    delete dlg;
}

void MainWindow::set_rom_dir()
{
    QString dir=QFileDialog::getExistingDirectory(this,tr("ROM Directory"),"/home/user/MyDocs/");
    if (!dir.isEmpty()){
        rom_path=dir;
        settings->setValue("rom_path",rom_path);
        settings->sync();
        if (settings->status() != QSettings::NoError){
            QMessageBox msg;
            msg.setText("Can't save gui config, permission error?");
            msg.exec();
        }
        lbl1->setText(rom_path);
        get_roms();
    }
}

void MainWindow::set_bios_dir()
{
    QString dir=QFileDialog::getExistingDirectory(this,tr("BIOS Directory"),"/home/user/MyDocs/");
    if (!dir.isEmpty()){
        bios_path=dir;
        if (bios_path.right(1)!="/")bios_path+="/";
        settings->setValue("bios_path",bios_path);
        settings->sync();
        if (settings->status() != QSettings::NoError){
            QMessageBox msg;
            msg.setText("Can't save gui config, permission error?");
            msg.exec();
        }
        lbl2->setText(bios_path);
    }
}

void MainWindow::open_help() // Открытие страницы FAQ
{
    QDesktopServices::openUrl(QUrl("http://maemo.team16.ru/index.php?page=7"));
}


MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::rom_config()
{
    if (ui->listWidget->currentRow()!=-1){
        QString core = current_core;
        game=ui->listWidget->currentItem()->text();
        cfg->load_cfg();
        cfg->setWindowTitle(tr("Config: %1").arg(game));
        cfg->show();
        if (core != current_core){
            RomInfo* rom = m_Roms.at(ui->listWidget->currentRow());
            rom->SaveStateName.clear();
            currentRowChanged(ui->listWidget->currentRow());
        }
    }
}

void MainWindow::memory_cards()
{
    MemoryCardManager* dlg = new MemoryCardManager(this);
    dlg->show();
    dlg = NULL;
}

int MainWindow::count_save_states(QString name)
{
    int res = 0;

    QFileInfo f(name);
    QDir dir;
    if (current_core == "pcsx")
        dir.setPath(sstate_path);
    else
        dir.setPath(rom_path);
    dir.setFilter(QDir::Files);
    dir.setSorting(QDir::Name | QDir::IgnoreCase);
    dir.setNameFilters(QStringList()<< QString("%1*").arg(f.completeBaseName()));
    QFileInfoList list = dir.entryInfoList();

    res = list.count();
    return res;
}
