#ifndef MEMORYCARDMANAGER_H
#define MEMORYCARDMANAGER_H

#include <QMainWindow>
#include <QListWidgetItem>
#include "PSX_memory_card.h"

namespace Ui {
    class MemoryCardManager;
}

class MemoryCardManager : public QMainWindow
{
    Q_OBJECT

public:
    explicit MemoryCardManager(QWidget *parent = 0);
    ~MemoryCardManager();

public slots:
    void show();

private:
    Ui::MemoryCardManager *ui;
    int m_SelectedSlot;
    QString m_Filename;
    PSX_memory_card* m_Card;
    void UpdateSlotList();
    bool m_Modified;

#ifdef Q_WS_MAEMO_5
    QString GetMemoryCardName();
#endif

private slots:
    void LoadCard();
    void SaveCard();
    void DeleteSlot();
    void SlotChanged(QListWidgetItem*);
};

#endif // MEMORYCARDMANAGER_H
