#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "loadprev.h"
#include "memorycardmanager.h"

QString game;
#ifdef Q_WS_MAEMO_5
QString cfg_path="/home/user/.config/Team16/psx4m/";
#else
QString cfg_path= QString("%1/.config/Team16/psx4m/").arg(QDir::homePath());
#endif
QString bios_path="/home/user/MyDocs/";
QString rom_path="/home/user/MyDocs";
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    myProcess = NULL;
    settings=new QSettings();
    bios_path=settings->value("bios_path","/home/user/MyDocs/").toString();
    if (bios_path.right(1)!="/") bios_path+="/";
    rom_path=settings->value("rom_path","/home/user/MyDocs/").toString();
    if (rom_path.right(1)!="/") rom_path+="/";

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    cfg=new options(this);
    cfg->hide();
    game="";
    cfg->load_cfg();


    QDir cfg_dir(cfg_path);
    if (!cfg_dir.exists()){
        if (!cfg_dir.mkdir(cfg_path))
            qDebug("Can't create cfg dir, permission error?");
        else
            cfg->save_cfg();
    }

    ui->listWidget->setStyleSheet("QListView::item{ height: 86px; }");
    ui->listWidget->setAutoFillBackground(true);
    ui->listWidget->setIconSize(QSize(144,80));

    get_roms();

    connect (ui->pushButton_2,SIGNAL(clicked()),this,SLOT(rom_config()));
    connect (ui->pushButton,SIGNAL(clicked()),this,SLOT(rom_exec()));


    this->menuBar()->addAction("Default config",this,SLOT(def_cfg()));
    this->menuBar()->addAction("GUI config",this,SLOT(gui_cfg()));
    this->menuBar()->addAction("Configure keys",this,SLOT(set_keys()));
    this->menuBar()->addAction("Edit Memory cards",this,SLOT(memory_cards()));
    this->menuBar()->addAction("Help",this,SLOT(open_help()));

    connect(ui->listWidget,SIGNAL(currentRowChanged(int)),this,SLOT(currentRowChanged(int)));
}

void MainWindow::get_roms()
{
    qDebug() << "Reading roms from" << rom_path;
    roms.clear();
    ui->listWidget->clear();
    QDir dir(rom_path);
    dir.setFilter(QDir::Files);
    dir.setSorting(QDir::Name | QDir::IgnoreCase);
    dir.setNameFilters(QStringList()<<"*.bin"<<"*.iso"<<"*.img"<<"*.z"<<"*.znx");

    QFileInfoList list = dir.entryInfoList();
    int o=0;
    for (int i = 0; i < list.size(); ++i) {
        QFileInfo fileInfo = list.at(i);
        if (fileInfo.fileName()=="scph1001.bin") continue;
        qDebug() << "  Rom:" << fileInfo.fileName();

        QIcon icon(":/images/ICON0.PNG");
        if (QFile::exists(QString("%1.png").arg(fileInfo.filePath())))
            icon = QIcon(QString("%1.png").arg(fileInfo.filePath()));
        else if (QFile::exists(QString("%1png").arg(fileInfo.filePath().replace(fileInfo.suffix(), ""))))
            icon = QIcon(QString("%1png").arg(fileInfo.filePath().replace(fileInfo.suffix(), "")));
        ui->listWidget->addItem(new QListWidgetItem(icon, fileInfo.fileName()));
        roms.insert(o++,fileInfo.absoluteFilePath());
    }
    if (roms.count() > 0){
        ui->listWidget->setCurrentRow(0);
        currentRowChanged(0);
    }
}

void MainWindow::rom_exec(){
    if (ui->listWidget->currentRow()!=-1){
        if (current_core=="pcsx"){
            QDir sc("/opt/maemo/usr/games/screenshots");
            QStringList st=sc.entryList(QStringList(ui->listWidget->currentItem()->text()+".*"),QDir::NoFilter,QDir::NoSort);
            if (st.count()>1){
                bool ok;
                QList <int> savest;
                foreach(QString s,st)
                savest.append(s.split(".").last().toInt(&ok, 10));

                loadPrev *pr=new loadPrev(this);
                pr->init(current_config,current_core,roms.value(ui->listWidget->currentRow()),savest);
                pr->show();
                return;
            }
        }

        if (myProcess == NULL){
            ui->pushButton->setEnabled(false);
            ui->pushButton_2->setEnabled(false);
            myProcess = new QProcess(this);
            myProcess->setWorkingDirectory("/home/user/");
            connect(myProcess, SIGNAL(finished(int)), this, SLOT(process_finished(int)));

            QStringList args=current_config;
            //args<<roms.value(ui->listWidget->currentRow())<<"-save_name"<<(ui->listWidget->currentItem()->text());
            args<<roms.value(ui->listWidget->currentRow());
            qDebug (QString("%1 %2").arg("/opt/maemo/usr/games/"+current_core).arg(args.join(" ")).toAscii());

            myProcess->start("/opt/maemo/usr/games/"+current_core, args);
            if (!myProcess->waitForStarted(10000)){
                qDebug() << "Failed to start process.";
                process_finished(-1);
            }
        }
    }
}

void MainWindow::process_finished(int)
{
    ui->pushButton->setEnabled(true);
    ui->pushButton_2->setEnabled(true);
    myProcess->deleteLater();
    myProcess = NULL;
}

void MainWindow::currentRowChanged ( int  ){
    if (ui->listWidget->currentRow()!=-1){
        game="";
        cfg->load_cfg();
        game=ui->listWidget->currentItem()->text();
        cfg->load_cfg();

/*        QString scr = QString("%1/%2_bkg.png").arg(rom_path).arg(game);
        if (QFile::exists(scr)){
            ui->listWidget->setStyleSheet(QString("QListView { \
                                                    background-image: url(%1); background-position: center; \
                                                    background-repeat: no-repeat; \
                                                    background-color: black; \
                                                    color: white; \
                                                   }    \
                                                   QListView::item { \
                                                       color: white; \
                                                       border-left: 1px solid black; \
                                                       border-top: 1px none black; \
                                                       border-bottom: 1px none black; \
                                                   } \
                                                   QListView::item:selected { \
                                                       color: white; \
                                                       background-color: rgba(0,0,0,125); \
                                                       border: 1px solid white; \
                                                   }").arg(scr));
        }else{
            ui->listWidget->setStyleSheet(QString("QListView { \
                                                    background-image: url(:/images/Gameboot.png); background-position: center; \
                                                    background-repeat: no-repeat; \
                                                    background-color: black; \
                                                    color: white; \
                                                   }    \
                                                   QListView::item { \
                                                       color: white; \
                                                       border-left: 1px solid black; \
                                                       border-top: 1px none black; \
                                                       border-bottom: 1px none black; \
                                                   } \
                                                   QListView::item:selected { \
                                                       color: white; \
                                                       background-color: rgba(0,0,0,125); \
                                                       border: 1px solid white; \
                                                   }"));
        }*/
    }
}

void MainWindow::set_keys(){
    keyopt=new keys(this);
    keyopt->show();
    keyopt = NULL;
}

void MainWindow::def_cfg()
{
    game="";
    cfg->setWindowTitle("Config: default");
    cfg->show();
}

void MainWindow::gui_cfg()
{
    QDialog *dlg=new QDialog(this);
    dlg->setMinimumWidth(200);
    dlg->setWindowTitle(tr("Gui config"));
    QGridLayout *lay=new QGridLayout(dlg);

    lbl1 = new QLabel(settings->value("rom_path").toString());
    lbl1->setWordWrap(true);
    lbl2 = new QLabel(settings->value("bios_path").toString());
    lbl2->setWordWrap(true);

    QPushButton *btn1=new QPushButton(tr("Rom directory"),dlg);
    QPushButton *btn2=new QPushButton(tr("Bios directory"),dlg);
    connect (btn1,SIGNAL(clicked()),this,SLOT(set_rom_dir()));
    connect (btn2,SIGNAL(clicked()),this,SLOT(set_bios_dir()));
    lay->addWidget(lbl1,1,0);
    lay->addWidget(btn1,2,0);
    lay->addWidget(lbl2,3,0);
    lay->addWidget(btn2 ,4,0);
    dlg->exec();
    delete dlg;
}

void MainWindow::set_rom_dir()
{
    QString dir=QFileDialog::getExistingDirectory(this,tr("ROM Directory"),"/home/user/MyDocs/");
    if (!dir.isEmpty()){
        rom_path=dir;
        settings->setValue("rom_path",rom_path);
        settings->sync();
        if (settings->status() != QSettings::NoError){
            QMessageBox msg;
            msg.setText("Can't save gui config, permission error?");
            msg.exec();
        }
        lbl1->setText(rom_path);
        get_roms();
    }
}

void MainWindow::set_bios_dir()
{
    QString dir=QFileDialog::getExistingDirectory(this,tr("BIOS Directory"),"/home/user/MyDocs/");
    if (!dir.isEmpty()){
        bios_path=dir;
        if (bios_path.right(1)!="/")bios_path+="/";
        settings->setValue("bios_path",bios_path);
        settings->sync();
        if (settings->status() != QSettings::NoError){
            QMessageBox msg;
            msg.setText("Can't save gui config, permission error?");
            msg.exec();
        }
        lbl2->setText(bios_path);
    }
}

void MainWindow::open_help() // Открытие страницы FAQ
{
    QDesktopServices::openUrl(QUrl("http://maemo.team16.ru/index.php?page=7"));
}


MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::rom_config()
{
    if (ui->listWidget->currentRow()!=-1){
        cfg->setWindowTitle(tr("Config: %1").arg(game));
        cfg->show();
    }
}

void MainWindow::memory_cards()
{
    MemoryCardManager* dlg = new MemoryCardManager(this);
    dlg->show();
    dlg = NULL;
}
