#include "keysconfigselect.h"
#include "ui_keysconfigselect.h"

#include <QDir>
#include <QSettings>
#include <QInputDialog>
#include "keys.h"

extern QString keys_path;
KeysConfigSelect::KeysConfigSelect(QWidget *parent, QString selected) :
    QDialog(parent),
    ui(new Ui::KeysConfigSelect)
{
    ui->setupUi(this);
    connect(ui->pbnNew, SIGNAL(clicked()), this, SLOT(AddNew()));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
#ifdef Q_WS_MAEMO_5
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(KeysConfigSelected(QListWidgetItem*)));
#else
    connect(ui->listWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(KeysConfigSelected(QListWidgetItem*)));
#endif

    FillList();
    if (!selected.isEmpty()){
        int row = m_List.keys().indexOf(selected);
        if (row >= 0){
            ui->listWidget->setCurrentRow(row);
            KeysConfigSelected(NULL);
        }
    }
}

KeysConfigSelect::~KeysConfigSelect()
{
    delete ui;
}

void KeysConfigSelect::FillList()
{
    m_List = keys::configList();
    ui->listWidget->clear();

    QList<QString> keys = m_List.keys();
    qSort(keys.begin(), keys.end());

    foreach (QString name, keys){
        QString file = m_List[name];
        ui->listWidget->addItem(name);
        m_List[name] = file;
    }

    if (m_List.count() > 0){
        ui->listWidget->setCurrentRow(0);
        KeysConfigSelected(NULL);
    }
}

void KeysConfigSelect::KeysConfigSelected(QListWidgetItem*)
{
    m_Selected = m_List[ui->listWidget->currentItem()->text()];
    m_SelectedName = ui->listWidget->currentItem()->text();
}

QString KeysConfigSelect::Selected()
{
    return m_Selected;
}

QString KeysConfigSelect::SelectedName()
{
    return m_SelectedName;
}

void KeysConfigSelect::AddNew()
{
    bool ok;
    QString text = QInputDialog::getText(this, tr("Keys config name"),
                                         tr("Name:"), QLineEdit::Normal,
                                         "", &ok);
    if (ok && !text.isEmpty()){
        if (m_List.keys().contains(text)){
            QMessageBox msg(this);
            msg.setWindowTitle(tr("Error"));
            msg.setText(tr("Invalid name!"));
            msg.exec();
            return;
        }

        m_SelectedName = text;
        m_Selected = QString("%1%2").arg(keys_path).arg(text.replace(" ", "_"));
        accept();
    }
}
