#include "keys.h"

extern QString keys_path;

void sh_key::keyPressEvent ( QKeyEvent * event ){
    this->setText(QString("%1").arg(event->nativeScanCode()));
    event->ignore();
}

sh_key::sh_key(QWidget *parent) :
        QLineEdit(parent)
{
    this->setAlignment(Qt::AlignCenter);
    this->setInputMethodHints(Qt::ImhNoPredictiveText);
}



keys::keys(QWidget *parent, QString filename, QString name) :
        QWidget(parent)
{
    if (filename.isEmpty())
        filename = defaultFile();
    m_Filename = filename;

    if (name.isEmpty())
        name = "Default";
    m_Name = name;
    ks=QStringList()<<tr("Left")<<tr("Right")<<tr("Up")
                                <<tr("Down")<<tr("O/GunCon B")<<tr("X/GunCon A")<<tr("Triangle/GunCon Trigger")
                                <<tr("Square/GunCon Trigger 2")<<tr("Select")<<tr("Start")
                                <<tr("L1")<<tr("R1")<<tr("L2")<<tr("R2")<<tr("Quit")
                                <<tr("Up+Left")<<tr("Up+Right")
                                <<tr("Down+Left")<<tr("Down+Right")
                                <<tr("Save")<<tr("Load")<<tr("Slot+")<<tr("Slot-")<<tr("Change disc");

    this->setWindowTitle(tr("Configure keys"));
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    this->setContentsMargins(0,0,0,0);
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    QScrollArea *area=new QScrollArea(this);
    area->setContentsMargins(0,0,0,0);
    QVBoxLayout *lay=new QVBoxLayout(this);
    lay->setSizeConstraint(QLayout::SetMinAndMaxSize);
    lay->setContentsMargins(0,0,0,0);
    lay->addWidget(area);
    QWidget *wg=new QWidget();
    area->setWidget(wg);
    wg->setMinimumSize(600,1200);
    QGridLayout *grid=new QGridLayout(wg);
    grid->setSizeConstraint(QLayout::SetMinAndMaxSize);
    grid->setContentsMargins(0,0,0,0);
    wg->show();
    area->show();
    grid->setHorizontalSpacing(25);
    grid->setVerticalSpacing(10);

    // load current
    QFile file(m_Filename);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
        QMessageBox msg(this);
        msg.setText(tr("Couldn't open previous key config"));
        msg.exec();
    }

    int o=0;
    QTextStream in(&file);
    while ((o<ks.count())) {
        QString line="0";
        if (!in.atEnd())
            line = in.readLine();

        QLabel *lbl=new QLabel(ks.at(o),wg);
        grid->addWidget(lbl,o,1,1,1);

        nkey[o]=new sh_key(wg);
        nkey[o]->setFixedSize(250, 60);
        nkey[o]->setParent(wg);

        grid->addWidget(nkey[o],o,0,1,1);
        grid->setRowMinimumHeight(o,60);
        nkey[o]->show();
        nkey[o]->setText(line.trimmed());
        o++;
    }

}

void keys::hideEvent(QHideEvent *)
{
    if (!this->isVisible()){
        QMessageBox msg(this);
        msg.setWindowTitle(tr("Confirm"));
        msg.setText(tr("Do you want to save settings?"));
        msg.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        if (msg.exec() == QMessageBox::Yes)
            save();
    }
}

void keys::save()
{
    QString sv="";
    for (int i=0;i<ks.count();i++)
        sv=sv+QString("%1\n").arg(nkey[i]->text());

    qDebug() << "Saving keys to" << m_Filename;
    QFile file(m_Filename);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
        QMessageBox msg(this);
        msg.setText("Somethings goes wrong, check permission to keys file");
        msg.exec();
        return;
    }

    QHash<QString, QString> list = configList();
    if (!list.keys().contains(m_Name)){
        list[m_Name] = m_Filename;
    }

    QSettings settings;
    settings.beginWriteArray("keysconfig");
    int index = 0;

    QList<QString> keys = list.keys();
    qSort(keys.begin(), keys.end());
    foreach (QString name, keys){
        settings.setArrayIndex(index);
        settings.setValue("name", name);
        settings.setValue("file", list[name]);
        index++;
    }
    settings.endArray();
    settings.sync();

    QTextStream out(&file);
    out <<sv;
}

keys::~keys()
{

}

int keys::keysConfigCount()
{
    QSettings* settings=new QSettings();

    int count = settings->beginReadArray("keysconfig");
    settings->endArray();
    delete settings;

    return count;
}

QString keys::defaultFile()
{
    return QString("%1keys").arg(keys_path);
}

QHash<QString, QString> keys::configList()
{
    QHash<QString, QString> res;
    QSettings* settings = new QSettings();

    int count = settings->beginReadArray("keysconfig");
    for (int i=0; i<count; i++){
        settings->setArrayIndex(i);
        QString name = settings->value("name").toString();
        QString file = settings->value("file").toString();
        res[name] = file;
    }
    settings->endArray();
    delete settings;

    if (res.count() == 0 && QFile::exists(defaultFile()))
        res["Default"] = defaultFile();

    return res;
}
