#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QCoreApplication::setOrganizationName("Team16");
    QCoreApplication::setOrganizationDomain("team16.ru");
    QCoreApplication::setApplicationName("psx4m-gui");


    settings=new QSettings();

    fps_show=settings->value("fps-show",false).toBool();
    cycle=settings->value("cycle",1).toInt();
    frameskiping=settings->value("frame-skipping",0).toInt();
    abbey=settings->value("abbey",false).toBool();


    path =    settings->value("rom-path","/home/user/MyDocs").toString();

    QDir dir(path);
         dir.setFilter(QDir::Files);
         dir.setSorting(QDir::Name);
dir.setNameFilters(QStringList()<<"*.bin"<<"*.iso"<<"*.img");

         QFileInfoList list = dir.entryInfoList();
         for (int i = 0; i < list.size(); ++i) {
             QFileInfo fileInfo = list.at(i);
             ui->listWidget->addItem(new QListWidgetItem(fileInfo.fileName()));
             roms.insert(i,fileInfo.absoluteFilePath());
         }
         connect(ui->pushButton,SIGNAL(clicked()),this,SLOT(runGame()));


         QMenu *fsk=new QMenu(tr("Frameskip"));
         QActionGroup *gr=new QActionGroup(fsk);
         for (int i=0;i<=8;i++){

             QAction *nm=fsk->addAction(QString("%1").arg(i),this,SLOT(fm_skip_ch()));
             nm->setActionGroup(gr);
             nm->setCheckable(true);
             if (i==frameskiping)nm->setChecked(true);

         }

         QActionGroup *gr2=new QActionGroup(fsk);

         QMenu *cml=new QMenu(tr("Cycle multiplier"));
         for (int i=0;i<=10;i++){
             QAction *nm=cml->addAction(QString("%1").arg(i),this,SLOT(cml_ch()));
             nm->setActionGroup(gr2);
             nm->setCheckable(true);
             if (i==cycle)nm->setChecked(true);
         }


         fpsm=new QAction(tr("Show FPS"),&opt);
         fpsm->setCheckable(true);
         fpsm->setChecked(fps_show);
         opt.addAction(fpsm);

         abbm=new QAction(tr("Abe's Oddysee Fix"),&opt);
         abbm->setCheckable(true);
         abbm->setChecked(abbey);
         opt.addAction(abbm);

         opt.addMenu(fsk);
         opt.addMenu(cml);
         opt.addAction(tr("Select directory"),this,SLOT(select_dir()));

         ui->checkBox->setChecked(settings->value("nosound",false).toBool());


        this->menuBar()->addAction(tr("Options"),&opt,SLOT(show()));
        keyopt=new keys(this);

        this->menuBar()->addAction(tr("Configure keys"),keyopt,SLOT(exec()));
        this->setWindowTitle("PSX4M-Gui");
}
void MainWindow::select_dir(){
    QString dir;
   QString directory=QFileDialog::getExistingDirectory(this,tr("Select directory"),dir,QFileDialog::ShowDirsOnly);
   if (!directory.isEmpty()){
       path =  directory;
       settings->setValue("rom-path",path);
   ui->listWidget->clear();
   roms.clear();
       QDir dir(path);
            dir.setFilter(QDir::Files);
            dir.setSorting(QDir::Name);
   dir.setNameFilters(QStringList()<<"*.bin"<<"*.iso"<<"*.img");

            QFileInfoList list = dir.entryInfoList();
            for (int i = 0; i < list.size(); ++i) {
                QFileInfo fileInfo = list.at(i);
                ui->listWidget->addItem(new QListWidgetItem(fileInfo.fileName()));
                roms.insert(i,fileInfo.absoluteFilePath());
            }
   }
}

void MainWindow::fm_skip_ch(){
    QAction *action = qobject_cast<QAction *>(sender());
    frameskiping=action->text().toInt();
    settings->setValue("frame-skipping",frameskiping);
}
void MainWindow::cml_ch(){
    QAction *action = qobject_cast<QAction *>(sender());
    cycle=action->text().toInt();
    settings->setValue("cycle",cycle);
}

void MainWindow::runGame(){
    if (!QFile("/home/user/MyDocs/scph1001.bin").exists()){
        QMessageBox msg;
        msg.setText(tr("Error! No bios found\nPut your bios at /home/user/MyDocs/scph1001.bin"));
        msg.exec();
        return;
    }

    if (ui->listWidget->currentRow()==-1){
        QMessageBox msg;
        msg.setText(tr("No rom selected"));
        msg.exec();
        return;}

    QString file=roms.value(ui->listWidget->currentRow());
    /*
./psx4m [options] [CD IMAGE FILE]
        options:
        -h -help --help This help
        -runcd          Runs CdRom
        -psxout         Enable stdout output
        -load STATENUM  Loads savestate STATENUM (1-5)
        -nosound        Disable sound
        -showfps        Show FPS
        -frameskip 0-8  Frame skipping ratio
        -cyclemult 0-10 CPU cycle multiplier
        -ilace 0,1,3,7  Interlace lines
        FILE            CdRom file
*/
QString launch=QString("/opt/maemo/usr/games/psx4m -runcd -load 1");

if (frameskiping!=0)launch+=QString(" --frameskip %1").arg(frameskiping);
if (cycle!=0)launch+=QString(" -cyclemult %1").arg(cycle);

if (ui->checkBox->isChecked())launch+=" -nosound";
if (fpsm->isChecked())launch+=" -showfps";
if (abbm->isChecked())launch+=" -abbeyfix";

launch+=" \""+file+"\"";
qDebug(launch.toAscii());
system(launch.toAscii());
}

MainWindow::~MainWindow()
{
    settings->setValue("nosound",ui->checkBox->isChecked());
    settings->sync();
    delete ui;
}
