#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QTimer>
#include <QDebug>
#include <aboutwindow.h>
#include <compatibilitywindow.h>
#include <kernelmessageswindow.h>
#include <procwatch.h>
#include <helpwindow.h>
#include <QFile>
#include <QPainter>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#include <QMaemo5ValueButton>
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
public slots:
    void setBackgroundImage(const QString &image);

private:
    Ui::MainWindow *ui;
    void connectSignals();
    QString m_BackgroundImage;
    void paintEvent(QPaintEvent*);
    procwatch *myProcWatch;
    QProcess *JBProcess;
#ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton *jailbreakOnButton;
    QMaemo5ValueButton *jailbreakOnHermesButton;
#else
    QPushButton *jailbreakOnButton;
    QPushButton *jailbreakOnHermesButton;
#endif

private slots:
    void about();
    void kernelmessages();
    void CL();
    void jailbreakOn();
    void jailbreakOnHermes();
    void jailbreakOff();
    void helpWindow();
    void orientationChanged();
    void selectFirmware(int);
};

#endif // MAINWINDOW_H
