#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "ui_aboutwindow.h"

//Creating procwatch object, needed for /proc/psfreedom/status reading.

//procwatch *myProcWatch = new procwatch(this);

// Constructor

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    // setup the UI
    ui->setupUi(this);
    ui->jailbreakOffButton->hide();
    ui->firmwareList->hide();
#ifdef Q_WS_MAEMO_5
    jailbreakOnButton = new QMaemo5ValueButton(this);
    jailbreakOnHermesButton = new QMaemo5ValueButton(this);
    jailbreakOnButton->setValueText(tr("PL3 modules"));
    jailbreakOnButton->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    jailbreakOnHermesButton->setValueText(tr("Hermes modules"));
    jailbreakOnHermesButton->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
#else
    jailbreakOnButton = new QPushButton(this);
    jailbreakOnHermesButton = new QPushButton(this);
#endif
    jailbreakOnButton->setObjectName(QString::fromUtf8("jailbreakOnButton"));
    jailbreakOnButton->setGeometry(QRect(175, 190, 221, 95));
    jailbreakOnButton->setText(tr("Jailbreak mode on"));
    jailbreakOnHermesButton->setObjectName(QString::fromUtf8("jailbreakOnHermesButton"));
    jailbreakOnHermesButton->setGeometry(QRect(400, 190, 221, 95));
    ui->jailbreakOffButton->setGeometry(QRect(175, 190, 447, 95));
    ui->jigCheckBox->setGeometry(QRect(173, 290, 225, 70));
    jailbreakOnHermesButton->setText(tr("Jailbreak mode on"));
    // Set background -- Don't use styleSheets, they cause bugs in PR 1.3 :/ - thanks alterego (QPainter fix)
    //QMainWindow::setStyleSheet(("MainWindow { background-image: url(:/images/images/psfreedombg.png); }"));
    this->setBackgroundImage(":/images/images/psfreedombg.png");
#ifdef Q_WS_MAEMO_5
    // Set stacked window attribute to the main window.
    setAttribute(Qt::WA_Maemo5StackedWindow);
    // Allow portrait mode.
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    // connect all UI buttons to their functions
    connectSignals();
    myProcWatch = new procwatch(this);
    JBProcess = new QProcess(this);
    // Show "Ready" in status bar
    statusBar()->showMessage(tr("Ready"));
    qDebug() << "MainWindow: UI ready.";
}

// About, ties with aboutwindow.(cpp/h)

void MainWindow::about()
{
    setWindowFlags(windowFlags() | Qt::Window);
    AboutWindow *myAboutWindow = new AboutWindow(this);
    myAboutWindow->show();
}

// Games list.
void MainWindow::CL()
{
    setWindowFlags(windowFlags() | Qt::Window);
    CompatibilityWindow *myCompatibilityWindow = new CompatibilityWindow(this);
    myCompatibilityWindow->show();
}

// Kernel Messages

void MainWindow::kernelmessages()
{
    setWindowFlags(windowFlags() | Qt::Window);
    KernelMessagesWindow *myKernelMessagesWindow = new KernelMessagesWindow(this);
    myKernelMessagesWindow->show();
}

void MainWindow::helpWindow()
{
    setWindowFlags(windowFlags() | Qt::Window);
    HelpWindow *myHelpWindow = new HelpWindow(this);
    myHelpWindow->show();
}

// Jailbreak mode on, PL3

void MainWindow::jailbreakOn()
{
    QStringList PL3parameters;
    PL3parameters << "--pl3";
    JBProcess->environment() = QProcess::systemEnvironment();
    JBProcess->start("/usr/sbin/psfreedom-enable-n900.sh", PL3parameters);
    JBProcess->waitForFinished();
    if(JBProcess->exitCode() == 0) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Jailbreak mode enabled"));
#endif
        if(ui->jigCheckBox->isChecked()) {
            // We'll hide it later.
            //ui->jigCheckBox->hide();
            PL3parameters << "--jig";
        }
        // Start QTimer!
        qDebug() << "MainWindow: Starting QTimer...";
        myProcWatch->startTimer();
        // Hide buttons
        jailbreakOnHermesButton->hide();
        jailbreakOnButton->hide();
        if(!ui->jigCheckBox->isHidden())
            ui->jigCheckBox->hide();
        // Show off button
        ui->jailbreakOffButton->show();           
        // Update status message
        if(ui->jigCheckBox->isChecked()){
            statusBar()->showMessage(tr("Jailbreak mode enabled. Service mode enabled"));
        } else {
            statusBar()->showMessage(tr("Jailbreak mode enabled.  Firmware: 3.41"));
            ui->firmwareList->show();
        }
        qDebug() << "MainWindow: starting red LED...";
        system("dbus-send --system --type=method_call --dest=com.nokia.mce \
               /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:'PatternJailbreakStarted' &");
        QFile firstStartFile("/home/user/.psfreedom_ran");
        if(firstStartFile.exists())
            qDebug() << "MainWindow: this is not the first run.";
        else {
            qDebug() << "MainWindow: first startup detected, showing help window.";
            firstStartFile.open(QIODevice::Append);
            firstStartFile.write("");
            firstStartFile.close();
            firstStartFile.setPermissions(QFile::WriteOther);
            this->helpWindow();
#ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this, tr("PSFreedom has detected that this is the first run."));
#endif
        }
    } else {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("<br><b>An error has occured</b><br>")
                                           + JBProcess->readAllStandardError().append("<br>"),
                                           QMaemo5InformationBox::NoTimeout);
#endif
    }

}

// Hermes

void MainWindow::jailbreakOnHermes()
{
    QStringList HermesParameters;
    HermesParameters << "--hermes";
    JBProcess->start("/usr/sbin/psfreedom-enable-n900.sh", HermesParameters);
    JBProcess->waitForFinished();
    if(JBProcess->exitCode() == 0) {
#ifdef Q_WS_MAEMO_5
        // Yellow information bar
        QMaemo5InformationBox::information(this, tr("Jailbreak mode enabled"));
#endif
        // Start QTimer!
        qDebug() << "MainWindow: Starting QTimer...";
        myProcWatch->startTimer();
        // Hide all buttons
        jailbreakOnButton->hide();
        jailbreakOnHermesButton->hide();
        ui->jigCheckBox->hide();
        // Show off button
        ui->jailbreakOffButton->show();
        // Don't show firmware list, hermes doesn't have support for different firmwares(???)
        // ui->firmwareList->hide();
        if(ui->jigCheckBox->isChecked()){
            ui->jigCheckBox->setChecked(false);
    #ifdef Q_WS_MAEMO_5
                QMaemo5InformationBox::information(this, tr("PSFreedom jig mode is only supported with PL3 modules"));
    #endif
        }
        // Update status message
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.41"));
        qDebug() << "MainWindow: starting red LED...";
        system("dbus-send --system --type=method_call --dest=com.nokia.mce \
               /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:'PatternJailbreakStarted' &");
        QFile firstStartFile("/home/user/.psfreedom_ran");
        if(firstStartFile.exists())
            qDebug() << "MainWindow: this is not the first run.";
        else {
            qDebug() << "MainWindow: first startup detected, showing help window.";
            firstStartFile.open(QIODevice::Append);
            firstStartFile.write("");
            firstStartFile.close();
            firstStartFile.setPermissions(QFile::WriteOther);
            this->helpWindow();
#ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this, tr("PSFreedom has detected that this is the first run."));
#endif
        }
    } else {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("<br><b>An error has occured</b><br>")
                                           + JBProcess->readAllStandardError().append("<br>"),
                                           QMaemo5InformationBox::NoTimeout);
#endif
    }
}

// Jailbreak mode off, what do when the button is pressed

void MainWindow::jailbreakOff()
{
    qDebug() << "MainWindow: disabling jailbreak mode.";
    JBProcess->start("/usr/sbin/psfreedom-disable-n900.sh");
    JBProcess->waitForFinished();
    JBProcess->kill();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Jailbreak mode disabled"));
#endif
    jailbreakOnButton->show();
    ui->jigCheckBox->setEnabled(true);
    jailbreakOnHermesButton->show();
    ui->jailbreakOffButton->hide();
    // Hide firmware combobox
    ui->firmwareList->hide();
    if(ui->jigCheckBox->isHidden())
        ui->jigCheckBox->show();
    statusBar()->showMessage(tr("Jailbreak mode disabled"));
    // Turn off LEDs using dbus, need to use proper dbus here...
    qDebug() << "MainWindow: Turning off LEDs.";
    system("run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce \
           /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:'PatternJailbreakComplete' &");
    system("run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce \
           /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:'PatternJailbreakStarted' &");
    if(myProcWatch->timer->isActive())
        myProcWatch->timer->stop();
}

void MainWindow::selectFirmware(int firmware)
{
    QFile fwVersionFile("/proc/psfreedom/fw_version");
    fwVersionFile.open(QIODevice::WriteOnly);
    switch (firmware) {
    case 0:
        qDebug() << "MainWindow: selecting 3.41.";
        // system() is bad.
        //system("echo 3.41 > /proc/psfreedom/fw_version");
        fwVersionFile.write("3.41");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.41"));
        break;
    case 1:
        qDebug() << "MainWindow: selecting 3.40.";
        fwVersionFile.write("3.40");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.40"));
        break;
    case 2:
        qDebug() << "MainWindow: selecting 3.30.";
        fwVersionFile.write("3.30");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.30"));
        break;
    case 3:
        qDebug() << "MainWindow: selecting 3.21.";
        fwVersionFile.write("3.21");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.21"));
        break;
    case 4:
        qDebug() << "MainWindow: selecting 3.15.";
        fwVersionFile.write("3.15");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.15"));
        break;
    case 5:
        qDebug() << "MainWindow: selecting 3.10.";
        fwVersionFile.write("3.10");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.10"));
        break;
    case 6:
        qDebug() << "MainWindow: selecting 3.01.";
        fwVersionFile.write("3.01");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.01"));
        break;
    case 7:
        qDebug() << "MainWindow: selecting 2.76.";
        fwVersionFile.write("2.76");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 2.76"));
        break;
    }
    fwVersionFile.close();
}

void MainWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        // Landscape mode
        qDebug() << "MainWindow: Orientation changed: Landscape.";
        this->setBackgroundImage(":/images/images/psfreedombg.png");
        ui->jailbreakOffButton->setGeometry(QRect(175, 200, 447, 95));
        jailbreakOnButton->setGeometry(QRect(170, 200, 221, 95));
        jailbreakOnHermesButton->setGeometry(QRect(400, 200, 221, 95));
        ui->firmwareList->setGeometry(QRect(370, 310, 61, 51));
        ui->jigCheckBox->setGeometry(QRect(170, 295, 221, 70));
    } else {
        // Portrait mode
        qDebug() << "MainWindow: Orientation changed: Portrait.";
        this->setBackgroundImage(":/images/images/psfreedomportraitbg.png");
        ui->jailbreakOffButton->setGeometry(QRect(20, 340, 447, 130));
        jailbreakOnButton->setGeometry(QRect(20, 340, 221, 130));
        jailbreakOnHermesButton->setGeometry(QRect(240, 340, 221, 130));
        ui->firmwareList->setGeometry(QRect(200, 500, 70, 60));
        ui->jigCheckBox->setGeometry(QRect(20, 480, 221, 70));
    }
}

void MainWindow::connectSignals()
{
    connect(jailbreakOnButton, SIGNAL(clicked()), this, SLOT(jailbreakOn())); // on button
    connect(jailbreakOnHermesButton, SIGNAL(clicked()), this, SLOT(jailbreakOnHermes())); // on (hermes) button
    connect(ui->jailbreakOffButton, SIGNAL(clicked()), this, SLOT(jailbreakOff())); // off button
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(about())); // about menu item
    connect(ui->actionKernel_Messages, SIGNAL(triggered()), this, SLOT(kernelmessages())); // kernel messages menu item
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(helpWindow())); // help window
    connect(ui->actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt())); // about Qt
    connect(ui->actionCompatibility_list, SIGNAL(triggered()), this, SLOT(CL())); // Compatibility Browser
    connect(ui->firmwareList, SIGNAL(activated(int)), this, SLOT(selectFirmware(int))); // Firmware list
#ifdef Q_WS_MAEMO_5
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
#endif
}

void MainWindow::setBackgroundImage(const QString &image)
{
    this->m_BackgroundImage = image;
    this->update();
}

void MainWindow::paintEvent(QPaintEvent*)
{
    QPainter painter(this);
    painter.drawImage(this->rect(), QImage(this->m_BackgroundImage));
}

// Destorys the MainWindow

MainWindow::~MainWindow()
{
    qDebug() << "MainWindow: caught quit signal, exiting...";
    jailbreakOff();
    delete ui;
}
